/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.embeddable;

import com.sun.enterprise.admin.cli.embeddable.CommandExecutorImpl;
import com.sun.enterprise.util.io.FileUtils;
import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.admin.payload.PayloadFilesManager;
import org.glassfish.admin.payload.PayloadImpl;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandInvocation;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.Payload;
import org.glassfish.embeddable.Deployer;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.InternalSystemAdministrator;
import org.jvnet.hk2.annotations.ContractsProvided;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
@ContractsProvided(value={DeployerImpl.class, Deployer.class})
public class DeployerImpl
implements Deployer {
    private static final Logger logger = Logger.getLogger(DeployerImpl.class.getPackage().getName());
    @Inject
    private ServiceLocator habitat;
    @Inject
    private InternalSystemAdministrator kernelIdentity;

    @Override
    public String deploy(URI archive, String ... params) throws GlassFishException {
        File file;
        try {
            file = this.convertToFile(archive);
        }
        catch (IOException e) {
            throw new GlassFishException("Unable to make a file out of " + String.valueOf(archive), e);
        }
        return this.deploy(file, params);
    }

    @Override
    public String deploy(File file, String ... params) throws GlassFishException {
        String[] newParams = new String[params.length + 1];
        System.arraycopy(params, 0, newParams, 0, params.length);
        newParams[params.length] = file.getAbsolutePath();
        CommandExecutorImpl executer = this.habitat.getService(CommandExecutorImpl.class, new Annotation[0]);
        try {
            File retrieve;
            String command = "deploy";
            ActionReport actionReport = executer.createActionReport();
            ParameterMap commandParams = executer.getParameters(command, newParams);
            CommandInvocation<?> inv = executer.getCommandRunner().getCommandInvocation(command, actionReport, this.kernelIdentity.getSubject());
            inv.parameters(commandParams);
            PayloadImpl.Outbound outboundPayload = null;
            String retrieveOpt = (String)commandParams.getOne("retrieve");
            File file2 = retrieve = retrieveOpt != null ? new File(retrieveOpt) : null;
            if (retrieve != null && retrieve.exists()) {
                outboundPayload = PayloadImpl.Outbound.newInstance();
                inv.outbound(outboundPayload);
            }
            inv.execute();
            if (outboundPayload != null) {
                this.extractPayload(outboundPayload, actionReport, retrieve);
            }
            return actionReport.getResultType(String.class);
        }
        catch (CommandException e) {
            throw new GlassFishException(e);
        }
    }

    @Override
    public String deploy(InputStream is, String ... params) throws GlassFishException {
        try {
            String string = this.deploy(this.createFile(is), params);
            return string;
        }
        catch (IOException e) {
            throw new GlassFishException(e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not close the input stream!", e);
            }
        }
    }

    @Override
    public void undeploy(String appName, String ... params) throws GlassFishException {
        String[] newParams = new String[params.length + 1];
        System.arraycopy(params, 0, newParams, 0, params.length);
        newParams[params.length] = appName;
        CommandExecutorImpl executer = this.habitat.getService(CommandExecutorImpl.class, new Annotation[0]);
        try {
            ActionReport actionReport = executer.executeCommand("undeploy", newParams);
            if (StandardCharsets.UTF_8.equals(Charset.defaultCharset())) {
                actionReport.writeReport(System.out);
                return;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
            actionReport.writeReport(baos);
            System.out.print(baos.toString(StandardCharsets.UTF_8));
        }
        catch (CommandException e) {
            throw new GlassFishException(e);
        }
        catch (IOException e) {
            throw new GlassFishException(e);
        }
    }

    @Override
    public Collection<String> getDeployedApplications() throws GlassFishException {
        try {
            CommandExecutorImpl executer = this.habitat.getService(CommandExecutorImpl.class, new Annotation[0]);
            ActionReport report = executer.executeCommand("list-components", new String[0]);
            Properties props = report.getTopMessagePart().getProps();
            return new ArrayList<String>(props.stringPropertyNames());
        }
        catch (Exception e) {
            throw new GlassFishException(e);
        }
    }

    private File convertToFile(URI archive) throws IOException {
        if ("file".equalsIgnoreCase(archive.getScheme())) {
            return new File(archive);
        }
        try (InputStream openStream = archive.toURL().openStream();){
            File file = this.createFile(openStream);
            return file;
        }
    }

    private File createFile(InputStream in) throws IOException {
        File file = File.createTempFile("app", "tmp");
        file.deleteOnExit();
        FileUtils.copy(in, file);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractPayload(Payload.Outbound outboundPayload, ActionReport actionReport, File retrieveDir) {
        File payloadZip = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
            actionReport.writeReport(baos);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            Properties reportProps = new Properties();
            reportProps.setProperty("data-request-type", "report");
            outboundPayload.addPart(0, actionReport.getContentType(), "report", reportProps, bais);
            payloadZip = File.createTempFile("appclient", ".zip");
            try (FileOutputStream payloadOutputStream = new FileOutputStream(payloadZip);){
                outboundPayload.writeTo(payloadOutputStream);
            }
            PayloadFilesManager.Perm pfm = new PayloadFilesManager.Perm(retrieveDir, null);
            try (FileInputStream payloadInputStream = new FileInputStream(payloadZip);){
                PayloadImpl.Inbound inboundPayload = PayloadImpl.Inbound.newInstance("application/zip", payloadInputStream);
                pfm.processParts(inboundPayload);
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, ex.getMessage(), ex);
        }
        finally {
            if (payloadZip != null && !payloadZip.delete()) {
                logger.log(Level.WARNING, "Cannot delete payload: {0}", payloadZip);
            }
        }
    }
}

