/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.containers.EjbAsyncTask;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class EjbThreadPoolExecutor
extends ThreadPoolExecutor {
    public EjbThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, BlockingQueue<Runnable> workQueue, String threadPoolName) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.SECONDS, workQueue, new ThreadFactoryImpl(threadPoolName));
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        if (callable instanceof EjbAsyncTask) {
            return ((EjbAsyncTask)callable).getFutureTask();
        }
        return super.newTaskFor(callable);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("EjbThreadPoolExecutor with ");
        sb.append("thread-core-pool-size").append(" ").append(this.getCorePoolSize()).append(" ");
        sb.append("thread-max-pool-size").append(" ").append(this.getMaximumPoolSize()).append(" ");
        sb.append("thread-keep-alive-seconds").append(" ").append(this.getKeepAliveTime(TimeUnit.SECONDS)).append(" ");
        sb.append("thread-queue-capacity").append(" ").append(this.getQueue().remainingCapacity()).append(" ");
        sb.append("allow-core-thread-timeout").append(" ").append(this.allowsCoreThreadTimeOut()).append(" ");
        return sb.toString();
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        try {
            JavaEETransactionManager tm = EjbContainerUtilImpl.getInstance().getTransactionManager();
            if (tm.getTransaction() != null) {
                int st = tm.getStatus();
                Logger logger2 = EjbContainerUtilImpl.getLogger();
                logger2.warning("NON-NULL TX IN AFTER_EXECUTE. TX STATUS: " + st);
                if (st == 4 || st == 3 || st == 5) {
                    tm.clearThreadTx();
                } else {
                    tm.rollback();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class ThreadFactoryImpl
    implements ThreadFactory {
        private AtomicInteger threadId = new AtomicInteger(0);
        private String threadPoolName;

        public ThreadFactoryImpl(String threadPoolName) {
            this.threadPoolName = threadPoolName;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread th = new Thread(r, this.threadPoolName + this.threadId.incrementAndGet());
            th.setDaemon(true);
            th.setContextClassLoader(null);
            return th;
        }
    }
}

