/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.EjbInvocation;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EjbContainerUtil;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.ejb.api.EjbEndpointFacade;

public class EjbEndpointFacadeImpl
implements EjbEndpointFacade {
    private static final Logger LOG = EjbContainerUtilImpl.getLogger();
    private final BaseContainer container;
    private final InvocationManager invocationManager;

    public EjbEndpointFacadeImpl(BaseContainer container, EjbContainerUtil util) {
        this.container = container;
        this.invocationManager = util.getInvocationManager();
    }

    @Override
    public ClassLoader getEndpointClassLoader() {
        return this.container.getClassLoader();
    }

    @Override
    public ComponentInvocation startInvocation() {
        EjbInvocation inv = this.container.createEjbInvocation();
        inv.isWebService = true;
        inv.container = this.container;
        inv.transactionAttribute = 0;
        this.invocationManager.preInvoke(inv);
        return inv;
    }

    @Override
    public void endInvocation(ComponentInvocation inv) {
        try {
            EjbInvocation ejbInv = (EjbInvocation)inv;
            if (ejbInv.ejb == null) {
                this.invocationManager.postInvoke(inv);
            } else {
                this.container.webServicePostInvoke(ejbInv);
            }
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Unexpected error in EJB WebService endpoint post processing", t);
        }
    }
}

