/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.enterprise.deployment.ScheduledTimerDescriptor;
import jakarta.ejb.ScheduleExpression;
import org.glassfish.common.util.timer.TimerSchedule;

public class EJBTimerSchedule
extends TimerSchedule {
    private boolean automatic;
    private String methodName;
    private int paramCount;

    public EJBTimerSchedule() {
    }

    public EJBTimerSchedule(ScheduleExpression se) {
        this.second(se.getSecond());
        this.minute(se.getMinute());
        this.hour(se.getHour());
        this.dayOfMonth(se.getDayOfMonth());
        this.month(se.getMonth());
        this.dayOfWeek(se.getDayOfWeek());
        this.year(se.getYear());
        this.timezone(se.getTimezone());
        this.start(se.getStart());
        this.end(se.getEnd());
        this.configure();
    }

    public EJBTimerSchedule(ScheduledTimerDescriptor sd, String methodName, int paramCount) {
        this.second(sd.getSecond());
        this.minute(sd.getMinute());
        this.hour(sd.getHour());
        this.dayOfMonth(sd.getDayOfMonth());
        this.month(sd.getMonth());
        this.dayOfWeek(sd.getDayOfWeek());
        this.year(sd.getYear());
        this.timezone(sd.getTimezone());
        this.start(sd.getStart());
        this.end(sd.getEnd());
        this.methodName = methodName;
        this.paramCount = paramCount;
        this.automatic = true;
        this.configure();
    }

    public EJBTimerSchedule(String s) {
        super(s);
        String[] sp = s.split(" # ");
        this.automatic = Boolean.parseBoolean(sp[10]);
        if (sp.length == 13) {
            this.methodName = sp[11];
            this.paramCount = Integer.parseInt(sp[12]);
        }
    }

    public EJBTimerSchedule setAutomatic(boolean b) {
        this.automatic = b;
        return this;
    }

    public boolean isAutomatic() {
        return this.automatic;
    }

    public String getTimerMethodName() {
        return this.methodName;
    }

    public int getMethodParamCount() {
        return this.paramCount;
    }

    @Override
    public String getScheduleAsString() {
        StringBuffer s = new StringBuffer(super.getScheduleAsString()).append(" # ").append(this.automatic);
        if (this.automatic) {
            s.append(" # ").append(this.methodName).append(" # ").append(this.paramCount);
        }
        return s.toString();
    }

    public ScheduleExpression getScheduleExpression() {
        return new ScheduleExpression().second(this.getSecond()).minute(this.getMinute()).hour(this.getHour()).dayOfMonth(this.getDayOfMonth()).month(this.getMonth()).dayOfWeek(this.getDayOfWeek()).year(this.getYear()).timezone(this.getTimeZoneID()).start(this.getStart()).end(this.getEnd());
    }

    @Override
    public int hashCode() {
        return this.getScheduleAsString().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof EJBTimerSchedule && super.equals(o);
    }

    public static boolean isValid(ScheduledTimerDescriptor s) {
        EJBTimerSchedule ts = new EJBTimerSchedule(s, null, 0);
        ts.getNextTimeout();
        return true;
    }

    @Override
    protected boolean isExpectedElementCount(String[] el) {
        return el.length == 11 || el.length == 13;
    }
}

