/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.appserv.connectors.internal.api.ResourceHandle;
import com.sun.ejb.ComponentContext;
import com.sun.ejb.Container;
import com.sun.ejb.EjbInvocation;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBLocalObjectImpl;
import com.sun.ejb.containers.EJBObjectImpl;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.enterprise.container.common.spi.CDIService;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import jakarta.ejb.EJBContext;
import jakarta.ejb.EJBHome;
import jakarta.ejb.EJBLocalHome;
import jakarta.ejb.EJBLocalObject;
import jakarta.ejb.EJBObject;
import jakarta.transaction.Transaction;
import jakarta.transaction.UserTransaction;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.Identity;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.glassfish.api.invocation.ComponentInvocation;

public abstract class EJBContextImpl
implements EJBContext,
ComponentContext,
Serializable {
    private static final long serialVersionUID = 1L;
    static final Logger _logger = EjbContainerUtilImpl.getLogger();
    private Object ejb;
    protected transient BaseContainer container;
    protected transient Transaction transaction;
    protected transient Context initialContext;
    private transient ArrayList resources;
    private transient int concInvokeCount = 0;
    protected transient EJBObject ejbStub = null;
    protected transient EJBObjectImpl ejbObjectImpl;
    protected transient EJBObjectImpl ejbRemoteBusinessObjectImpl;
    protected transient EJBLocalObjectImpl ejbLocalObjectImpl;
    protected transient EJBLocalObjectImpl ejbLocalBusinessObjectImpl;
    protected transient EJBLocalObjectImpl optionalEjbLocalBusinessObjectImpl;
    private transient long lastTimeUsed;
    protected transient BeanState state;
    protected boolean isRemoteInterfaceSupported;
    protected boolean isLocalInterfaceSupported;
    protected transient boolean inEjbRemove;
    private Object[] interceptorInstances;
    protected transient CDIService.CDIInjectionContext cdiInjectionContext;

    protected EJBContextImpl(Object ejb, BaseContainer container) {
        this.ejb = ejb;
        this.container = container;
        this.state = BeanState.CREATED;
        this.inEjbRemove = false;
        this.isRemoteInterfaceSupported = container.isRemoteInterfaceSupported();
        this.isLocalInterfaceSupported = container.isLocalInterfaceSupported();
    }

    @Override
    public Transaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Transaction tr) {
        this.transaction = tr;
    }

    void setEJBStub(EJBObject ejbStub) {
        this.ejbStub = ejbStub;
    }

    void setEJBLocalObjectImpl(EJBLocalObjectImpl localObjectImpl) {
        this.ejbLocalObjectImpl = localObjectImpl;
    }

    void setEJBLocalBusinessObjectImpl(EJBLocalObjectImpl localBusObjectImpl) {
        this.ejbLocalBusinessObjectImpl = localBusObjectImpl;
    }

    void setOptionalEJBLocalBusinessObjectImpl(EJBLocalObjectImpl optionalLocalBusObjectImpl) {
        this.optionalEjbLocalBusinessObjectImpl = optionalLocalBusObjectImpl;
    }

    void setEJBObjectImpl(EJBObjectImpl ejbo) {
        this.ejbObjectImpl = ejbo;
    }

    EJBObjectImpl getEJBObjectImpl() {
        return this.ejbObjectImpl;
    }

    void setEJBRemoteBusinessObjectImpl(EJBObjectImpl ejbo) {
        this.ejbRemoteBusinessObjectImpl = ejbo;
    }

    EJBObjectImpl getEJBRemoteBusinessObjectImpl() {
        return this.ejbRemoteBusinessObjectImpl;
    }

    EJBLocalObjectImpl getEJBLocalObjectImpl() {
        return this.ejbLocalObjectImpl;
    }

    EJBLocalObjectImpl getEJBLocalBusinessObjectImpl() {
        return this.ejbLocalBusinessObjectImpl;
    }

    EJBLocalObjectImpl getOptionalEJBLocalBusinessObjectImpl() {
        return this.optionalEjbLocalBusinessObjectImpl;
    }

    void setContainer(BaseContainer container) {
        this.container = container;
    }

    void setState(BeanState s) {
        this.state = s;
    }

    boolean isTimedObject() {
        return this.container.isTimedObject();
    }

    protected BeanState getState() {
        return this.state;
    }

    void setInEjbRemove(boolean beingRemoved) {
        this.inEjbRemove = beingRemoved;
    }

    boolean isInEjbRemove() {
        return this.inEjbRemove;
    }

    void setCDIInjectionContext(CDIService.CDIInjectionContext ctx) {
        this.cdiInjectionContext = ctx;
    }

    CDIService.CDIInjectionContext getCDIInjectionContext() {
        return this.cdiInjectionContext;
    }

    public long getLastTimeUsed() {
        return this.lastTimeUsed;
    }

    public void touch() {
        this.lastTimeUsed = System.currentTimeMillis();
    }

    @Override
    public Object getEJB() {
        return this.ejb;
    }

    @Override
    public final Container getContainer() {
        return this.container;
    }

    public void registerResource(ResourceHandle h) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        this.resources.add(h);
    }

    public void unregisterResource(ResourceHandle h) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        this.resources.remove(h);
    }

    @Override
    public List getResourceList() {
        if (this.resources == null) {
            this.resources = new ArrayList(0);
        }
        return this.resources;
    }

    public int getConcurrentInvokeCount() {
        return this.concInvokeCount;
    }

    public synchronized void incrementConcurrentInvokeCount() {
        ++this.concInvokeCount;
    }

    public synchronized void decrementConcurrentInvokeCount() {
        --this.concInvokeCount;
    }

    public EJBObject getEJBObject() throws IllegalStateException {
        if (this.ejbStub == null) {
            throw new IllegalStateException("EJBObject not available");
        }
        return this.ejbStub;
    }

    public EJBLocalObject getEJBLocalObject() throws IllegalStateException {
        if (this.ejbLocalObjectImpl == null) {
            throw new IllegalStateException("EJBLocalObject not available");
        }
        return (EJBLocalObject)this.ejbLocalObjectImpl.getClientObject();
    }

    @Override
    public EJBHome getEJBHome() {
        if (!this.isRemoteInterfaceSupported) {
            throw new IllegalStateException("EJBHome not available");
        }
        return this.container.getEJBHomeStub();
    }

    @Override
    public EJBLocalHome getEJBLocalHome() {
        if (!this.isLocalInterfaceSupported) {
            throw new IllegalStateException("EJBLocalHome not available");
        }
        return this.container.getEJBLocalHome();
    }

    public Properties getEnvironment() {
        return this.container.getEnvironmentProperties();
    }

    @Deprecated
    public Identity getCallerIdentity() {
        throw new RuntimeException("getCallerIdentity() is deprecated, please use getCallerPrincipal().");
    }

    @Override
    public Object lookup(String name) {
        Object o = null;
        if (name == null) {
            throw new IllegalArgumentException("Argument is null");
        }
        try {
            if (this.initialContext == null) {
                this.initialContext = new InitialContext();
            }
            Object lookupString = name.startsWith("java:") ? name : "java:comp/env/" + name;
            o = this.initialContext.lookup((String)lookupString);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return o;
    }

    @Override
    public Principal getCallerPrincipal() {
        this.checkAccessToCallerSecurity();
        return this.container.getSecurityManager().getCallerPrincipal();
    }

    @Override
    public Map<String, Object> getContextData() {
        ComponentInvocation inv = EjbContainerUtilImpl.getInstance().getCurrentInvocation();
        if (inv instanceof EjbInvocation) {
            EjbInvocation ejbInv = (EjbInvocation)inv;
            return ejbInv.getContextData();
        }
        return Collections.emptyMap();
    }

    @Override
    public boolean isCallerInRole(String roleRef) {
        if (roleRef == null) {
            throw new IllegalStateException("Argument is null");
        }
        this.checkAccessToCallerSecurity();
        return this.container.getSecurityManager().isCallerInRole(roleRef);
    }

    protected void checkAccessToCallerSecurity() throws IllegalStateException {
        throw new IllegalStateException("Operation not allowed");
    }

    @Override
    public UserTransaction getUserTransaction() throws IllegalStateException {
        throw new IllegalStateException("Operation not allowed");
    }

    @Override
    public void setRollbackOnly() throws IllegalStateException {
        if (this.state == BeanState.CREATED) {
            throw new IllegalStateException("EJB not in READY state");
        }
        if (this.container.isBeanManagedTran) {
            throw new IllegalStateException("Illegal operation for bean-managed transactions");
        }
        JavaEETransactionManager tm = EjbContainerUtilImpl.getInstance().getTransactionManager();
        try {
            if (tm.getStatus() == 6) {
                throw new IllegalStateException("No transaction context.");
            }
            this.checkActivatePassivate();
            this.doGetSetRollbackTxAttrCheck();
            tm.setRollbackOnly();
        }
        catch (Exception ex) {
            IllegalStateException illEx = new IllegalStateException(ex.toString());
            illEx.initCause(ex);
            throw illEx;
        }
    }

    @Override
    public boolean getRollbackOnly() throws IllegalStateException {
        if (this.state == BeanState.CREATED) {
            throw new IllegalStateException("EJB not in READY state");
        }
        if (this.container.isBeanManagedTran) {
            throw new IllegalStateException("Illegal operation for bean-managed transactions");
        }
        JavaEETransactionManager tm = EjbContainerUtilImpl.getInstance().getTransactionManager();
        try {
            int status = tm.getStatus();
            if (status == 6) {
                throw new IllegalStateException("No transaction context.");
            }
            this.checkActivatePassivate();
            this.doGetSetRollbackTxAttrCheck();
            return status == 1 || status == 4 || status == 9;
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "Exception in method getRollbackOnly()", ex);
            IllegalStateException illEx = new IllegalStateException(ex.toString());
            illEx.initCause(ex);
            throw illEx;
        }
    }

    protected void doGetSetRollbackTxAttrCheck() {
        ComponentInvocation inv = EjbContainerUtilImpl.getInstance().getCurrentInvocation();
        if (inv instanceof EjbInvocation) {
            EjbInvocation ejbInv = (EjbInvocation)inv;
            if (ejbInv.invocationInfo != null) {
                switch (ejbInv.invocationInfo.txAttr) {
                    case 1: 
                    case 4: 
                    case 7: {
                        throw new IllegalStateException("Illegal tx attribute");
                    }
                }
            }
        }
    }

    void setInterceptorInstances(Object[] instances) {
        this.interceptorInstances = instances;
    }

    public Object[] getInterceptorInstances() {
        return this.interceptorInstances;
    }

    @Override
    public void checkTimerServiceMethodAccess() throws IllegalStateException {
        throw new IllegalStateException("EJB Timer Service method calls cannot be called in this context");
    }

    protected void checkActivatePassivate() throws IllegalStateException {
        if (this.inActivatePassivate()) {
            throw new IllegalStateException("Operation not allowed.");
        }
    }

    protected boolean inActivatePassivate() {
        return this.inActivatePassivate(EjbContainerUtilImpl.getInstance().getCurrentInvocation());
    }

    protected boolean inActivatePassivate(ComponentInvocation inv) {
        boolean inActivatePassivate = false;
        if (inv instanceof EjbInvocation) {
            Method currentMethod = ((EjbInvocation)inv).method;
            inActivatePassivate = currentMethod != null ? currentMethod.getName().equals("ejbActivate") || currentMethod.getName().equals("ejbPassivate") : false;
        }
        return inActivatePassivate;
    }

    void setEJB(Object o) {
        this.ejb = o;
    }

    protected Object getKey() {
        if (this.ejbLocalObjectImpl != null) {
            return this.ejbLocalObjectImpl.getKey();
        }
        if (this.ejbObjectImpl != null) {
            return this.ejbObjectImpl.getKey();
        }
        return null;
    }

    void deleteAllReferences() {
        this.ejb = null;
        this.container = null;
        this.transaction = null;
        this.resources = null;
        this.ejbStub = null;
        this.ejbObjectImpl = null;
        this.ejbRemoteBusinessObjectImpl = null;
        this.ejbLocalObjectImpl = null;
        this.ejbLocalBusinessObjectImpl = null;
    }

    public static enum BeanState {
        CREATED,
        POOLED,
        READY,
        INVOKING,
        INCOMPLETE_TX,
        IN_PASSIVATE,
        PASSIVATED,
        IN_ACTIVATE,
        ACTIVATED,
        IN_REMOVE,
        DESTROYED;

    }
}

