/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.base.io;

import com.sun.ejb.EJBUtils;
import com.sun.ejb.base.io.AbstractSerializableS1ASEJBReference;
import com.sun.ejb.codegen.RemoteGenerator;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import java.io.IOException;
import java.rmi.Remote;
import java.util.logging.Level;

final class SerializableS1ASEJBObjectReference
extends AbstractSerializableS1ASEJBReference {
    private static final long serialVersionUID = 1L;
    private final byte[] instanceKey;
    private Object sfsbKey;
    private long sfsbClientVersion;
    private boolean haEnabled;
    private final String remoteBusinessInterface;

    SerializableS1ASEJBObjectReference(long containerId, byte[] objKey, int keySize, String remoteBusinessInterfaceName) {
        super(containerId);
        BaseContainer container = EjbContainerUtilImpl.getInstance().getContainer(containerId);
        if (container != null) {
            this.haEnabled = container.isHAEnabled();
        }
        this.remoteBusinessInterface = remoteBusinessInterfaceName;
        this.instanceKey = new byte[keySize];
        System.arraycopy(objKey, 12, this.instanceKey, 0, keySize);
    }

    void setSFSBClientVersion(Object key, long val) {
        this.sfsbKey = key;
        this.sfsbClientVersion = val;
    }

    boolean isHAEnabled() {
        return this.haEnabled;
    }

    @Override
    public Object createObject() throws IOException {
        BaseContainer container = EjbContainerUtilImpl.getInstance().getContainer(this.containerId);
        if (container == null) {
            LOG.log(Level.WARNING, "ejb.base.io.null_container", this.containerId);
            return null;
        }
        try {
            if (this.remoteBusinessInterface == null) {
                Remote reference = container.createRemoteReferenceWithId(this.instanceKey, null);
                return AbstractSerializableS1ASEJBReference.doRemoteRefClassLoaderConversion(reference);
            }
            String generatedRemoteIntfName = RemoteGenerator.getGeneratedRemoteIntfName(this.remoteBusinessInterface);
            Remote remoteRef = container.createRemoteReferenceWithId(this.instanceKey, generatedRemoteIntfName);
            Remote newRemoteRef = AbstractSerializableS1ASEJBReference.doRemoteRefClassLoaderConversion(remoteRef);
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            return EJBUtils.createRemoteBusinessObject(contextClassLoader, this.remoteBusinessInterface, newRemoteRef);
        }
        catch (Exception e) {
            IOException ioex = new IOException("remote ref create error");
            ioex.initCause(e);
            throw ioex;
        }
    }
}

