/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurro.virtualthreads;

import jakarta.enterprise.concurrent.ManagedExecutorService;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorService;
import jakarta.enterprise.concurrent.Trigger;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.glassfish.concurro.AbstractManagedExecutorService;
import org.glassfish.concurro.ContextServiceImpl;
import org.glassfish.concurro.ManagedScheduledExecutorServiceAdapter;
import org.glassfish.concurro.internal.ManagedFutureTask;
import org.glassfish.concurro.internal.ManagedScheduledThreadPoolExecutor;
import org.glassfish.concurro.virtualthreads.VirtualThreadsManagedExecutorService;
import org.glassfish.concurro.virtualthreads.VirtualThreadsManagedThreadFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class VirtualThreadsManagedScheduledExecutorService
extends VirtualThreadsManagedExecutorService
implements ManagedScheduledExecutorService {
    protected final ManagedScheduledExecutorServiceAdapter scheduledAdapter = new ManagedScheduledExecutorServiceAdapter(this);
    protected final ManagedScheduledThreadPoolExecutor threadPoolExecutor = new ManagedScheduledThreadPoolExecutor(0, this.managedThreadFactory);

    public VirtualThreadsManagedScheduledExecutorService(String name, VirtualThreadsManagedThreadFactory managedThreadFactory, long hungTaskThreshold, boolean longRunningTasks, int maxParallelTasks, int queueCapacity, ContextServiceImpl contextService, AbstractManagedExecutorService.RejectPolicy rejectPolicy) {
        super(name, managedThreadFactory, hungTaskThreshold, longRunningTasks, maxParallelTasks, queueCapacity, contextService, rejectPolicy);
        this.threadPoolExecutor.setMaximumPoolSize(maxParallelTasks);
        this.threadPoolExecutor.setKeepAliveTime(0L, TimeUnit.SECONDS);
        this.threadPoolExecutor.setThreadLifeTime(0L);
    }

    private VirtualThreadsManagedThreadFactory createDefaultManagedThreadFactory(String name) {
        VirtualThreadsManagedThreadFactory newManagedThreadFactory;
        this.managedThreadFactory = newManagedThreadFactory = new VirtualThreadsManagedThreadFactory(name + "-ManagedThreadFactory", null);
        return newManagedThreadFactory;
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, Trigger trigger) {
        return this.threadPoolExecutor.schedule((AbstractManagedExecutorService)this, command, trigger);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, Trigger trigger) {
        return this.threadPoolExecutor.schedule((AbstractManagedExecutorService)this, callable, trigger);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.threadPoolExecutor.schedule(this, command, null, delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.threadPoolExecutor.schedule(this, callable, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.threadPoolExecutor.scheduleAtFixedRate(this, command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.threadPoolExecutor.scheduleWithFixedDelay(this, command, initialDelay, delay, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.threadPoolExecutor.schedule(this, command, null, 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.threadPoolExecutor.schedule(this, task, null, 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.threadPoolExecutor.schedule(this, task, result, 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.threadPoolExecutor.schedule(this, task, 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    protected <V> ManagedFutureTask<V> getNewTaskFor(Runnable r, V result) {
        return this.threadPoolExecutor.newTaskFor(this, r, result);
    }

    @Override
    protected <V> ManagedFutureTask<V> getNewTaskFor(Callable<V> callable) {
        return this.threadPoolExecutor.newTaskFor(this, callable);
    }

    @Override
    protected void executeManagedFutureTask(ManagedFutureTask<?> task) {
        this.threadPoolExecutor.executeManagedTask(task);
    }

    @Override
    public ManagedScheduledExecutorServiceAdapter getAdapter() {
        return this.scheduledAdapter;
    }

    @Override
    public ManagedExecutorService getExecutorForTaskListener() {
        return this.scheduledAdapter;
    }

    @Override
    protected ExecutorService getThreadPoolExecutor() {
        return this.threadPoolExecutor;
    }
}

