/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurro.virtualthreads;

import jakarta.enterprise.concurrent.ManagedExecutorService;
import jakarta.enterprise.concurrent.ManagedExecutors;
import jakarta.enterprise.concurrent.ManagedTask;
import jakarta.enterprise.concurrent.ManagedTaskListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import org.glassfish.concurro.AbstractManagedExecutorService;
import org.glassfish.concurro.AbstractManagedExecutorServiceAdapter;
import org.glassfish.concurro.ContextServiceImpl;
import org.glassfish.concurro.ManagedExecutorServiceAdapter;
import org.glassfish.concurro.ManagedThreadFactoryImpl;
import org.glassfish.concurro.internal.ManagedFutureTask;
import org.glassfish.concurro.internal.MultiManagedTaskListener;
import org.glassfish.concurro.virtualthreads.VirtualThreadsManagedFutureTask;
import org.glassfish.concurro.virtualthreads.VirtualThreadsManagedThreadFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class VirtualThreadsManagedExecutorService
extends AbstractManagedExecutorService
implements ManagedTaskListener {
    protected final ExecutorService executor;
    protected final ManagedExecutorServiceAdapter adapter;
    protected VirtualThreadsManagedThreadFactory managedThreadFactory;
    private AtomicLong taskCount = new AtomicLong();
    private AtomicLong tasksCompleted = new AtomicLong();
    private Semaphore parallelTasksSemaphore = null;
    int maxParallelTasks;
    private Semaphore queuedTasksSemaphore = null;
    int queueCapacity;
    private final Set<ManagedFutureTask<?>> runningFutures = ConcurrentHashMap.newKeySet();
    private final Set<ManagedFutureTask<?>> tasksInQueue = ConcurrentHashMap.newKeySet();

    public VirtualThreadsManagedExecutorService(String name, VirtualThreadsManagedThreadFactory managedThreadFactory, long hungTaskThreshold, boolean longRunningTasks, int maxParallelTasks, int queueCapacity, ContextServiceImpl contextService, AbstractManagedExecutorService.RejectPolicy rejectPolicy) {
        super(name, longRunningTasks, contextService, contextService != null ? contextService.getContextSetupProvider() : null, rejectPolicy);
        this.managedThreadFactory = managedThreadFactory != null ? managedThreadFactory : this.createDefaultManagedThreadFactory(name);
        this.managedThreadFactory.setHungTaskThreshold(hungTaskThreshold);
        this.maxParallelTasks = maxParallelTasks;
        this.queueCapacity = queueCapacity;
        if (maxParallelTasks > 0) {
            this.parallelTasksSemaphore = new Semaphore(maxParallelTasks, true);
            if (queueCapacity > 0) {
                int virtualCapacity = queueCapacity + maxParallelTasks;
                if (virtualCapacity <= 0) {
                    virtualCapacity = Integer.MAX_VALUE;
                }
                this.queuedTasksSemaphore = new Semaphore(virtualCapacity, true);
            }
        }
        this.executor = Executors.newThreadPerTaskExecutor(this.getManagedThreadFactory());
        this.adapter = new ManagedExecutorServiceAdapter(this);
    }

    private VirtualThreadsManagedThreadFactory createDefaultManagedThreadFactory(String name) {
        VirtualThreadsManagedThreadFactory newManagedThreadFactory;
        this.managedThreadFactory = newManagedThreadFactory = new VirtualThreadsManagedThreadFactory(name + "-ManagedThreadFactory", null);
        return newManagedThreadFactory;
    }

    @Override
    public void execute(Runnable command) {
        ManagedFutureTask<Object> task = this.getNewTaskFor(command, null);
        this.executeManagedFutureTask(task);
    }

    @Override
    protected void executeManagedFutureTask(ManagedFutureTask<?> task) {
        if (this.queuedTasksSemaphore != null && !this.queuedTasksSemaphore.tryAcquire()) {
            throw new RejectedExecutionException("Too many tasks submitted (available = " + String.valueOf(this.queuedTasksSemaphore == null ? "UNUSED" : Integer.valueOf(this.queuedTasksSemaphore.availablePermits())) + ", maxParallelTasks = " + this.maxParallelTasks + ", queueCapacity = " + this.queueCapacity);
        }
        task.submitted();
        this.tasksInQueue.add(task);
        this.getThreadPoolExecutor().execute(task);
        this.runningFutures.add(task);
    }

    @Override
    public List<Runnable> shutdownNow() {
        super.shutdownNow();
        this.cancelRunningFutures();
        return new ArrayList<Runnable>(this.tasksInQueue);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.cancelRunningFutures();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelRunningFutures() {
        HashSet runningFuturesCopy;
        Set<ManagedFutureTask<?>> set = this.runningFutures;
        synchronized (set) {
            runningFuturesCopy = new HashSet(this.runningFutures);
        }
        runningFuturesCopy.stream().forEach(future -> future.cancel(false));
    }

    @Override
    public AbstractManagedExecutorServiceAdapter getAdapter() {
        return this.adapter;
    }

    @Override
    protected ExecutorService getThreadPoolExecutor() {
        return this.executor;
    }

    @Override
    public ManagedExecutorService getExecutorForTaskListener() {
        return this.adapter;
    }

    @Override
    protected <V> ManagedFutureTask<V> getNewTaskFor(Runnable r, V result) {
        Runnable task = this.turnToTaskWithListener(r, result, this);
        VirtualThreadsManagedFutureTask<V> managedTask = new VirtualThreadsManagedFutureTask<V>(this, task, result, this.parallelTasksSemaphore);
        this.addTaskListeners(managedTask);
        return managedTask;
    }

    private <V> void addTaskListeners(VirtualThreadsManagedFutureTask<V> managedTask) {
        managedTask.setTaskCompletionHandler(() -> {
            if (this.queuedTasksSemaphore != null) {
                this.queuedTasksSemaphore.release();
            }
        });
        managedTask.setTaskStartedHandler(startedTask -> this.tasksInQueue.remove(startedTask));
    }

    private <V> Runnable turnToTaskWithListener(Runnable r, V result, ManagedTaskListener listener) throws IllegalArgumentException {
        Runnable task = r;
        ManagedTaskListener originalListener = null;
        Map<String, String> originalExecutionProperties = null;
        if (task instanceof ManagedTask) {
            ManagedTask managedTask = (ManagedTask)((Object)task);
            originalListener = managedTask.getManagedTaskListener();
            originalExecutionProperties = managedTask.getExecutionProperties();
        }
        return ManagedExecutors.managedTask(task, originalExecutionProperties, (ManagedTaskListener)new MultiManagedTaskListener(listener, originalListener));
    }

    @Override
    protected <V> ManagedFutureTask<V> getNewTaskFor(Callable<V> callable) {
        Callable task = this.turnToTaskWithListener(callable, this);
        VirtualThreadsManagedFutureTask managedTask = new VirtualThreadsManagedFutureTask((AbstractManagedExecutorService)this, task, this.parallelTasksSemaphore);
        this.addTaskListeners(managedTask);
        return managedTask;
    }

    private <V> Callable turnToTaskWithListener(Callable c, ManagedTaskListener listener) throws IllegalArgumentException {
        Callable task = c;
        ManagedTaskListener originalListener = null;
        Map<String, String> originalExecutionProperties = null;
        if (task instanceof ManagedTask) {
            ManagedTask managedTask = (ManagedTask)((Object)task);
            originalListener = managedTask.getManagedTaskListener();
            originalExecutionProperties = managedTask.getExecutionProperties();
        }
        return ManagedExecutors.managedTask(task, originalExecutionProperties, (ManagedTaskListener)new MultiManagedTaskListener(listener, originalListener));
    }

    @Override
    public long getTaskCount() {
        return this.taskCount.get();
    }

    @Override
    public long getCompletedTaskCount() {
        return this.tasksCompleted.get();
    }

    @Override
    public void taskSubmitted(Future<?> future, ManagedExecutorService executor, Object task) {
        this.taskCount.incrementAndGet();
    }

    @Override
    public void taskAborted(Future<?> future, ManagedExecutorService executor, Object task, Throwable exception) {
        this.runningFutures.remove(future);
        this.taskCount.decrementAndGet();
    }

    @Override
    public void taskDone(Future<?> future, ManagedExecutorService executor, Object task, Throwable exception) {
        this.runningFutures.remove(future);
        this.tasksCompleted.incrementAndGet();
    }

    @Override
    public void taskStarting(Future<?> future, ManagedExecutorService executor, Object task) {
    }

    @Override
    protected boolean isTaskHung(Thread thread, long now) {
        return this.managedThreadFactory.isTaskHung(thread, now);
    }

    @Override
    public ManagedThreadFactoryImpl getManagedThreadFactory() {
        return this.managedThreadFactory;
    }
}

