/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreConfiguration;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.ha.store.api.HashableKey;
import org.glassfish.ha.store.util.SimpleMetadata;
import org.shoal.adapter.store.ReplicatedBackingStore;
import org.shoal.adapter.store.ReplicatedBackingStoreFactory;
import org.shoal.ha.cache.impl.command.CommandManager;

public class SimpleStoreableBackingStoreShell {
    BackingStore<MyKey, SimpleMetadata> ds;
    ConcurrentHashMap<MyKey, SimpleMetadata> cache = new ConcurrentHashMap();
    CommandManager<MyKey, SimpleMetadata> cm;
    int counter = 0;

    public static void main(String[] args) throws Exception {
        BackingStoreConfiguration conf = new BackingStoreConfiguration();
        conf.setStoreName(args[0]).setInstanceName(args[1]).setClusterName(args[2]).setKeyClazz(MyKey.class).setValueClazz(SimpleMetadata.class).setClassLoader(ClassLoader.getSystemClassLoader());
        Map<String, Object> map = conf.getVendorSpecificSettings();
        map.put("start.gms", true);
        map.put("class.loader", ClassLoader.getSystemClassLoader());
        map.put("async.replication", true);
        BackingStore<MyKey, SimpleMetadata> ds = new ReplicatedBackingStoreFactory().createBackingStore(conf);
        SimpleStoreableBackingStoreShell main = new SimpleStoreableBackingStoreShell();
        main.runShell(ds);
    }

    private void runShell(BackingStore<MyKey, SimpleMetadata> ds) {
        this.cm = ((ReplicatedBackingStore)ds).getDataStoreContext().getCommandManager();
        this.ds = ds;
        String line = "";
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in, Charset.defaultCharset()));
        do {
            this.prompt();
            try {
                line = br.readLine();
                ArrayList<String> args = new ArrayList<String>();
                StringTokenizer tok = new StringTokenizer(line, "\n\r\t\f \f");
                while (tok.hasMoreTokens()) {
                    String str = tok.nextToken();
                    args.add(str);
                }
                if (args.size() <= 0) continue;
                String command = (String)args.remove(0);
                String[] params = args.toArray(new String[0]);
                this.execute(command, params);
                ++this.counter;
            }
            catch (IOException ioEx) {
                ioEx.printStackTrace();
            }
            catch (BackingStoreException bsEx) {
                bsEx.printStackTrace();
            }
        } while (!"quit".equalsIgnoreCase(line));
    }

    private void prompt() {
        System.out.print(this.counter + ">");
        System.out.flush();
    }

    private void execute(String command, String[] params) throws BackingStoreException {
        if ("put".equalsIgnoreCase(command)) {
            String key = params[0];
            for (int i = 0; i < 8; ++i) {
                MyKey key1 = new MyKey(params[0] + ":" + i, key);
                SimpleMetadata st = this.cache.get(key1);
                long version = st == null ? 0L : st._storeable_getVersion() + 1L;
                st = new SimpleMetadata(version, System.currentTimeMillis(), 600000L, ("Value:" + i + ":" + version).getBytes(Charset.defaultCharset()));
                this.cache.put(key1, st);
                String rs = this.ds.save(key1, st, true);
                System.out.println("PUT key = " + key1 + " : " + st + ";   TO : " + rs);
            }
        } else if ("get".equalsIgnoreCase(command)) {
            MyKey key = new MyKey(params[0], null);
            SimpleMetadata st = this.ds.load(key, params.length > 1 ? params[1] : null);
            if (st != null) {
                System.out.println("get(" + params[0] + ") => " + st + " ==> " + new String(st.getState(), Charset.defaultCharset()));
                this.cache.put(key, st);
            } else {
                System.out.println("get(" + params[0] + ") NOT FOUND ==> null");
            }
        } else if ("touch".equalsIgnoreCase(command)) {
            MyKey key = new MyKey(params[0], null);
            SimpleMetadata simpleMetadata = this.ds.load(key, params.length > 1 ? params[1] : null);
        } else if ("remove".equalsIgnoreCase(command)) {
            MyKey key = new MyKey(params[0], null);
            this.ds.remove(key);
        }
    }

    private static class MyKey
    implements Serializable,
    HashableKey {
        private static final long serialVersionUID = -6208120668944939221L;
        String myKey;
        String rootKey;

        MyKey(String myKey, String rootKey) {
            this.myKey = myKey;
            this.rootKey = rootKey;
        }

        @Override
        public Object getHashKey() {
            return this.rootKey;
        }

        public int hashCode() {
            return this.myKey.hashCode();
        }

        public boolean equals(Object other) {
            System.out.println("Equals(" + other + ")");
            if (other instanceof MyKey) {
                MyKey k2 = (MyKey)other;
                System.out.println(this + ".equals(" + other + ") = " + k2.myKey.equals(this.myKey));
                return k2.myKey.equals(this.myKey);
            }
            return false;
        }

        public String toString() {
            return this.myKey;
        }
    }
}

