/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beansdev;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.netbeans.modules.schema2beans.AttrProp;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.DDLogFlags;
import org.netbeans.modules.schema2beans.Schema2BeansException;
import org.netbeans.modules.schema2beans.Schema2BeansNestedException;
import org.netbeans.modules.schema2beans.Schema2BeansRuntimeException;
import org.netbeans.modules.schema2beans.TraceLogger;
import org.netbeans.modules.schema2beansdev.DocDefHandler;
import org.netbeans.modules.schema2beansdev.DocDefParser;
import org.netbeans.modules.schema2beansdev.GenBeans;
import org.netbeans.modules.schema2beansdev.GraphLink;
import org.netbeans.modules.schema2beansdev.GraphNode;
import org.netbeans.modules.schema2beansdev.HasPrefixGuesser;
import org.netbeans.modules.schema2beansdev.PrefixGuesser;
import org.netbeans.modules.schema2beansdev.TreeParser;

public class TreeBuilder
implements DocDefHandler,
TreeParser,
HasPrefixGuesser {
    GraphNode rootNode;
    String docRoot;
    GenBeans.Config config;
    private Stack curParentGroupStack = new Stack();
    private GraphLink curParentGroup;
    private Stack curElementTypeStack = new Stack();
    private int curElementType;
    private Stack curAttrStack = new Stack();
    private AttrProp curAttr = null;
    private PrefixGuesser prefixGuesser;
    Map nameHash = new HashMap();
    private String defaultNamespace = null;
    private static final int CREATE = 1;
    private static final int GET = 2;
    private static final int REFERENCE = 3;
    private static final String INDENT = "  ";

    void pushLevel() {
        this.curParentGroupStack.push(this.curParentGroup);
        this.curElementTypeStack.push(new Integer(this.curElementType));
        this.curAttrStack.push(this.curAttr);
    }

    void popLevel() {
        this.curParentGroup = (GraphLink)this.curParentGroupStack.pop();
        this.curElementType = (Integer)this.curElementTypeStack.pop();
        this.curAttr = (AttrProp)this.curAttrStack.pop();
    }

    TreeBuilder(GenBeans.Config config) {
        this.config = config;
    }

    @Override
    public void startDocument(String root) {
        if (DDLogFlags.debug) {
            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 12, 1, 1, root);
            this.config.messageOut.println("Building the schema object graph.");
        }
        this.docRoot = root;
    }

    @Override
    public void endDocument() {
        if (DDLogFlags.debug) {
            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 12, 1, 2);
            this.config.messageOut.println("schema Object graph built.");
        }
        for (GraphNode node : this.nameHash.values()) {
            GraphLink firstChild;
            GraphLink l = node.getGraphLink();
            if (l == null || l.name != null || l.getSibling() != null || l.isSequenceOr() || l.getGroupInstance() != 32 || (firstChild = l.getFirstChild()) != null && firstChild.getSibling() != null) continue;
            if (DDLogFlags.debug) {
                this.config.messageOut.println("Removing starter group: " + l);
            }
            node.setGraphLink(firstChild);
        }
        try {
            this.findRootNode();
        }
        catch (Schema2BeansException e) {
            throw new Schema2BeansRuntimeException(e);
        }
        if (DDLogFlags.debug) {
            this.config.messageOut.println(this.dump());
        }
    }

    private GraphNode getGraphNode(String uniqueName, String name, int mode) throws Schema2BeansException {
        uniqueName = name;
        GraphNode node = (GraphNode)this.nameHash.get(uniqueName);
        if (node == null) {
            node = new GraphNode(name, uniqueName);
            node.setGraphLink(new GraphLink(null));
            this.nameHash.put(uniqueName, node);
        }
        if (mode == 1) {
            node.setCreated(true);
        } else if (mode == 3) {
            node.incrRefCount();
        }
        return node;
    }

    @Override
    public void startElement(String uniqueName, String typeName, int type2) {
        if (DDLogFlags.debug) {
            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 12, 1, 3, uniqueName + " - " + typeName + " - " + TreeBuilder.typeToString(type2));
        }
        this.pushLevel();
        this.curElementType = type2;
        try {
            if (type2 == 2) {
                GraphNode node = this.getGraphNode(uniqueName, typeName, 1);
                this.curParentGroup = node.getGraphLink();
            } else if (type2 == 3) {
                GraphNode node = this.getGraphNode(uniqueName, typeName, 2);
                this.curAttr = new AttrProp(typeName);
                node.addAttribute(this.curAttr);
            }
        }
        catch (Schema2BeansException e) {
            throw new Schema2BeansRuntimeException(e);
        }
    }

    @Override
    public boolean doesElementExist(String typeName) {
        return this.nameHash.containsKey(typeName);
    }

    @Override
    public void endElement() {
        if (DDLogFlags.debug) {
            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 12, 1, 4);
        }
        if (this.curElementType == 3) {
            this.curAttr.validate();
        } else if (this.curElementType == 2) {
            // empty if block
        }
        this.curElementType = 0;
        this.popLevel();
    }

    @Override
    public void character(char c) {
        if (this.curElementType == 2) {
            if (c == '|') {
                this.curParentGroup.setSequence(2);
            }
        } else if (this.curElementType == 3 && c == '|') {
            this.curAttr.checkEnum();
        }
    }

    @Override
    public void element(String uniqueName, String typeName, String attrName, String attrNamespace, int instance, boolean externalType, String defaultValue) {
        if (DDLogFlags.debug) {
            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 12, 1, 5, attrName + " : " + typeName + TreeBuilder.instanceToString(instance, false));
        }
        try {
            if (this.curElementType == 0 && !externalType) {
                if (DDLogFlags.debug) {
                    System.out.println("Top element def for " + attrName);
                }
                GraphNode attrNode = this.getGraphNode(uniqueName, attrName, 1);
                GraphNode node = this.getGraphNode(uniqueName, typeName, 3);
                attrNode.setAlias(node);
            } else if (this.curElementType == 2) {
                GraphNode node = this.getGraphNode(uniqueName, typeName, 3);
                GraphLink link = new GraphLink(attrName, attrNamespace);
                link.setDefaultValue(defaultValue);
                this.curParentGroup.addChild(link);
                link.element = node;
                link.setElementInstance(instance);
                if (externalType) {
                    node.setJavaType(typeName);
                }
            } else if (this.curElementType == 3) {
                if (this.curAttr.isComplete()) {
                    throw new DocDefParser.MissingEndOfEltException(this.curAttr.getPropertyName());
                }
                if (defaultValue != null) {
                    this.curAttr.setDefaultValue(defaultValue);
                }
                this.curAttr.addValue(attrName, attrNamespace);
                if (externalType) {
                    this.curAttr.setJavaType(typeName);
                }
            }
        }
        catch (Schema2BeansException e) {
            throw new Schema2BeansRuntimeException(e);
        }
    }

    @Override
    public void element(String uniqueName, String typeName, int instance) {
        this.element(uniqueName, typeName, typeName, null, instance, false, null);
    }

    @Override
    public void addExtraDataNode(String uniqueName, String typeName, Object data) throws Schema2BeansException {
        GraphNode node = this.getGraphNode(uniqueName, typeName, 2);
        node.addExtraData(data);
    }

    @Override
    public void addExtraDataCurLink(Object data) {
        if (this.curElementType == 3) {
            if (this.curAttr != null) {
                this.curAttr.addExtraData(data);
            }
        } else if (this.curParentGroup != null && this.curParentGroup.getLastChild() != null) {
            this.curParentGroup.getLastChild().extraData.add(data);
        }
    }

    public void addExtraDataNode(String uniqueName, String typeName, Object[] data) throws Schema2BeansException {
        GraphNode node = this.getGraphNode(uniqueName, typeName, 2);
        if (data != null) {
            for (int i = 0; i < data.length; ++i) {
                node.addExtraData(data[i]);
            }
        }
    }

    @Override
    public void setUnion(String uniqueName, String typeName, boolean value) throws Schema2BeansException {
        GraphNode node = this.getGraphNode(uniqueName, typeName, 2);
        node.setUnion(value);
    }

    public void addExtraDataCurLink(Object[] data) {
        block4: {
            block3: {
                if (this.curElementType != 3) break block3;
                if (this.curAttr == null || data == null) break block4;
                for (int i = 0; i < data.length; ++i) {
                    this.curAttr.addExtraData(data[i]);
                }
                break block4;
            }
            if (this.curParentGroup != null && this.curParentGroup.getLastChild() != null && data != null) {
                for (int i = 0; i < data.length; ++i) {
                    this.curParentGroup.getLastChild().extraData.add(data[i]);
                }
            }
        }
    }

    @Override
    public void nillable(boolean value) {
        if (this.curParentGroup != null && this.curParentGroup.getLastChild() != null) {
            this.curParentGroup.getLastChild().setNillable(value);
        }
    }

    @Override
    public void setAbstract(String uniqueName, String name, boolean value) {
        if (this.curElementType != 3) {
            GraphNode node;
            try {
                node = this.getGraphNode(uniqueName, name, 2);
            }
            catch (Schema2BeansException e) {
                throw new Schema2BeansRuntimeException(e);
            }
            node.setAbstract(value);
        }
    }

    @Override
    public void setExtendedProperty(String uniqueName, String typeName, String propertyName, Object value) throws Schema2BeansException {
        GraphNode node = this.getGraphNode(uniqueName, typeName, 2);
        node.setExtendedProperty(propertyName, value);
    }

    @Override
    public void javaType(String uniqueName, String name, String javaType) {
        if (this.curElementType == 3) {
            this.curAttr.setJavaType(javaType);
        } else {
            GraphNode node;
            try {
                node = this.getGraphNode(uniqueName, name, 2);
            }
            catch (Schema2BeansException e) {
                throw new Schema2BeansRuntimeException(e);
            }
            node.setJavaType(javaType);
            node.setCreated(false);
        }
    }

    @Override
    public void setExtension(String uniqueName, String typeName, String extendsName) throws Schema2BeansException {
        if (this.curElementType != 3) {
            GraphNode extendsNode;
            GraphNode node;
            try {
                node = this.getGraphNode(uniqueName, typeName, 2);
                extendsNode = this.getGraphNode(null, extendsName, 3);
            }
            catch (Schema2BeansException e) {
                throw new Schema2BeansRuntimeException(e);
            }
            node.setExtension(extendsNode);
        }
    }

    @Override
    public void startGroupElements() {
        if (DDLogFlags.debug) {
            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 12, 5, 6);
        }
        if (this.curElementType == 2) {
            GraphLink link = new GraphLink(null);
            this.curParentGroup.addChild(link);
            this.curParentGroup = link;
        } else if (this.curElementType == 3) {
            this.curAttr.setEnum(true);
        }
    }

    @Override
    public void endGroupElements(int instance) {
        if (DDLogFlags.debug) {
            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 12, 5, 7, TreeBuilder.instanceToString(instance, false));
        }
        if (this.curElementType == 2) {
            this.curParentGroup.setGroupInstance(instance);
            this.curParentGroup = this.curParentGroup.getParent();
        } else if (this.curElementType == 3) {
            this.curAttr.setEnum(false);
        }
    }

    @Override
    public void setDefaultNamespace(String ns) {
        this.defaultNamespace = ns;
    }

    @Override
    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    private void findRootNode() throws Schema2BeansException {
        GraphNode node2;
        Iterator<Object> it = this.nameHash.keySet().iterator();
        int count = 0;
        ArrayList<GraphNode> list = new ArrayList<GraphNode>();
        while (it.hasNext()) {
            String uniqueName = (String)it.next();
            node2 = (GraphNode)this.nameHash.get(uniqueName);
            if (DDLogFlags.debug) {
                System.out.println("refCount=" + node2.getRefCount() + " created=" + node2.isCreated() + " javaType=" + node2.getJavaType() + " uniqueName=" + uniqueName + " node=" + node2);
            }
            if (!node2.isCreated() || node2.getRefCount() != 0) continue;
            ++count;
            list.add(node2);
        }
        if (count > 1) {
            int highestPoints = 0;
            GraphNode highestNode = null;
            int tieCount = 0;
            Iterator highit = list.iterator();
            while (highit.hasNext()) {
                GraphLink link;
                int points = 0;
                node2 = (GraphNode)highit.next();
                if (node2.getAlias() != null) {
                    ++points;
                    if (node2.getAlias().getRefCount() == 1) {
                        ++points;
                    }
                }
                if (this.defaultNamespace == null ? node2.getNamespace() == null : this.defaultNamespace.equals(node2.getNamespace())) {
                    ++points;
                }
                if ((link = node2.getGraphLink()) != null && !"#PCDATA".equals(link.name)) {
                    GraphLink sibling;
                    ++points;
                    GraphLink firstChild = link.getFirstChild();
                    if (firstChild != null) {
                        ++points;
                        if (firstChild.getSibling() != null) {
                            ++points;
                        }
                        if (firstChild.getFirstChild() != null) {
                            ++points;
                        }
                    }
                    if ((sibling = link.getSibling()) != null) {
                        ++points;
                        if (sibling.getSibling() != null) {
                            ++points;
                        }
                        if (sibling.getFirstChild() != null) {
                            ++points;
                        }
                    }
                }
                if (points > highestPoints) {
                    highestPoints = points;
                    highestNode = node2;
                    tieCount = 0;
                    continue;
                }
                if (points != highestPoints) continue;
                ++tieCount;
            }
            if (tieCount == 0 && highestNode != null) {
                count = 1;
                list.clear();
                list.add(highestNode);
            }
        }
        if (count == 1) {
            this.rootNode = (GraphNode)list.get(0);
            if (this.docRoot != null && !this.docRoot.equals(this.rootNode.getName())) {
                String str = "Mismatch between doc root name specified (" + this.docRoot + ") and the root name found in the DTD graph (" + this.rootNode.getName() + ")";
                throw new IllegalStateException(str);
            }
        } else if (count == 0) {
            this.rootNode = null;
            if (this.docRoot != null) {
                for (GraphNode node2 : this.nameHash.values()) {
                    if (!this.docRoot.equals(node2.getName())) continue;
                    this.rootNode = node2;
                    break;
                }
            }
            if (this.rootNode == null) {
                throw new IllegalStateException(Common.getMessage("NoRootElementCandidate"));
            }
        } else {
            this.config.messageOut.println("The following elements could be the root of the document:");
            for (int i = 0; i < list.size(); ++i) {
                GraphNode n = (GraphNode)list.get(i);
                this.config.messageOut.print(i + 1 + ". " + n);
                if (this.docRoot != null && this.docRoot.equals(n.getName())) {
                    this.rootNode = n;
                    this.config.messageOut.println(" <= parameter value");
                    continue;
                }
                this.config.messageOut.println("");
            }
            if (this.rootNode == null) {
                String errStr = "Could not find the root of the document. Use the -d option to specify the doc root";
                if (this.config.isAuto()) {
                    throw new IllegalStateException(errStr);
                }
                try {
                    BufferedReader rd = new BufferedReader(new InputStreamReader(System.in));
                    this.config.messageOut.print("Enter the element that should be used as the root: ");
                    String str = rd.readLine();
                    int i = Integer.parseInt(str) - 1;
                    if (i < 0 || i >= list.size()) {
                        throw new IllegalStateException(errStr);
                    }
                    this.rootNode = (GraphNode)list.get(i);
                }
                catch (Exception e) {
                    TraceLogger.error(e);
                    throw new Schema2BeansNestedException(errStr, e);
                }
            }
        }
        if (DDLogFlags.debug) {
            this.config.messageOut.println("Using " + this.rootNode.getName() + " as the root of the document.");
        }
    }

    static String instanceToString(int instance, boolean bean) {
        switch (instance) {
            case 16: {
                if (bean) {
                    return "[0,1]";
                }
                return "?";
            }
            case 48: {
                if (bean) {
                    return "[0,n]";
                }
                return "*";
            }
            case 64: {
                if (bean) {
                    return "[1,n]";
                }
                return "+";
            }
        }
        return "";
    }

    static String typeToString(int type2) {
        switch (type2) {
            case 1: {
                return "comment";
            }
            case 2: {
                return "element";
            }
            case 3: {
                return "attlist";
            }
        }
        return "unknown value: " + type2;
    }

    @Override
    public GraphNode[] getNodes() {
        int maxSize = this.nameHash.values().size();
        ArrayList<GraphNode> ret = new ArrayList<GraphNode>(maxSize);
        HashMap insertedNodes = new HashMap();
        HashMap ignoredNodes = new HashMap();
        this.getNodesInsertNode(this.rootNode, ret, insertedNodes, ignoredNodes);
        this.getNodes(this.rootNode.getGraphLink(), ret, insertedNodes, ignoredNodes);
        if (!this.config.isRemoveUnreferencedNodes()) {
            for (GraphNode node : this.nameHash.values()) {
                if (insertedNodes.containsKey(node) || ignoredNodes.containsKey(node)) continue;
                this.config.messageOut.println(Common.getMessage("MSG_FoundUnreferencedNode", node.toString()));
                ret.add(node);
            }
        }
        return ret.toArray(new GraphNode[ret.size()]);
    }

    private void getNodes(GraphLink l, List ret, Map insertedNodes, Map ignoredNodes) {
        Stack<GraphLink> linkStack = new Stack<GraphLink>();
        linkStack.push(l);
        while (!linkStack.isEmpty()) {
            for (l = (GraphLink)linkStack.pop(); l != null; l = l.getSibling()) {
                if (l.element != null && !insertedNodes.containsKey(l.element)) {
                    this.getNodesInsertNode(l.element, ret, insertedNodes, ignoredNodes);
                    linkStack.push(l.element.getGraphLink());
                }
                linkStack.push(l.getFirstChild());
            }
        }
    }

    private void getNodesInsertNode(GraphNode node, List ret, Map insertedNodes, Map ignoredNodes) {
        GraphNode alias;
        if (insertedNodes.containsKey(node)) {
            return;
        }
        ret.add(node);
        insertedNodes.put(node, null);
        if (node.getExtension() != null) {
            this.getNodesInsertNode(node.getExtension(), ret, insertedNodes, ignoredNodes);
        }
        if ((alias = node.getAlias()) != null && !insertedNodes.containsKey(alias)) {
            if (alias.getRefCount() <= 1) {
                ignoredNodes.put(alias, null);
            } else {
                ret.add(alias);
                insertedNodes.put(alias, null);
            }
        }
    }

    @Override
    public GraphNode getNode(String uniqueName) {
        return (GraphNode)this.nameHash.get(uniqueName);
    }

    @Override
    public GraphNode getRoot() {
        return this.rootNode;
    }

    static void dumpAttributes(GraphNode elt, StringBuffer str, String indent) {
        AttrProp[] attrList = elt.getAttributes();
        for (int i = 0; i < attrList.length; ++i) {
            str.append(indent + INDENT + "[attr: " + attrList[i] + "]\n");
        }
    }

    static void dumpTree(List children, StringBuffer str, String indent, boolean tree) {
        for (GraphLink l : children) {
            TreeBuilder.dumpTree(l, str, indent, tree);
        }
    }

    static void dumpTree(GraphLink l, StringBuffer str, String indent, boolean tree) {
        if (l == null) {
            return;
        }
        if (l.element != null) {
            str.append(indent);
            str.append(l.name + " : " + l.element.toString());
            str.append(TreeBuilder.instanceToString(l.getElementInstance(), false) + "\n");
            TreeBuilder.dumpAttributes(l.element, str, indent);
            if (tree && !l.element.getMarked()) {
                l.element.setMarked(true);
                TreeBuilder.dumpTree(l.element.getGraphLink(), str, indent + INDENT + TreeBuilder.instanceToString(l.getGroupInstance(), false) + (l.isSequenceOr() ? "| " : " "), tree);
                l.element.setMarked(false);
            }
        }
        if (l.isSequenceOr() || l.getGroupInstance() != 32) {
            str.append(indent + TreeBuilder.instanceToString(l.getGroupInstance(), false) + (l.isSequenceOr() ? "|\n" : "\n"));
        }
        TreeBuilder.dumpTree(l.getChildren(), str, indent + INDENT, tree);
    }

    public String dump() {
        StringBuffer str = new StringBuffer();
        str.append("Tree:\n");
        str.append(this.rootNode.toString());
        str.append("\n");
        TreeBuilder.dumpAttributes(this.rootNode, str, INDENT);
        TreeBuilder.dumpTree(this.rootNode.getGraphLink(), str, INDENT, true);
        return str.toString();
    }

    @Override
    public void setPrefixGuesser(PrefixGuesser guesser) {
        this.prefixGuesser = guesser;
    }

    @Override
    public PrefixGuesser getPrefixGuesser() {
        return this.prefixGuesser;
    }
}

