/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import org.netbeans.modules.schema2beans.AttrProp;
import org.netbeans.modules.schema2beans.BaseAttribute;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.schema2beans.BaseProperty;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.DDLogFlags;
import org.netbeans.modules.schema2beans.DOMBinding;
import org.netbeans.modules.schema2beans.NodeFactory;
import org.netbeans.modules.schema2beans.Schema2BeansException;
import org.netbeans.modules.schema2beans.Schema2BeansRuntimeException;
import org.netbeans.modules.schema2beans.TraceLogger;
import org.netbeans.modules.schema2beans.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class BeanProp
implements BaseProperty {
    static boolean handleEvents = false;
    static boolean handleVetoEvents = false;
    private static final int OP_SETTER_SETARRAY = 1;
    private static final int OP_SETTER_SETELT = 2;
    private static final int OP_SETTER_ADD = 4;
    private static final int OP_SETTER_REMOVE = 8;
    public String dtdName;
    public String beanName;
    public int type;
    public Class propClass;
    ArrayList bindings;
    ArrayList knownValues;
    ArrayList attributes;
    BaseBean bean;
    PropertyChangeSupport changeListeners;
    VetoableChangeSupport vetoableListeners;
    EventMgr eventMgr;
    boolean isRoot;
    private int order;
    GroupProp group;

    public BeanProp(BaseBean bean, String dtdName, String beanName, int type2, Class propClass) {
        this(bean, dtdName, beanName, type2, propClass, 10);
    }

    public BeanProp(BaseBean bean, String dtdName, String beanName, int type2, Class propClass, int initialCapacity) {
        this.dtdName = dtdName;
        this.beanName = beanName;
        this.type = type2;
        this.propClass = propClass;
        this.bean = bean;
        if (initialCapacity >= 0) {
            this.bindings = new ArrayList(initialCapacity);
            this.attributes = new ArrayList(initialCapacity);
        }
        this.changeListeners = null;
        this.vetoableListeners = null;
        this.knownValues = null;
        this.isRoot = false;
        this.order = 0;
        this.eventMgr = new EventMgr(this);
        this.group = null;
    }

    public BeanProp(BaseBean bean, String dtdName, String beanName, int type2, Class propClass, boolean isRoot) {
        this(bean, dtdName, beanName, type2, propClass, isRoot, 10);
    }

    public BeanProp(BaseBean bean, String dtdName, String beanName, int type2, Class propClass, boolean isRoot, int initialCapacity) {
        this(bean, dtdName, beanName, type2, propClass, initialCapacity);
        this.isRoot = isRoot;
    }

    public void initialize() {
        if (Common.isSequenceOr(this.type)) {
            BeanProp previousProp = null;
            if (this.order > 1) {
                previousProp = this.bean.beanProp(this.order - 1);
            }
            if (previousProp != null && previousProp.group != null) {
                previousProp.group.add(this);
                this.group = previousProp.group;
            }
            if (this.group == null) {
                this.group = new GroupProp(this);
            }
        }
    }

    boolean useEvents() {
        return handleEvents;
    }

    boolean useVetoEvents() {
        return handleVetoEvents;
    }

    void setOrder(int order) {
        this.order = order;
    }

    public Class getPropClass() {
        return this.propClass;
    }

    public int getType() {
        return this.type;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public BaseBean getBean() {
        return this.bean;
    }

    @Override
    public BaseBean getParent() {
        return this.getBean();
    }

    NodeFactory getNodeFactory() {
        return this.bean.graphManager().getNodeFactory();
    }

    Node getParentNode() {
        if (this.isRoot) {
            return null;
        }
        Node n = null;
        DOMBinding b = this.bean.domBinding();
        if (b != null) {
            n = b.getNode();
        }
        if (n == null) {
            throw new IllegalStateException(Common.getMessage("ParentNodeCantBeNull_msg"));
        }
        return n;
    }

    Node getFollowingSibling(DOMBinding binding) {
        BeanProp bp = null;
        int next = this.order + 1;
        bp = this.bean.beanProp(next++);
        while (bp != null) {
            boolean found = false;
            int size = bp.size();
            for (int i = 0; i < size; ++i) {
                DOMBinding b = bp.getBinding(i);
                if (b == null || b.getNode() == null) continue;
                found = true;
                break;
            }
            if (found) break;
            bp = this.bean.beanProp(next++);
        }
        if (bp != null) {
            if (Common.isArray(bp.type)) {
                int size = bp.size();
                for (int i = 0; i < size; ++i) {
                    DOMBinding b1 = bp.getBinding(i);
                    if (b1 == null) continue;
                    boolean found = false;
                    Node n1 = b1.getNode();
                    Node p = n1.getPreviousSibling();
                    while (p instanceof Text) {
                        p = p.getPreviousSibling();
                    }
                    for (int j = 0; j < size; ++j) {
                        DOMBinding b2;
                        if (i == j || (b2 = bp.getBinding(j)) == null || b2.getNode() != p) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    return n1;
                }
            } else {
                return bp.getBinding(0).getNode();
            }
        }
        return null;
    }

    DOMBinding getBinding(int index) {
        return (DOMBinding)this.bindings.get(index);
    }

    protected int bindingsSize() {
        return this.bindings.size();
    }

    public Object getValue(int index) {
        if (!(Common.isArray(this.type) || index <= 0 && this.bindingsSize() != 0)) {
            return null;
        }
        if (this.bindingsSize() == 0) {
            return null;
        }
        DOMBinding b = (DOMBinding)this.bindings.get(index);
        if (b != null) {
            return b.getValue(this);
        }
        return null;
    }

    public Object getValueById(int id) {
        int size = this.bindingsSize();
        for (int i = 0; i < size; ++i) {
            DOMBinding b = (DOMBinding)this.bindings.get(i);
            if (b.id != id) continue;
            return b.getValue(this);
        }
        return null;
    }

    public int indexToId(int index) {
        DOMBinding b;
        if (index >= 0 && index < this.bindingsSize() && (b = (DOMBinding)this.bindings.get(index)) != null) {
            return b.id;
        }
        return -1;
    }

    public int idToIndex(int id) {
        int size = this.bindingsSize();
        for (int i = 0; i < size; ++i) {
            DOMBinding b = (DOMBinding)this.bindings.get(i);
            if (b == null || b.id != id) continue;
            return i;
        }
        return -1;
    }

    protected Object[] getObjectArray(int extraElements) {
        int size = this.bindingsSize();
        Object a = Array.newInstance(this.propClass, size + extraElements >= 0 ? size + extraElements : size);
        int i = 0;
        try {
            if (extraElements >= 0) {
                for (i = 0; i < size; ++i) {
                    Array.set(a, i, this.getValue(i));
                }
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            System.err.println("bean: " + this.getName() + "dtdname: " + this.getDtdName() + "class: " + this.getPropertyClass());
            Object o = this.getValue(i);
            if (o != null) {
                System.err.println("elt: " + o.toString() + " - " + o.getClass());
            } else {
                System.err.println("elt is null for index " + i);
            }
            try {
                this.getBean().write(System.err);
                System.err.println(this.getBean().dumpDomNode());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
        return (Object[])a;
    }

    public Object[] getValues() {
        if (!Common.isArray(this.type)) {
            throw new IllegalStateException(Common.getMessage("NotIndexedProperty_msg"));
        }
        return this.getObjectArray(0);
    }

    public void setValue(Object[] value) {
        DOMBinding b;
        int j;
        int i;
        if (Common.isVetoable(this.type) && this.useVetoEvents()) {
            this.raiseVetoableEvent(value, 0, 1);
        }
        int newSize = 0;
        int size = this.bindingsSize();
        boolean[] skipNew = null;
        boolean changed = false;
        Object oldValue = null;
        if (this.useEvents()) {
            oldValue = Array.newInstance(this.propClass, size);
        }
        this.eventMgr.delay();
        if (value != null) {
            newSize = value.length;
            skipNew = new boolean[newSize];
            Arrays.fill(skipNew, false);
        }
        for (i = 0; i < size; ++i) {
            DOMBinding d = (DOMBinding)this.bindings.get(i);
            if (d == null) continue;
            d.posDOM = i;
        }
        for (i = 0; i < size; ++i) {
            boolean found = false;
            Object o = this.getValue(i);
            if (o == null) continue;
            for (j = 0; j < newSize; ++j) {
                if (skipNew[j] || value[j] == null || o != value[j]) continue;
                found = true;
                break;
            }
            if (!found) {
                for (j = 0; j < newSize; ++j) {
                    if (skipNew[j] || value[j] == null || !o.equals(value[j])) continue;
                    found = true;
                    break;
                }
            }
            if (!found) {
                if (this.useEvents()) {
                    if (Common.isBean(this.type)) {
                        Array.set(oldValue, i, ((BaseBean)o).clone());
                    } else {
                        Array.set(oldValue, i, o);
                    }
                    changed = true;
                }
                this.removeElement(i, false);
                continue;
            }
            if (this.useEvents()) {
                Array.set(oldValue, i, o);
                if (i != j) {
                    changed = true;
                }
            }
            skipNew[j] = true;
            b = (DOMBinding)this.bindings.get(i);
            b.pos = j;
        }
        for (i = 0; i < newSize; ++i) {
            if (skipNew[i] || value[i] == null) continue;
            int idx = this.setElement(0, value[i], true);
            b = (DOMBinding)this.bindings.get(idx);
            b.pos = i;
            b.posDOM = idx;
            changed = true;
        }
        ArrayList<DOMBinding> newBindings = new ArrayList<DOMBinding>(newSize);
        for (i = 0; i < newSize; ++i) {
            newBindings.add(null);
        }
        newBindings.ensureCapacity(newSize + 1);
        size = this.bindingsSize();
        for (i = 0; i < size; ++i) {
            b = (DOMBinding)this.bindings.get(i);
            if (b == null) continue;
            newBindings.set(b.pos, b);
        }
        this.bindings = newBindings;
        if (changed && this.bean.binding != null) {
            PropertyChangeEvent e = this.createEvent(this.bean.binding, oldValue, value, null);
            this.notifyInternal(e, true);
        }
        if (changed) {
            for (i = 0; i < newSize; ++i) {
                DOMBinding d1 = (DOMBinding)this.bindings.get(i);
                if (d1 == null) continue;
                DOMBinding db = null;
                int min = d1.posDOM;
                for (j = i + 1; j < newSize; ++j) {
                    DOMBinding d2 = (DOMBinding)this.bindings.get(j);
                    if (d2.posDOM >= min) continue;
                    min = d2.posDOM;
                    db = d2;
                }
                if (db == null) continue;
                d1.moveBefore(this, db.getNode());
            }
        }
        this.eventMgr.fireEvents();
    }

    public void setValue(int index, Object value) {
        if (Common.isVetoable(this.type) && this.useVetoEvents()) {
            this.raiseVetoableEvent(value, index, 2);
        }
        this.setElement(index, value, false);
    }

    public int addValue(Object value) {
        if (Common.isVetoable(this.type) && this.useVetoEvents()) {
            this.raiseVetoableEvent(value, 0, 4);
        }
        return this.setElement(0, value, true);
    }

    public int removeValue(Object value) {
        Object o;
        DOMBinding b;
        int i;
        if (Common.isVetoable(this.type) && this.useVetoEvents()) {
            this.raiseVetoableEvent(value, 0, 8);
        }
        int size = this.bindingsSize();
        int index = -1;
        for (i = 0; i < size && index == -1; ++i) {
            b = (DOMBinding)this.bindings.get(i);
            if (b == null || (o = b.getValue(this)) == null || o != value) continue;
            index = i;
        }
        for (i = 0; i < size && index == -1; ++i) {
            b = (DOMBinding)this.bindings.get(i);
            if (b == null || (o = b.getValue(this)) == null || !o.equals(value)) continue;
            index = i;
        }
        if (index != -1) {
            this.removeElement(index, true);
        } else {
            index = 0;
        }
        return index;
    }

    public void removeValue(int index) {
        DOMBinding b;
        if (index >= this.bindingsSize() && Common.isVetoable(this.type) && this.useVetoEvents() && (b = (DOMBinding)this.bindings.get(index)) != null) {
            Object value = b.getValue(this);
            this.raiseVetoableEvent(value, 0, 8);
        }
        this.removeElement(index, true);
    }

    private void checkParams(int index, Object value, boolean add) {
        if (add) {
            if (value == null) {
                throw new IllegalArgumentException(Common.getMessage("CannotAddNullValue_msg"));
            }
        } else if (!Common.isArray(this.type)) {
            if (index > 0) {
                throw new IllegalArgumentException(Common.getMessage("InvalidIndexForTypeProperty_msg"));
            }
        } else if (index < 0 || index >= this.bindingsSize()) {
            throw new IndexOutOfBoundsException();
        }
    }

    protected int setElement(int index, Object value, boolean add) {
        this.checkParams(index, value, add);
        if (value != null && Common.isBean(this.type) && ((BaseBean)value).hasDomNode()) {
            Document doc1 = null;
            Document doc2 = null;
            DOMBinding domBinding1 = ((BaseBean)value).domBinding();
            DOMBinding domBinding2 = this.bean.domBinding();
            if (domBinding1 != null && domBinding2 != null) {
                Node node1 = domBinding1.getNode();
                Node node2 = domBinding2.getNode();
                if (node1 != null && node2 != null) {
                    doc1 = node1.getOwnerDocument();
                    doc2 = node2.getOwnerDocument();
                }
            }
            if (doc1 != null && doc1 == doc2) {
                throw new IllegalArgumentException(Common.getMessage("CannotInsertElementAlreadyInGraph_msg"));
            }
        }
        if (DDLogFlags.debug) {
            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 13, 1, 15, this.dtdName + "[" + index + "] - " + (value == null ? "null" : value.toString()));
        }
        this.eventMgr.delay();
        if (value != null) {
            if (Common.isBean(this.type) && !add) {
                this.removeElement(index, false);
            }
            DOMBinding b = null;
            boolean empty = true;
            Object oldValue = null;
            if (!add) {
                boolean bl = empty = this.bindingsSize() == 0;
                if (!empty) {
                    b = (DOMBinding)this.bindings.get(index);
                }
            }
            if (b == null) {
                b = new DOMBinding();
                b.register(this, value);
                b.setDefaultAttributeValues(this);
            }
            if (add) {
                index = this.bindingsSize();
            }
            if (empty) {
                this.bindings.add(b);
            } else {
                this.bindings.set(index, b);
            }
            if (DDLogFlags.debug) {
                TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 13, 1, 16, this.dtdName + "[" + (empty ? 0 : index) + "]");
            }
            oldValue = b.setValue(this, value);
            if (this.bean.hasDomNode()) {
                b.syncNodes(this, new Action(1));
            } else if (DDLogFlags.debug) {
                TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 13, 1, 18, this.dtdName);
            }
            b.notifyBeansForChange(oldValue, value, null);
            if (Common.isBean(this.type) && value != null) {
                BaseBean bb = (BaseBean)value;
                String[] names = bb.cachedAttributeNames();
                for (int i = 0; i < names.length; ++i) {
                    this.setAttributeValue(index, names[i], bb.cachedAttributeValue(names[i]));
                }
                bb.cachedAttributeClear();
            }
        } else {
            this.removeElement(index, false);
        }
        this.eventMgr.fireEvents();
        return index;
    }

    private void removeElement(int index, boolean remove) {
        if (index >= this.bindingsSize()) {
            return;
        }
        DOMBinding b = (DOMBinding)this.bindings.get(index);
        if (b != null) {
            Object oldValue = b.getValue(this);
            b.setLastKnownIndex(this, index);
            PropertyChangeEvent e = this.createEvent(b, oldValue, null, null);
            if (DDLogFlags.debug) {
                TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 14, 1, 2, (e == null ? "no-event" : e.getPropertyName()) + " - source " + this.beanName + "\n\t\toldValue is " + (oldValue == null ? "<null>" : "<" + oldValue.toString() + ">") + "\n\t\tnewValue is null");
            }
            if (remove) {
                this.bindings.remove(index);
            } else {
                this.bindings.set(index, null);
            }
            b.syncNodes(this, new Action(2, e));
            this.notifyInternal(e, true);
        }
    }

    public Object[] knownValues() {
        if (this.knownValues == null) {
            return null;
        }
        int size = this.knownValues.size();
        Object a = Array.newInstance(this.propClass, size);
        for (int i = 0; i < size; ++i) {
            Array.set(a, i, this.knownValues.get(i));
        }
        return (Object[])a;
    }

    protected void addKnownValue(Object value) {
        if (this.knownValues == null) {
            this.knownValues = new ArrayList();
        }
        if (this.propClass.isAssignableFrom(value.getClass())) {
            this.knownValues.add(value);
        }
    }

    public void createAttribute(String dtdName, String name, int type2, String[] values, String defValue) {
        AttrProp ap = new AttrProp(this.dtdName, dtdName, name, type2, values, defValue);
        this.attributes.add(ap);
        if (DDLogFlags.debug) {
            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 13, 5, 23, this.beanName + ": " + ap.toString());
        }
    }

    public void createTransientAttribute(String dtdName) {
        AttrProp ap = this.getAttrProp(dtdName, true);
        if (ap != null) {
            return;
        }
        ap = new AttrProp(this.dtdName, dtdName, Common.convertName(dtdName), 4609, null, null);
        this.attributes.add(ap);
        if (DDLogFlags.debug) {
            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 13, 5, 23, this.beanName + ": " + ap.toString());
        }
    }

    @Override
    public BaseAttribute[] getAttributes() {
        int size = this.attributes.size();
        AttrProp[] ret = new AttrProp[size];
        return this.attributes.toArray(ret);
    }

    @Override
    public String[] getAttributeNames() {
        int size = this.attributes.size();
        String[] ret = new String[size];
        for (int i = 0; i < size; ++i) {
            AttrProp ap = (AttrProp)this.attributes.get(i);
            ret[i] = ap.getName();
        }
        return ret;
    }

    public AttrProp getAttrProp(String name, boolean quiet) {
        int size = this.attributes.size();
        for (int i = 0; i < size; ++i) {
            AttrProp ap = (AttrProp)this.attributes.get(i);
            if (!ap.hasName(name)) continue;
            return ap;
        }
        if (!quiet) {
            throw new IllegalArgumentException(Common.getMessage("UnknownAttributeForProperty_msg", name, this.beanName));
        }
        return null;
    }

    public AttrProp getAttrProp(String name) {
        return this.getAttrProp(name, false);
    }

    public void setAttributeValue(int index, String name, String value) {
        AttrProp ap = this.getAttrProp(name);
        this.checkParams(index, null, false);
        if (ap.isFixed() && (ap.defaultValue == null || !ap.defaultValue.equals(value))) {
            throw new IllegalStateException(Common.getMessage("CannotChangeFIXEDAttribute_msg"));
        }
        if (ap.isEnum() && value != null) {
            String[] values = ap.getValues();
            boolean found = false;
            for (int i = 0; i < values.length; ++i) {
                if (!values[i].equals(value)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new IllegalArgumentException(Common.getMessage("ValueDoesNotMatchEnumValues_msg", value, ap.enumsToString()));
            }
        }
        DOMBinding b = null;
        if (index != 0 || this.bindingsSize() != 0) {
            b = (DOMBinding)this.bindings.get(index);
        } else if (DDLogFlags.debug) {
            System.err.println("What DOMBinding should I use for BeanProp.setAttributeValue?!?");
        }
        if (b != null) {
            String oldValue = b.getAttributeValue(this, ap.getDtdName());
            b.setAttributeValue(this, ap.getDtdName(), this.normalizedAttrValue(value));
            b.notifyBeansForChange(oldValue, value, name);
        }
    }

    private String normalizedAttrValue(String value) {
        if (value == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (XMLUtil.isAttrContent(ch)) {
                sb.append(ch);
                continue;
            }
            sb.append('?');
        }
        return sb.toString();
    }

    public String getAttributeValue(int index, String name) {
        String ret = null;
        AttrProp ap = this.getAttrProp(name);
        if (!(Common.isArray(this.type) || index <= 0 && this.bindingsSize() != 0)) {
            return null;
        }
        DOMBinding b = (DOMBinding)this.bindings.get(index);
        if (b != null) {
            ret = b.getAttributeValue(this, ap.getDtdName());
        }
        if (DDLogFlags.debug) {
            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 13, 10, 24, this.beanName + "[" + index + "]." + ap.getDtdName() + ": " + ret + " " + (b == null ? "<no binding>" : "B(" + b.hashCode() + ")") + " BP(" + this.hashCode() + ")");
        }
        return ret;
    }

    void removeBinding(DOMBinding binding) {
        throw new UnsupportedOperationException(Common.getMessage("NotImplementedYet_msg"));
    }

    void syncNodes(Action a) {
        int size = this.bindingsSize();
        for (int i = 0; i < size; ++i) {
            DOMBinding b = (DOMBinding)this.bindings.get(i);
            if (b == null) continue;
            b.syncNodes(this, a);
        }
    }

    void buildPathName(DOMBinding binding, StringBuffer str) {
        if (binding == null) {
            return;
        }
        if (Common.isArray(this.type)) {
            DOMBinding b = null;
            int size = this.bindingsSize();
            int index = binding.getLastKnownIndex(this);
            for (int i = 0; i < size && (b = (DOMBinding)this.bindings.get(i)) != binding; ++i) {
                b = null;
            }
            if (index != -1) {
                str.insert(0, "i" + index);
            }
            if (b != null) {
                str.insert(0, b.idToString());
            } else {
                str.insert(0, "-1");
            }
            str.insert(0, ".");
        }
        str.insert(0, this.beanName);
        str.insert(0, "/");
        if (!this.isRoot && this.bean != null) {
            this.bean.buildPathName(str);
        }
    }

    PropertyChangeEvent createEvent(DOMBinding b, Object oldValue, Object newValue, String attrName) {
        if (!this.useEvents() && !this.useVetoEvents()) {
            return null;
        }
        StringBuffer name = new StringBuffer();
        if (attrName != null) {
            name.append(":");
            name.append(attrName);
        }
        this.buildPathName(b, name);
        return new PropertyChangeEvent(this.bean, name.toString(), oldValue, newValue);
    }

    PropertyChangeEvent prepareForChangeEvent(DOMBinding b, Object oldValue, Object newValue, String attrName) {
        if (!this.useEvents()) {
            return null;
        }
        PropertyChangeEvent e = this.createEvent(b, oldValue, newValue, attrName);
        if (DDLogFlags.debug) {
            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 14, 1, 1, (e == null ? "no-event" : e.getPropertyName()) + " - source " + this.beanName + "\n\t\toldValue is " + (oldValue == null ? "<null>" : "<" + oldValue.toString() + ">") + "\n\t\tnewValue is " + (newValue == null ? "<null>" : "<" + newValue.toString() + ">"));
        }
        return e;
    }

    void notifyInternal(PropertyChangeEvent e, boolean propagate) {
        this.notifyInternal(new InternalEvent(1, e), propagate);
    }

    void notifyInternal(InternalEvent ie, boolean propagate) {
        if (ie.type == 1) {
            if (!this.useEvents()) {
                return;
            }
            if (this.eventMgr.isDelayed()) {
                this.eventMgr.addEvent(ie.getPropertyChangeEvent(), propagate);
                return;
            }
            if (DDLogFlags.debug) {
                TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 14, 1, 3, ie.getPropertyChangeEvent().getPropertyName() + (propagate ? "(P)" : "") + " in " + this.beanName + " - " + (this.changeListeners == null ? "null listener" : (this.changeListeners.hasListeners(null) ? "has listeners" : "no listener")));
            }
            if (this.changeListeners != null) {
                this.changeListeners.firePropertyChange(ie.getPropertyChangeEvent());
            }
        } else if (ie.type == 2) {
            if (!this.useVetoEvents()) {
                return;
            }
            if (DDLogFlags.debug) {
                TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 14, 1, 6, ie.getPropertyChangeEvent().getPropertyName() + (propagate ? "(P)" : "") + " in " + this.beanName + " - " + (this.vetoableListeners == null ? "null listener" : (this.vetoableListeners.hasListeners(null) ? "has listeners" : "no listener")));
            }
            try {
                if (this.vetoableListeners != null) {
                    this.vetoableListeners.fireVetoableChange(ie.getPropertyChangeEvent());
                }
            }
            catch (PropertyVetoException ve) {
                throw new BaseProperty.VetoException(ve, Common.getMessage("ChangeForPropertyVetoed_msg", this.beanName));
            }
        }
        if (!this.isRoot && this.bean != null && propagate) {
            this.bean.notifyInternal(ie);
        }
    }

    private void raiseVetoableEvent(Object value, int index, int op) {
        Object curValue = null;
        Object[] newValue = null;
        if (Common.isArray(this.type)) {
            curValue = this.getValues();
            switch (op) {
                case 1: {
                    newValue = value;
                    break;
                }
                case 2: {
                    Object[] arrValue = this.getObjectArray(0);
                    arrValue[index] = value;
                    newValue = arrValue;
                    break;
                }
                case 4: {
                    Object[] arrValue = this.getObjectArray(1);
                    arrValue[this.bindingsSize()] = value;
                    newValue = arrValue;
                    break;
                }
                case 8: {
                    int i;
                    Object curValues = curValue;
                    Object[] arrValue = this.getObjectArray(-1);
                    for (i = 0; i < ((Object[])curValues).length && !curValues[i].equals(value); ++i) {
                    }
                    if (i < ((Object[])curValues).length) {
                        int j = 0;
                        for (i = 0; i < ((Object[])curValues).length; ++i) {
                            if (curValues[i].equals(value)) continue;
                            arrValue[j++] = curValues[i];
                        }
                    } else {
                        arrValue = curValues;
                    }
                    newValue = arrValue;
                }
            }
        } else {
            curValue = this.getValue(0);
            newValue = value;
        }
        PropertyChangeEvent e = this.createEvent(this.bean.binding, curValue, newValue, null);
        if (DDLogFlags.debug) {
            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 14, 1, 5, (e == null ? "no-event" : e.getPropertyName()) + " - source " + this.beanName + "\n\t\toldValue is " + (curValue == null ? "<null>" : "<" + curValue.toString() + ">") + "\n\t\tnewValue is " + (newValue == null ? "<null>" : "<" + newValue.toString() + ">"));
        }
        this.notifyInternal(new InternalEvent(2, e), true);
    }

    public void addPCListener(PropertyChangeListener l) {
        handleEvents = true;
        if (this.changeListeners == null) {
            Object obj = this.bean == null ? this : this.bean;
            this.changeListeners = new PropertyChangeSupport(obj);
        }
        this.changeListeners.addPropertyChangeListener(l);
    }

    public void removePCListener(PropertyChangeListener l) {
        if (this.changeListeners != null) {
            this.changeListeners.removePropertyChangeListener(l);
        }
    }

    public void addVCListener(VetoableChangeListener l) {
        if (this.checkVetoable(true)) {
            handleVetoEvents = true;
            if (this.vetoableListeners == null) {
                Object obj = this.bean == null ? this : this.bean;
                this.vetoableListeners = new VetoableChangeSupport(obj);
            }
            this.vetoableListeners.addVetoableChangeListener(l);
        }
    }

    public void removeVCListener(VetoableChangeListener l) {
        if (this.checkVetoable(false)) {
            this.vetoableListeners.removeVetoableChangeListener(l);
        }
    }

    private boolean checkVetoable(boolean raise) {
        if (Common.isVetoable(this.type) || Common.isBean(this.type)) {
            return true;
        }
        if (raise && !Common.isBean(this.type)) {
            throw new Schema2BeansRuntimeException(Common.getMessage("PropertyDoesntSupportVeto_msg", this.beanName));
        }
        return false;
    }

    BaseBean newBeanInstance() {
        if (Common.isBean(this.type)) {
            try {
                Constructor c = null;
                try {
                    Class[] cc = new Class[]{Integer.TYPE};
                    c = this.propClass.getDeclaredConstructor(cc);
                }
                catch (NoSuchMethodException me) {
                    return (BaseBean)this.propClass.newInstance();
                }
                Object[] p = new Object[]{new Integer(2)};
                return (BaseBean)c.newInstance(p);
            }
            catch (Exception e) {
                TraceLogger.error(e);
                throw new Schema2BeansRuntimeException(Common.getMessage("CantInstantiateBean_msg", e.getMessage()));
            }
        }
        return null;
    }

    public DOMBinding registerDomNode(Node node, DOMBinding binding, BaseBean bean) throws Schema2BeansException {
        int count = 0;
        int size = this.bindingsSize();
        for (int i = 0; i < size; ++i) {
            DOMBinding b = (DOMBinding)this.bindings.get(i);
            if (b.getNode() == node || binding == b) {
                throw new Schema2BeansException(Common.getMessage("NodeAlreadyReferenced_msg", node));
            }
            if (b.getNode() == null) continue;
            ++count;
        }
        if (count == 0 || Common.isArray(this.type)) {
            if (binding == null) {
                binding = new DOMBinding(node);
            }
            if (bean == null) {
                bean = this.newBeanInstance();
            }
        } else {
            if (DDLogFlags.debug) {
                TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 13, 1, 14, "exceeding capacity for " + this.dtdName + "(not an array)");
            }
            throw new Schema2BeansException(Common.getMessage("PropertyAlreadyBoundToDOMNode_msg", this.dtdName));
        }
        binding.register(this, bean);
        binding.setValue(this, bean);
        this.bindings.add(binding);
        return binding;
    }

    public String toString() {
        return this.dtdName;
    }

    @Override
    public boolean isRoot() {
        return this.isRoot;
    }

    @Override
    public String getName() {
        return this.beanName;
    }

    @Override
    public String getDtdName() {
        return this.dtdName;
    }

    @Override
    public boolean isIndexed() {
        return Common.isArray(this.type);
    }

    @Override
    public Class getPropertyClass() {
        return this.propClass;
    }

    @Override
    public boolean isBean() {
        return Common.isBean(this.type);
    }

    @Override
    public int size() {
        return this.bindingsSize();
    }

    @Override
    public String getFullName(int index) {
        return this.buildFullName(index, null);
    }

    @Override
    public String getFullName() {
        return this.buildFullName(0, null);
    }

    String buildFullName(int index, String attr) {
        StringBuffer name = new StringBuffer();
        if (!(Common.isArray(this.type) || index <= 0 && this.bindingsSize() != 0)) {
            return null;
        }
        DOMBinding b = (DOMBinding)this.bindings.get(index);
        if (b != null) {
            if (attr != null) {
                name.append(":");
                name.append(attr);
            }
        } else {
            return null;
        }
        this.buildPathName(b, name);
        return name.toString();
    }

    @Override
    public int getInstanceType() {
        return this.type & 0xF0;
    }

    @Override
    public boolean isChoiceProperty() {
        return this.group != null;
    }

    @Override
    public BaseProperty[] getChoiceProperties() {
        if (this.isChoiceProperty()) {
            return this.group.list();
        }
        return null;
    }

    @Override
    public boolean hasName(String name) {
        return name.equals(this.beanName) || name.equals(this.dtdName);
    }

    @Override
    public boolean isKey() {
        return Common.isKey(this.type);
    }

    static class InternalEvent {
        static final int CHANGED = 1;
        static final int VETOABLE = 2;
        int type;
        Object obj;

        public InternalEvent(int type2, Object obj) {
            this.type = type2;
            this.obj = obj;
        }

        PropertyChangeEvent getPropertyChangeEvent() {
            return (PropertyChangeEvent)this.obj;
        }
    }

    class EventMgr {
        private int delayed;
        private BeanProp bp;
        ArrayList events;

        public EventMgr(BeanProp bp) {
            this.bp = bp;
            this.delayed = 0;
            this.events = new ArrayList(2);
        }

        boolean isDelayed() {
            return this.delayed > 0;
        }

        void delay() {
            if (BeanProp.this.useEvents()) {
                ++this.delayed;
            }
        }

        void addEvent(PropertyChangeEvent e, boolean propagate) {
            if (BeanProp.this.useEvents()) {
                if (this.isDelayed()) {
                    this.events.add(new Evt(e, propagate));
                } else {
                    this.bp.notifyInternal(e, propagate);
                }
            }
        }

        void fireEvents() {
            if (BeanProp.this.useEvents()) {
                int size;
                if (this.delayed == 0) {
                    return;
                }
                --this.delayed;
                if (this.delayed == 0 && (size = this.events.size()) > 0) {
                    for (int i = 0; i < size; ++i) {
                        Evt e = (Evt)this.events.get(i);
                        this.bp.notifyInternal(e.event, e.propagate);
                    }
                    this.events.clear();
                }
            }
        }

        class Evt {
            PropertyChangeEvent event;
            boolean propagate;

            public Evt(PropertyChangeEvent evt, boolean p) {
                this.event = evt;
                this.propagate = p;
            }
        }
    }

    static class Action {
        public static final int ADD = 1;
        public static final int REMOVE = 2;
        int action;

        public Action(int action) {
            this.action = action;
        }

        public Action(int action, PropertyChangeEvent event) {
            this(action);
        }

        public String toString() {
            if (this.action == 1) {
                return "add";
            }
            return "remove";
        }
    }

    static class GroupProp {
        ArrayList group = new ArrayList();

        public GroupProp(BeanProp prop) {
            this.add(prop);
        }

        void add(BeanProp prop) {
            this.group.add(prop);
        }

        BeanProp[] list() {
            int size = this.group.size();
            BeanProp[] ret = new BeanProp[size];
            for (int i = 0; i < size; ++i) {
                ret[i] = (BeanProp)this.group.get(i);
            }
            return ret;
        }
    }
}

