/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import jakarta.enterprise.inject.spi.Bean;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.injection.producer.Injector;
import org.jboss.weld.injection.producer.LifecycleCallbackInvoker;
import org.jboss.weld.injection.producer.NonProducibleInjectionTarget;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.reflection.Reflections;

public class InjectionTargets {
    private InjectionTargets() {
    }

    public static <T> NonProducibleInjectionTarget<T> createNonProducibleInjectionTarget(EnhancedAnnotatedType<T> type2, Bean<T> bean, BeanManagerImpl beanManager) {
        return InjectionTargets.createNonProducibleInjectionTarget(type2, bean, null, null, beanManager);
    }

    public static <T> NonProducibleInjectionTarget<T> createNonProducibleInjectionTarget(EnhancedAnnotatedType<T> type2, Bean<T> bean, Injector<T> injector, LifecycleCallbackInvoker<T> invoker, BeanManagerImpl beanManager) {
        try {
            if (type2.isAbstract()) {
                if (type2.getJavaClass().isInterface()) {
                    throw BeanLogger.LOG.injectionTargetCannotBeCreatedForInterface(type2);
                }
                BeanLogger.LOG.injectionTargetCreatedForAbstractClass(type2.getJavaClass());
                return NonProducibleInjectionTarget.create(type2, bean, injector, invoker, beanManager);
            }
            if (!Reflections.isTopLevelOrStaticNestedClass(type2.getJavaClass())) {
                BeanLogger.LOG.injectionTargetCreatedForNonStaticInnerClass(type2.getJavaClass());
                return NonProducibleInjectionTarget.create(type2, bean, injector, invoker, beanManager);
            }
            if (Beans.getBeanConstructor(type2) == null) {
                if (bean != null) {
                    throw BeanLogger.LOG.injectionTargetCreatedForClassWithoutAppropriateConstructorException(type2.getJavaClass());
                }
                BeanLogger.LOG.injectionTargetCreatedForClassWithoutAppropriateConstructor(type2.getJavaClass());
                return NonProducibleInjectionTarget.create(type2, null, injector, invoker, beanManager);
            }
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
        return null;
    }
}

