/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer;

import jakarta.enterprise.inject.spi.Bean;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.List;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedConstructor;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.injection.ConstructorInjectionPoint;
import org.jboss.weld.injection.InjectionPointFactory;
import org.jboss.weld.injection.ParameterInjectionPoint;
import org.jboss.weld.injection.producer.AbstractInstantiator;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Beans;

public class DefaultInstantiator<T>
extends AbstractInstantiator<T> {
    private final ConstructorInjectionPoint<T> constructor;

    public DefaultInstantiator(EnhancedAnnotatedType<T> type2, Bean<T> bean, BeanManagerImpl manager) {
        EnhancedAnnotatedConstructor<T> constructor = Beans.getBeanConstructor(type2);
        this.constructor = InjectionPointFactory.instance().createConstructorInjectionPoint(bean, type2.getJavaClass(), constructor, manager);
    }

    @Override
    public ConstructorInjectionPoint<T> getConstructorInjectionPoint() {
        return this.constructor;
    }

    @Override
    public Constructor<T> getConstructor() {
        if (this.constructor == null) {
            return null;
        }
        return this.constructor.getAnnotated().getJavaMember();
    }

    public List<ParameterInjectionPoint<?, T>> getParameterInjectionPoints() {
        if (this.constructor == null) {
            return Collections.emptyList();
        }
        return this.constructor.getParameterInjectionPoints();
    }

    public String toString() {
        return "SimpleInstantiator [constructor=" + String.valueOf(this.constructor.getMember()) + "]";
    }

    @Override
    public boolean hasInterceptorSupport() {
        return false;
    }

    @Override
    public boolean hasDecoratorSupport() {
        return false;
    }
}

