/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.cdi.spi;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.validation.ConstraintValidator;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.hibernate.validator.cdi.internal.DestructibleBeanInstance;
import org.hibernate.validator.cdi.internal.util.BuiltInConstraintValidatorUtils;
import org.hibernate.validator.constraintvalidation.spi.DefaultConstraintValidatorFactory;
import org.hibernate.validator.internal.util.Contracts;

public class InjectingConstraintValidatorFactory
extends DefaultConstraintValidatorFactory {
    private final Map<Object, DestructibleBeanInstance<?>> constraintValidatorMap = Collections.synchronizedMap(new IdentityHashMap());
    private final BeanManager beanManager;

    @Inject
    public InjectingConstraintValidatorFactory(BeanManager beanManager) {
        Contracts.assertNotNull(beanManager, "The BeanManager cannot be null");
        this.beanManager = beanManager;
    }

    @Override
    public <T extends ConstraintValidator<?, ?>> T getInstance(Class<T> key) {
        if (BuiltInConstraintValidatorUtils.isBuiltInConstraintValidator(key)) {
            return super.getInstance(key);
        }
        DestructibleBeanInstance<Class<T>> destructibleBeanInstance = new DestructibleBeanInstance<Class<T>>(this.beanManager, key);
        this.constraintValidatorMap.put(destructibleBeanInstance.getInstance(), destructibleBeanInstance);
        return (T)((ConstraintValidator)((Object)destructibleBeanInstance.getInstance()));
    }

    @Override
    public void releaseInstance(ConstraintValidator<?, ?> instance) {
        DestructibleBeanInstance<?> destructibleBeanInstance = this.constraintValidatorMap.remove(instance);
        if (destructibleBeanInstance != null) {
            destructibleBeanInstance.destroy();
        }
    }
}

