/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.cdi.interceptor.spi;

import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundConstruct;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.ElementKind;
import jakarta.validation.Path;
import jakarta.validation.Validator;
import jakarta.validation.executable.ExecutableValidator;
import java.io.Serializable;
import java.lang.reflect.Member;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import org.hibernate.validator.cdi.interceptor.internal.MethodValidated;

@MethodValidated
@Interceptor
@Priority(value=4800)
public class ValidationInterceptor
implements Serializable {
    private static final long serialVersionUID = 604440259030722151L;
    @Inject
    private Validator validator;

    @AroundInvoke
    public Object validateMethodInvocation(InvocationContext ctx) throws Exception {
        ExecutableValidator executableValidator = this.validator.forExecutables();
        Set<ConstraintViolation<Object>> violations = executableValidator.validateParameters(ctx.getTarget(), ctx.getMethod(), ctx.getParameters(), new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(this.getMessage(ctx.getMethod(), ctx.getParameters(), violations), violations);
        }
        Object result = ctx.proceed();
        violations = executableValidator.validateReturnValue(ctx.getTarget(), ctx.getMethod(), result, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(this.getMessage(ctx.getMethod(), ctx.getParameters(), violations), violations);
        }
        return result;
    }

    @AroundConstruct
    public void validateConstructorInvocation(InvocationContext ctx) throws Exception {
        ExecutableValidator executableValidator = this.validator.forExecutables();
        Set<ConstraintViolation<Object>> violations = executableValidator.validateConstructorParameters(ctx.getConstructor(), ctx.getParameters(), new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(this.getMessage(ctx.getConstructor(), ctx.getParameters(), violations), violations);
        }
        ctx.proceed();
        Object createdObject = ctx.getTarget();
        violations = this.validator.forExecutables().validateConstructorReturnValue(ctx.getConstructor(), createdObject, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(this.getMessage(ctx.getConstructor(), ctx.getParameters(), violations), violations);
        }
    }

    private String getMessage(Member member, Object[] args, Set<? extends ConstraintViolation<?>> violations) {
        StringBuilder message = new StringBuilder();
        message.append(violations.size());
        message.append(" constraint violation(s) occurred during method validation.");
        message.append("\nConstructor or Method: ");
        message.append(member);
        message.append("\nArgument values: ");
        message.append(Arrays.toString(args));
        message.append("\nConstraint violations: ");
        int i = 1;
        for (ConstraintViolation<?> constraintViolation : violations) {
            Path.Node leafNode = this.getLeafNode(constraintViolation);
            message.append("\n (");
            message.append(i);
            message.append(")");
            message.append(" Kind: ");
            message.append((Object)leafNode.getKind());
            if (leafNode.getKind() == ElementKind.PARAMETER) {
                message.append("\n parameter index: ");
                message.append(leafNode.as(Path.ParameterNode.class).getParameterIndex());
            }
            message.append("\n message: ");
            message.append(constraintViolation.getMessage());
            message.append("\n root bean: ");
            message.append(constraintViolation.getRootBean());
            message.append("\n property path: ");
            message.append(constraintViolation.getPropertyPath());
            message.append("\n constraint: ");
            message.append(constraintViolation.getConstraintDescriptor().getAnnotation());
            ++i;
        }
        return message.toString();
    }

    private Path.Node getLeafNode(ConstraintViolation<?> constraintViolation) {
        Iterator nodes = constraintViolation.getPropertyPath().iterator();
        Path.Node leafNode = null;
        while (nodes.hasNext()) {
            leafNode = (Path.Node)nodes.next();
        }
        return leafNode;
    }
}

