/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld;

import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.inject.spi.CDIProvider;
import java.util.Map;
import java.util.Set;
import org.glassfish.weld.RootBeanDeploymentArchive;
import org.jboss.weld.Container;
import org.jboss.weld.SimpleCDI;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.manager.BeanManagerImpl;

public class GlassFishWeldProvider
implements CDIProvider {
    @Override
    public CDI<Object> getCDI() {
        try {
            return new GlassFishEnhancedWeld();
        }
        catch (Throwable throwable) {
            Throwable cause = throwable.getCause();
            if (cause instanceof IllegalStateException) {
                return null;
            }
            throw throwable;
        }
    }

    private static class GlassFishEnhancedWeld
    extends SimpleCDI {
        private GlassFishEnhancedWeld() {
        }

        @Override
        protected BeanManagerImpl unsatisfiedBeanManager(String callerClassName) {
            if (Container.instance().beanDeploymentArchives().values().size() == 1) {
                return Container.instance().beanDeploymentArchives().values().iterator().next();
            }
            Map<BeanDeploymentArchive, BeanManagerImpl> beanDeploymentArchives = Container.instance().beanDeploymentArchives();
            Set<Map.Entry<BeanDeploymentArchive, BeanManagerImpl>> entries = beanDeploymentArchives.entrySet();
            for (Map.Entry<BeanDeploymentArchive, BeanManagerImpl> entry : entries) {
                BeanDeploymentArchive beanDeploymentArchive = entry.getKey();
                if (!(beanDeploymentArchive instanceof RootBeanDeploymentArchive)) continue;
                RootBeanDeploymentArchive rootBeanDeploymentArchive = (RootBeanDeploymentArchive)beanDeploymentArchive;
                ClassLoader moduleClassLoaderForBDA = rootBeanDeploymentArchive.getModuleClassLoaderForBDA();
                try {
                    Class.forName(callerClassName, false, moduleClassLoaderForBDA);
                    return entry.getValue();
                }
                catch (Exception exception) {
                }
            }
            return super.unsatisfiedBeanManager(callerClassName);
        }
    }
}

