/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.ha.session.management;

import com.sun.appserv.util.cache.BaseCache;
import com.sun.enterprise.container.common.spi.util.JavaEEIOUtils;
import com.sun.web.security.RealmAdapter;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.Principal;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Loader;
import org.apache.catalina.Session;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.ha.store.api.Storeable;
import org.glassfish.ha.store.util.SimpleMetadata;
import org.glassfish.web.ha.session.management.BaseHASession;
import org.glassfish.web.ha.session.management.HASession;
import org.glassfish.web.ha.session.management.HAStoreBase;
import org.glassfish.web.ha.session.management.ReplicationManagerBase;
import org.glassfish.web.ha.session.management.SimpleMetadataFactory;

public class ReplicationStore
extends HAStoreBase {
    public ReplicationStore(JavaEEIOUtils ioUtils) {
        super(ioUtils);
    }

    @Override
    public String getApplicationId() {
        if (this.applicationId != null) {
            return this.applicationId;
        }
        this.applicationId = "WEB:" + super.getApplicationId();
        return this.applicationId;
    }

    public void valveSave(Session session) throws IOException {
        if (!(session instanceof HASession)) {
            return;
        }
        HASession haSess = (HASession)session;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>valveSave id=" + haSess.getIdInternal() + " isPersistent=" + haSess.isPersistent() + " isDirty=" + haSess.isDirty());
        }
        if (haSess.isPersistent() && !haSess.isDirty()) {
            this.updateLastAccessTime(session);
        } else {
            this.doValveSave(session);
            haSess.setPersistent(true);
        }
        haSess.setDirty(false);
        this.doValveSave(session);
    }

    public void doValveSave(Session session) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            if (session instanceof HASession) {
                _logger.fine("ReplicationStore>>doValveSave:id =" + ((HASession)session).getIdInternal());
            }
            _logger.fine("ReplicationStore>>doValveSave:valid =" + session.getIsValid());
        }
        if (!session.getIsValid()) {
            return;
        }
        if (!(session instanceof BaseHASession)) {
            return;
        }
        String userName = "";
        if (session.getPrincipal() != null) {
            userName = session.getPrincipal().getName();
            ((BaseHASession)session).setUserName(userName);
        }
        byte[] sessionState = this.getByteArray(session, this.isReplicationCompressionEnabled());
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("ReplicationStore->Byte array to save");
            StringBuilder sb = new StringBuilder("Session data{");
            for (byte b : sessionState) {
                sb.append(b + "_");
            }
            sb.append("}");
            _logger.finest(sb.toString());
        }
        BackingStore<String, SimpleMetadata> replicator = this.getSimpleMetadataBackingStore();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>doValveSave replicator: " + String.valueOf(replicator));
            _logger.fine("ReplicationStore>>doValveSave version:" + session.getVersion());
        }
        SimpleMetadata simpleMetadata = SimpleMetadataFactory.createSimpleMetadata(session.getVersion(), session.getLastAccessedTime(), (long)session.getMaxInactiveInterval() * 1000L, sessionState);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("In doValveSave metadata is " + String.valueOf(simpleMetadata));
        }
        try {
            HASession haSess = (HASession)session;
            replicator.save(session.getIdInternal(), simpleMetadata, haSess.isPersistent());
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Save succeeded.");
            }
        }
        catch (BackingStoreException ex) {
            IOException ex1 = (IOException)new IOException("Error during save: " + ex.getMessage()).initCause(ex);
            throw ex1;
        }
    }

    public void cleanup() {
    }

    public BaseCache getSessions() {
        return null;
    }

    public void setSessions(BaseCache sesstable) {
    }

    @Override
    public void stop() {
        try {
            super.stop();
            BackingStore<String, ? extends Storeable> backingStore = this.getStoreableBackingStore();
            backingStore.destroy();
        }
        catch (BackingStoreException backingStoreException) {
        }
        catch (LifecycleException lifecycleException) {
            // empty catch block
        }
    }

    @Override
    public void save(Session session) throws IOException {
        if (!(session instanceof HASession)) {
            return;
        }
        HASession haSess = (HASession)session;
        if (haSess.isPersistent() && !haSess.isDirty()) {
            this.updateLastAccessTime(session);
        } else {
            this.doSave(session);
            haSess.setPersistent(true);
        }
        haSess.setDirty(false);
    }

    protected boolean isReplicationCompressionEnabled() {
        return false;
    }

    public void doSave(Session session) throws IOException {
        if (!(session instanceof HASession)) {
            return;
        }
        byte[] sessionState = this.getByteArray(session, this.isReplicationCompressionEnabled());
        BackingStore<String, SimpleMetadata> backingStore = this.getSimpleMetadataBackingStore();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>save: backing store : " + String.valueOf(backingStore));
        }
        SimpleMetadata simpleMetadata = SimpleMetadataFactory.createSimpleMetadata(session.getVersion(), session.getLastAccessedTime(), (long)session.getMaxInactiveInterval() * 1000L, sessionState);
        try {
            backingStore.save(session.getIdInternal(), simpleMetadata, !((HASession)session).isPersistent());
        }
        catch (BackingStoreException ex) {
            IOException ex1 = (IOException)new IOException("Error during save: " + ex.getMessage()).initCause(ex);
            throw ex1;
        }
    }

    @Override
    public synchronized void clear() throws IOException {
    }

    @Override
    public void doRemove(String id) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>doRemove");
        }
        BackingStore<String, ? extends Storeable> replicator = this.getStoreableBackingStore();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>doRemove: replicator: " + String.valueOf(replicator));
        }
        try {
            replicator.remove(id);
        }
        catch (BackingStoreException ex) {
            _logger.log(Level.WARNING, "AS-WEB-HA-00001", ex);
        }
    }

    @Override
    public synchronized void removeSynchronized(String id) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>removeSynchronized");
        }
        BackingStore<String, ? extends Storeable> replicator = this.getStoreableBackingStore();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>removeSynchronized: replicator: " + String.valueOf(replicator));
        }
        try {
            replicator.remove(id);
        }
        catch (BackingStoreException ex) {
            _logger.log(Level.WARNING, "AS-WEB-HA-00001", ex);
        }
    }

    @Override
    public void processExpires() {
        this.removeExpiredSessions();
    }

    public int removeExpiredSessions() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("IN ReplicationStore>>removeExpiredSessions");
        }
        int result = 0;
        ReplicationManagerBase<? extends Storeable> mgr = this.getStoreableReplicationManager();
        if (mgr == null) {
            return result;
        }
        BackingStore<String, ? extends Storeable> backingStore = mgr.getBackingStore();
        if (backingStore != null) {
            try {
                result = backingStore.removeExpired(mgr.getMaxInactiveInterval());
            }
            catch (BackingStoreException ex) {
                _logger.log(Level.WARNING, "AS-WEB-HA-00002", ex);
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>removeExpiredSessions():number of expired sessions = " + result);
        }
        return result;
    }

    @Override
    public Session load(String id) throws ClassNotFoundException, IOException {
        return this.load(id, null);
    }

    @Override
    public Session load(String id, String version) throws ClassNotFoundException, IOException {
        try {
            return this.loadFromBackingStore(id, version);
        }
        catch (BackingStoreException ex) {
            IOException ex1 = (IOException)new IOException("Error during load: " + ex.getMessage()).initCause(ex);
            throw ex1;
        }
    }

    private Session loadFromBackingStore(String id, String version) throws IOException, ClassNotFoundException, BackingStoreException {
        SimpleMetadata metaData = this.getSimpleMetadataBackingStore().load(id, version);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("ReplicationStore>>loadFromBackingStore:id=" + id + ", metaData=" + String.valueOf(metaData));
        }
        Session session = this.getSession(metaData);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("ReplicationStore->Session is " + String.valueOf(session));
        }
        return session;
    }

    private BackingStore<String, ? extends Storeable> getStoreableBackingStore() {
        return this.getStoreableReplicationManager().getBackingStore();
    }

    private BackingStore<String, SimpleMetadata> getSimpleMetadataBackingStore() {
        ReplicationManagerBase mgr = (ReplicationManagerBase)this.getManager();
        return mgr.getBackingStore();
    }

    private ReplicationManagerBase<? extends Storeable> getStoreableReplicationManager() {
        return (ReplicationManagerBase)this.getManager();
    }

    public void updateLastAccessTime(Session session) throws IOException {
        if (!(session instanceof BaseHASession)) {
            return;
        }
        BackingStore<String, ? extends Storeable> backingStore = this.getStoreableBackingStore();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>updateLastAccessTime: replicator: " + String.valueOf(backingStore));
        }
        try {
            String string = backingStore.updateTimestamp(session.getIdInternal(), "" + session.getVersion(), ((BaseHASession)session).getLastAccessedTimeInternal());
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    @Override
    public String[] keys() throws IOException {
        return new String[0];
    }

    @Override
    public int getSize() throws IOException {
        int result;
        block3: {
            result = 0;
            BackingStore<String, ? extends Storeable> replicator = this.getStoreableBackingStore();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("ReplicationStore>>getSize: replicator: " + String.valueOf(replicator));
            }
            try {
                result = replicator.size();
            }
            catch (BackingStoreException ex) {
                if (!_logger.isLoggable(Level.FINE)) break block3;
                _logger.log(Level.FINE, "Exception is getSize", ex);
            }
        }
        return result;
    }

    private Session getSession(SimpleMetadata metaData) throws IOException {
        if (metaData == null || metaData.getState() == null) {
            return null;
        }
        return this.getSession(metaData.getState(), metaData.getVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession(byte[] state, long version) throws IOException {
        Session _session = null;
        ObjectInputStream ois = null;
        Loader loader = null;
        ClassLoader classLoader = null;
        Container container = this.manager.getContainer();
        Principal pal = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(state);
            BufferedInputStream bis = new BufferedInputStream(bais);
            FilterInputStream is = this.isReplicationCompressionEnabled() ? new GZIPInputStream(bis) : bis;
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("loaded session from replicationstore, length = " + state.length);
            }
            if ((loader = container.getLoader()) != null) {
                classLoader = loader.getClassLoader();
            }
            if (classLoader != null) {
                try {
                    ois = this.ioUtils.createObjectInputStream(is, true, classLoader);
                }
                catch (Exception ex) {
                    _logger.log(Level.WARNING, "AS-WEB-HA-00003", ex);
                }
            }
            if (ois == null) {
                ois = new ObjectInputStream(is);
            }
            try {
                _session = this.readSession(this.manager, ois);
            }
            finally {
                if (ois != null) {
                    try {
                        ois.close();
                        bis = null;
                    }
                    catch (IOException ex) {}
                }
            }
        }
        catch (ClassNotFoundException e) {
            IOException ex1 = (IOException)new IOException(_logger.getResourceBundle().getString("AS-WEB-HA-00004") + e.getMessage()).initCause(e);
            _logger.log(Level.WARNING, "AS-WEB-HA-00004", ex1);
            throw ex1;
        }
        catch (IOException e) {
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.log(Level.WARNING, "AS-WEB-HA-00005", e);
            }
            throw e;
        }
        String username = ((HASession)_session).getUserName();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>getSession: username=" + username + " principal=" + String.valueOf(_session.getPrincipal()));
        }
        if (username != null && !username.equals("") && _session.getPrincipal() == null) {
            if (this._debug > 0) {
                this.debug("Username retrieved is " + username);
            }
            pal = ((RealmAdapter)container.getRealm()).createFailOveredPrincipal(username);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("ReplicationStore>>getSession:created pal=" + String.valueOf(pal));
            }
            if (this._debug > 0) {
                this.debug("principal created using username  " + String.valueOf(pal));
            }
            if (pal != null) {
                _session.setPrincipal(pal);
                if (this._debug > 0) {
                    this.debug("getSession principal=" + String.valueOf(pal) + " was added to session=" + String.valueOf(_session));
                }
            }
        }
        _session.setNew(false);
        ((HASession)_session).setVersion(version);
        ((HASession)_session).setDirty(false);
        ((HASession)_session).setPersistent(false);
        return _session;
    }
}

