/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.ha.authenticator;

import com.sun.enterprise.container.common.spi.util.JavaEEIOUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.Principal;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.authenticator.SingleSignOnEntry;
import org.apache.catalina.core.StandardContext;
import org.glassfish.web.ha.LogFacade;
import org.glassfish.web.ha.authenticator.HASessionData;
import org.glassfish.web.ha.authenticator.HASingleSignOnEntryMetadata;

public class HASingleSignOnEntry
extends SingleSignOnEntry {
    private static final Logger logger = LogFacade.getLogger();
    protected long maxIdleTime;
    protected JavaEEIOUtils ioUtils;
    protected HASingleSignOnEntryMetadata metadata = null;
    protected ClassLoader appClassLoader;

    public HASingleSignOnEntry() {
        this(null, null, null, null, null, 0L, 0L, 0L, null, null, null);
    }

    public HASingleSignOnEntry(Container container, HASingleSignOnEntryMetadata m, JavaEEIOUtils ioUtils, ClassLoader appClassLoader) {
        this(m.getId(), null, m.getAuthType(), m.getUserName(), m.getRealmName(), m.getLastAccessTime(), m.getMaxIdleTime(), m.getVersion(), ioUtils, m.getPrincipalBytes(), appClassLoader);
        for (HASessionData data : m.getHASessionDataSet()) {
            StandardContext context = (StandardContext)container.findChild(data.getContextPath());
            Session session = null;
            try {
                session = context.getManager().findSession(data.getSessionId());
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
            if (session == null) continue;
            this.sessions.add(session);
        }
    }

    public HASingleSignOnEntry(String id, Principal principal, String authType, String username, String realmName, long lastAccessTime, long maxIdleTime, long version, JavaEEIOUtils ioUtils) {
        this(id, principal, authType, username, realmName, lastAccessTime, maxIdleTime, version, ioUtils, HASingleSignOnEntry.convertToByteArray(principal, ioUtils), null);
    }

    private HASingleSignOnEntry(String id, Principal principal, String authType, String username, String realmName, long lastAccessTime, long maxIdleTime, long version, JavaEEIOUtils ioUtils, byte[] principalBytes, ClassLoader appClassLoader) {
        super(id, version, principal, authType, username, realmName);
        this.lastAccessTime = lastAccessTime;
        this.maxIdleTime = maxIdleTime;
        this.ioUtils = ioUtils;
        this.appClassLoader = appClassLoader;
        if (principal == null && principalBytes != null) {
            this.principal = this.parse(principalBytes);
        }
        this.metadata = new HASingleSignOnEntryMetadata(id, version, principalBytes, authType, username, realmName, lastAccessTime, maxIdleTime);
        if (logger.isLoggable(Level.FINER)) {
            String pName = principal != null ? principal.getName() : null;
            logger.log(Level.FINER, "Loaded HA SSO entry with principal: " + pName);
        }
    }

    public HASingleSignOnEntryMetadata getMetadata() {
        return this.metadata;
    }

    public long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    @Override
    public synchronized boolean addSession(SingleSignOn sso, Session session) {
        boolean result = super.addSession(sso, session);
        if (result) {
            this.metadata.addHASessionData(new HASessionData(session.getId(), session.getManager().getContainer().getName()));
        }
        return result;
    }

    @Override
    public synchronized void removeSession(Session session) {
        super.removeSession(session);
        this.metadata.removeHASessionData(new HASessionData(session.getId(), session.getManager().getContainer().getName()));
    }

    @Override
    public void setLastAccessTime(long lastAccessTime) {
        super.setLastAccessTime(lastAccessTime);
        this.metadata.setLastAccessTime(lastAccessTime);
    }

    @Override
    public long incrementAndGetVersion() {
        long ver = super.incrementAndGetVersion();
        this.metadata.setVersion(ver);
        return ver;
    }

    private static byte[] convertToByteArray(Principal obj, JavaEEIOUtils ioUtils) {
        byte[] byArray;
        ByteArrayOutputStream baos = null;
        BufferedOutputStream bos = null;
        ObjectOutputStream oos = null;
        try {
            baos = new ByteArrayOutputStream();
            bos = new BufferedOutputStream(baos);
            oos = ioUtils.createObjectOutputStream(bos, true);
            oos.writeObject(obj);
            oos.flush();
            byArray = baos.toByteArray();
        }
        catch (Exception ex) {
            try {
                throw new IllegalStateException(ex);
            }
            catch (Throwable throwable) {
                HASingleSignOnEntry.closeSafely(baos);
                HASingleSignOnEntry.closeSafely(bos);
                HASingleSignOnEntry.closeSafely(oos);
                throw throwable;
            }
        }
        HASingleSignOnEntry.closeSafely(baos);
        HASingleSignOnEntry.closeSafely(bos);
        HASingleSignOnEntry.closeSafely(oos);
        return byArray;
    }

    private static void closeSafely(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private Principal parse(byte[] pbytes) {
        Principal principal;
        ObjectInputStream ois;
        BufferedInputStream bis;
        ByteArrayInputStream bais;
        block7: {
            bais = null;
            bis = null;
            ois = null;
            bais = new ByteArrayInputStream(pbytes);
            bis = new BufferedInputStream(bais);
            ois = this.ioUtils.createObjectInputStream(bis, true, this.getClass().getClassLoader());
            if (this.appClassLoader != null) break block7;
            Principal principal2 = (Principal)ois.readObject();
            HASingleSignOnEntry.closeSafely(bais);
            HASingleSignOnEntry.closeSafely(bis);
            HASingleSignOnEntry.closeSafely(ois);
            return principal2;
        }
        try {
            principal = (Principal)ois.readObject();
        }
        catch (ClassNotFoundException e) {
            Principal principal3;
            try {
                HASingleSignOnEntry.closeSafely(bais);
                HASingleSignOnEntry.closeSafely(bis);
                HASingleSignOnEntry.closeSafely(ois);
                bais = new ByteArrayInputStream(pbytes);
                bis = new BufferedInputStream(bais);
                ois = this.ioUtils.createObjectInputStream(bis, true, this.appClassLoader);
                principal3 = (Principal)ois.readObject();
            }
            catch (Exception ex) {
                try {
                    throw new IllegalStateException(ex);
                }
                catch (Throwable throwable) {
                    HASingleSignOnEntry.closeSafely(bais);
                    HASingleSignOnEntry.closeSafely(bis);
                    HASingleSignOnEntry.closeSafely(ois);
                    throw throwable;
                }
            }
            HASingleSignOnEntry.closeSafely(bais);
            HASingleSignOnEntry.closeSafely(bis);
            HASingleSignOnEntry.closeSafely(ois);
            return principal3;
        }
        HASingleSignOnEntry.closeSafely(bais);
        HASingleSignOnEntry.closeSafely(bis);
        HASingleSignOnEntry.closeSafely(ois);
        return principal;
    }
}

