/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.embed.impl;

import com.sun.enterprise.deployment.annotation.impl.ModuleScanner;
import com.sun.enterprise.deployment.archivist.ArchivistFor;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.classmodel.reflect.Parser;
import org.glassfish.internal.api.Globals;
import org.glassfish.web.LogFacade;
import org.glassfish.web.deployment.archivist.WebArchivist;
import org.glassfish.web.deployment.descriptor.WebBundleDescriptorImpl;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
@ArchivistFor(value="scattered-war")
public class ScatteredWebArchivist
extends WebArchivist {
    private static final Logger LOG = LogFacade.getLogger();
    private static URL defaultWebXmlLocation;
    private final EmbeddedWebScanner embeddedScanner = new EmbeddedWebScanner();

    static void setDefaultWebXml(URL defaultWebXml) {
        defaultWebXmlLocation = defaultWebXml;
    }

    @Override
    public URL getDefaultWebXML() throws IOException {
        if (defaultWebXmlLocation != null) {
            return defaultWebXmlLocation;
        }
        URL defaultWebXml = super.getDefaultWebXML();
        return defaultWebXml == null ? this.getClass().getClassLoader().getResource("org/glassfish/web/embed/default-web.xml") : defaultWebXml;
    }

    @Override
    public ArchiveType getModuleType() {
        return Globals.getDefaultHabitat().getService(ArchiveType.class, "scattered-war", new Annotation[0]);
    }

    public EmbeddedWebScanner getScanner() {
        return this.embeddedScanner;
    }

    private static class EmbeddedWebScanner
    extends ModuleScanner<WebBundleDescriptorImpl> {
        private final Set<Class<?>> elements = new HashSet();
        private ClassLoader classLoader;

        private EmbeddedWebScanner() {
        }

        @Override
        public void process(ReadableArchive archiveFile, WebBundleDescriptorImpl descriptor, ClassLoader classLoader, Parser parser) throws IOException {
            this.classLoader = classLoader;
            this.elements.clear();
            Enumeration<String> fileEntries = descriptor.getArchiveFileEntries(archiveFile);
            while (fileEntries.hasMoreElements()) {
                String entry = fileEntries.nextElement();
                if (!entry.endsWith(".class")) continue;
                try {
                    this.elements.add(classLoader.loadClass(this.toClassName(entry)));
                }
                catch (ClassNotFoundException e) {
                    LOG.log(Level.WARNING, "Cannot load class " + entry, e);
                }
            }
        }

        @Override
        protected void process(File archiveFile, WebBundleDescriptorImpl descriptor, ClassLoader classLoader) throws IOException {
        }

        private String toClassName(String entryName) {
            String name = entryName.substring("WEB-INF/classes/".length(), entryName.length() - ".class".length());
            return name.replaceAll("/", ".");
        }

        @Override
        public Set<Class<?>> getElements() {
            return this.elements;
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.classLoader;
        }
    }
}

