/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.wasp.runtime;

import jakarta.servlet.ServletResponse;
import jakarta.servlet.jsp.JspWriter;
import java.io.IOException;
import java.io.Writer;
import org.glassfish.jsp.api.ByteWriter;
import org.glassfish.wasp.compiler.Localizer;

public class JspWriterImpl
extends JspWriter {
    private static final int MAX_BUFFER_SIZE = Integer.getInteger("org.glassfish.wasp.runtime.JspWriterImpl.MAX_THREAD_LOCAL_BUFFER_SIZE", 32768);
    private static final ThreadLocal<CharBufferThreadLocalPool> charBufferPools = new ThreadLocal();
    private Writer out;
    private ServletResponse response;
    private CharBuffer buf;
    private boolean flushed = false;
    private boolean closed = false;
    protected boolean implementsByteWriter = true;
    protected ByteWriter byteOut;
    static String lineSeparator = System.getProperty("line.separator");

    public JspWriterImpl() {
        super(8192, true);
    }

    public JspWriterImpl(ServletResponse response) {
        this(response, 8192, true);
    }

    public JspWriterImpl(ServletResponse response, int sz, boolean autoFlush) {
        super(sz, autoFlush);
        if (sz < 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.response = response;
        this.allocateCharBuffer();
        try {
            response.setBufferSize(sz);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    void init(ServletResponse response, int sz, boolean autoFlush) {
        this.response = response;
        this.autoFlush = autoFlush;
        this.bufferSize = sz;
        this.allocateCharBuffer();
        try {
            response.setBufferSize(sz);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    void recycle() {
        this.flushed = false;
        this.closed = false;
        this.out = null;
        this.byteOut = null;
        this.releaseCharBuffer();
        this.response = null;
    }

    protected final void flushBuffer() throws IOException {
        if (this.bufferSize == 0) {
            return;
        }
        this.flushed = true;
        this.ensureOpen();
        if (this.buf.pos == this.buf.offset) {
            return;
        }
        this.initOut();
        this.out.write(this.buf.buf, this.buf.offset, this.buf.pos - this.buf.offset);
        this.buf.pos = this.buf.offset;
    }

    private void initOut() throws IOException {
        if (this.out == null) {
            this.out = this.response.getWriter();
        }
    }

    private String getLocalizeMessage(String message) {
        return Localizer.getMessage(message);
    }

    @Override
    public final void clear() throws IOException {
        if (this.bufferSize == 0 && this.out != null) {
            throw new IllegalStateException(this.getLocalizeMessage("jsp.error.ise_on_clear"));
        }
        if (this.flushed) {
            throw new IOException(this.getLocalizeMessage("jsp.error.attempt_to_clear_flushed_buffer"));
        }
        this.ensureOpen();
        if (this.buf != null) {
            this.buf.pos = this.buf.offset;
        }
    }

    @Override
    public void clearBuffer() throws IOException {
        if (this.bufferSize == 0) {
            throw new IllegalStateException(this.getLocalizeMessage("jsp.error.ise_on_clear"));
        }
        this.ensureOpen();
        this.buf.pos = this.buf.offset;
    }

    private final void bufferOverflow() throws IOException {
        throw new IOException(this.getLocalizeMessage("jsp.error.overflow"));
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        if (this.out != null) {
            this.out.flush();
        } else {
            this.response.setCharacterEncoding(this.response.getCharacterEncoding());
            this.response.flushBuffer();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.response == null || this.closed) {
            return;
        }
        this.flush();
        if (this.out != null) {
            this.out.close();
        }
        this.out = null;
        this.byteOut = null;
        this.closed = true;
    }

    @Override
    public int getRemaining() {
        return this.buf == null ? 0 : this.buf.lim - this.buf.pos;
    }

    private void ensureOpen() throws IOException {
        if (this.response == null || this.closed) {
            throw new IOException("Stream closed");
        }
    }

    public void write(boolean bytesOK, byte[] buf, String str) throws IOException {
        this.ensureOpen();
        if (this.bufferSize == 0 && bytesOK) {
            this.initByteOut();
            if (this.implementsByteWriter) {
                this.write(buf, 0, buf.length);
                return;
            }
        }
        this.write(str);
    }

    boolean shouldOutputBytes() {
        if (this.bufferSize > 0) {
            return false;
        }
        try {
            this.initByteOut();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.implementsByteWriter;
    }

    private void initByteOut() throws IOException {
        this.initOut();
        if (this.byteOut == null) {
            try {
                this.byteOut = (ByteWriter)((Object)this.out);
                this.implementsByteWriter = true;
            }
            catch (ClassCastException ex) {
                this.implementsByteWriter = false;
            }
        }
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        this.byteOut.write(buf, off, len);
    }

    @Override
    public void write(int c) throws IOException {
        this.ensureOpen();
        if (this.bufferSize == 0) {
            this.initOut();
            this.out.write(c);
        } else {
            if (this.getRemaining() == 0) {
                if (this.autoFlush) {
                    this.flushBuffer();
                } else {
                    this.bufferOverflow();
                }
            }
            this.buf.buf[this.buf.pos++] = (char)c;
        }
    }

    private int min(int a, int b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.ensureOpen();
        if (this.bufferSize == 0) {
            this.initOut();
            this.out.write(cbuf, off, len);
            return;
        }
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (len >= this.bufferSize) {
            if (this.autoFlush) {
                this.flushBuffer();
            } else {
                this.bufferOverflow();
            }
            this.initOut();
            this.out.write(cbuf, off, len);
            return;
        }
        int b = off;
        int t = off + len;
        while (b < t) {
            int d = this.min(this.getRemaining(), t - b);
            System.arraycopy(cbuf, b, this.buf.buf, this.buf.pos, d);
            b += d;
            this.buf.pos += d;
            if (this.getRemaining() != 0) continue;
            if (this.autoFlush) {
                this.flushBuffer();
                continue;
            }
            this.bufferOverflow();
        }
    }

    @Override
    public void write(char[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    @Override
    public void write(String s, int off, int len) throws IOException {
        this.ensureOpen();
        if (this.bufferSize == 0) {
            this.initOut();
            this.out.write(s, off, len);
            return;
        }
        int b = off;
        int t = off + len;
        while (b < t) {
            int d = this.min(this.getRemaining(), t - b);
            s.getChars(b, b + d, this.buf.buf, this.buf.pos);
            b += d;
            this.buf.pos += d;
            if (this.getRemaining() != 0) continue;
            if (this.autoFlush) {
                this.flushBuffer();
                continue;
            }
            this.bufferOverflow();
        }
    }

    @Override
    public void write(String s) throws IOException {
        this.write(s, 0, s != null ? s.length() : 0);
    }

    @Override
    public void newLine() throws IOException {
        this.write(lineSeparator);
    }

    @Override
    public void print(boolean b) throws IOException {
        this.write(b ? "true" : "false");
    }

    @Override
    public void print(char c) throws IOException {
        this.write(String.valueOf(c));
    }

    @Override
    public void print(int i) throws IOException {
        this.write(String.valueOf(i));
    }

    @Override
    public void print(long l) throws IOException {
        this.write(String.valueOf(l));
    }

    @Override
    public void print(float f) throws IOException {
        this.write(String.valueOf(f));
    }

    @Override
    public void print(double d) throws IOException {
        this.write(String.valueOf(d));
    }

    @Override
    public void print(char[] s) throws IOException {
        this.write(s);
    }

    @Override
    public void print(String s) throws IOException {
        if (s == null) {
            s = "null";
        }
        this.write(s);
    }

    @Override
    public void print(Object obj) throws IOException {
        this.write(String.valueOf(obj));
    }

    @Override
    public void println() throws IOException {
        this.newLine();
    }

    @Override
    public void println(boolean x) throws IOException {
        this.print(x);
        this.println();
    }

    @Override
    public void println(char x) throws IOException {
        this.print(x);
        this.println();
    }

    @Override
    public void println(int x) throws IOException {
        this.print(x);
        this.println();
    }

    @Override
    public void println(long x) throws IOException {
        this.print(x);
        this.println();
    }

    @Override
    public void println(float x) throws IOException {
        this.print(x);
        this.println();
    }

    @Override
    public void println(double x) throws IOException {
        this.print(x);
        this.println();
    }

    @Override
    public void println(char[] x) throws IOException {
        this.print(x);
        this.println();
    }

    @Override
    public void println(String x) throws IOException {
        this.print(x);
        this.println();
    }

    @Override
    public void println(Object x) throws IOException {
        this.print(x);
        this.println();
    }

    public boolean hasData() {
        return this.bufferSize != 0 && this.buf.pos != this.buf.offset;
    }

    private void allocateCharBuffer() {
        if (this.bufferSize == 0) {
            return;
        }
        this.buf = this.bufferSize > MAX_BUFFER_SIZE ? new CharBuffer(new char[this.bufferSize], 0, this.bufferSize) : this.getCharBufferThreadLocalPool().allocate(this.bufferSize);
    }

    private void releaseCharBuffer() {
        if (this.buf == null) {
            return;
        }
        if (this.buf.lim - this.buf.offset <= MAX_BUFFER_SIZE) {
            this.getCharBufferThreadLocalPool().release(this.buf);
        }
        this.buf = null;
    }

    private CharBufferThreadLocalPool getCharBufferThreadLocalPool() {
        CharBufferThreadLocalPool pool = charBufferPools.get();
        if (pool == null) {
            pool = new CharBufferThreadLocalPool();
            charBufferPools.set(pool);
        }
        return pool;
    }

    private static class CharBuffer {
        char[] buf;
        int offset;
        int pos;
        int lim;

        CharBuffer(char[] buffer, int offset, int length) {
            this.buf = buffer;
            this.offset = offset;
            this.pos = offset;
            this.lim = offset + length;
        }
    }

    private static class CharBufferThreadLocalPool {
        private char[] pool;
        private int pos;

        private CharBufferThreadLocalPool() {
        }

        public CharBuffer allocate(int size) {
            if (this.remaining() < size) {
                this.pool = new char[MAX_BUFFER_SIZE];
                this.pos = 0;
            }
            CharBuffer allocated = new CharBuffer(this.pool, this.pos, size);
            this.pos += size;
            return allocated;
        }

        public void release(CharBuffer buffer) {
            if (buffer.buf == this.pool && buffer.lim == this.pos) {
                this.pos = buffer.offset;
            }
        }

        public int remaining() {
            return this.pool == null ? 0 : this.pool.length - this.pos;
        }
    }
}

