/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core.coder;

import jakarta.websocket.DecodeException;
import jakarta.websocket.Decoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.tyrus.core.ReflectionHelper;
import org.glassfish.tyrus.core.coder.CoderAdapter;

public abstract class PrimitiveDecoders<T>
extends CoderAdapter
implements Decoder.Text<T> {
    public static final List<Class<? extends Decoder>> ALL = Collections.unmodifiableList(Arrays.asList(BooleanDecoder.class, ByteDecoder.class, CharacterDecoder.class, DoubleDecoder.class, FloatDecoder.class, IntegerDecoder.class, LongDecoder.class, ShortDecoder.class));
    public static final Map<Class<?>, Decoder.Text<?>> ALL_INSTANCES = PrimitiveDecoders.getAllInstances();

    @Override
    public boolean willDecode(String s) {
        return true;
    }

    private static Map<Class<?>, Decoder.Text<?>> getAllInstances() {
        HashMap map = new HashMap();
        for (Class<? extends Decoder> dec : ALL) {
            Class<?> type2 = ReflectionHelper.getClassType(dec, Decoder.Text.class);
            try {
                map.put(type2, (Decoder.Text)dec.newInstance());
            }
            catch (Exception e) {
                Logger.getLogger(PrimitiveDecoders.class.getName()).log(Level.WARNING, String.format("Decoder %s could not have been instantiated.", dec));
            }
        }
        return map;
    }

    public static class ShortDecoder
    extends PrimitiveDecoders<Short> {
        @Override
        public Short decode(String s) throws DecodeException {
            Short result;
            try {
                result = Short.valueOf(s);
            }
            catch (Exception e) {
                throw new DecodeException(s, "Decoding failed", (Throwable)e);
            }
            return result;
        }
    }

    public static class LongDecoder
    extends PrimitiveDecoders<Long> {
        @Override
        public Long decode(String s) throws DecodeException {
            Long result;
            try {
                result = Long.valueOf(s);
            }
            catch (Exception e) {
                throw new DecodeException(s, "Decoding failed", (Throwable)e);
            }
            return result;
        }
    }

    public static class IntegerDecoder
    extends PrimitiveDecoders<Integer> {
        @Override
        public Integer decode(String s) throws DecodeException {
            Integer result;
            try {
                result = Integer.valueOf(s);
            }
            catch (Exception e) {
                throw new DecodeException(s, "Decoding failed", (Throwable)e);
            }
            return result;
        }
    }

    public static class FloatDecoder
    extends PrimitiveDecoders<Float> {
        @Override
        public Float decode(String s) throws DecodeException {
            Float result;
            try {
                result = Float.valueOf(s);
            }
            catch (Exception e) {
                throw new DecodeException(s, "Decoding failed", (Throwable)e);
            }
            return result;
        }
    }

    public static class DoubleDecoder
    extends PrimitiveDecoders<Double> {
        @Override
        public Double decode(String s) throws DecodeException {
            Double result;
            try {
                result = Double.valueOf(s);
            }
            catch (Exception e) {
                throw new DecodeException(s, "Decoding failed", (Throwable)e);
            }
            return result;
        }
    }

    public static class CharacterDecoder
    extends PrimitiveDecoders<Character> {
        @Override
        public Character decode(String s) throws DecodeException {
            Character result;
            try {
                result = Character.valueOf(s.charAt(0));
            }
            catch (Exception e) {
                throw new DecodeException(s, "Decoding failed", (Throwable)e);
            }
            return result;
        }
    }

    public static class ByteDecoder
    extends PrimitiveDecoders<Byte> {
        @Override
        public Byte decode(String s) throws DecodeException {
            Byte result;
            try {
                result = Byte.valueOf(s);
            }
            catch (Exception e) {
                throw new DecodeException(s, "Decoding failed", (Throwable)e);
            }
            return result;
        }
    }

    public static class BooleanDecoder
    extends PrimitiveDecoders<Boolean> {
        @Override
        public Boolean decode(String s) throws DecodeException {
            Boolean result;
            try {
                result = Boolean.valueOf(s);
            }
            catch (Exception e) {
                throw new DecodeException(s, "Decoding failed", (Throwable)e);
            }
            return result;
        }
    }
}

