/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.servlet;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Objects;
import java.util.Optional;
import org.glassfish.soteria.Utils;
import org.glassfish.soteria.servlet.HttpStorageController;

public class CookieController
implements HttpStorageController {
    private final HttpServletRequest request;
    private final HttpServletResponse response;

    public CookieController(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    @Override
    public HttpStorageController store(String name, String value, Integer maxAge) {
        Cookie cookie = new Cookie(name, value);
        if (maxAge != null) {
            cookie.setMaxAge(maxAge);
        }
        cookie.setHttpOnly(true);
        cookie.setSecure(true);
        String contextPath = this.request.getContextPath();
        cookie.setPath(Utils.isEmpty(contextPath) ? "/" : contextPath);
        this.response.addCookie(cookie);
        return this;
    }

    public Optional<Cookie> get(String name) {
        if (this.request.getCookies() != null) {
            for (Cookie cookie : this.request.getCookies()) {
                if (!name.equals(cookie.getName()) || !Objects.nonNull(cookie.getValue()) || cookie.getValue().trim().isEmpty()) continue;
                return Optional.of(cookie);
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> getAsString(String name) {
        return this.get(name).map(Cookie::getValue);
    }

    @Override
    public void remove(String name) {
        this.store(name, null, 0);
    }
}

