/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resources.deployer;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.repository.ResourceProperty;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.resourcebase.resources.api.ResourceConflictException;
import org.glassfish.resourcebase.resources.api.ResourceDeployer;
import org.glassfish.resourcebase.resources.api.ResourceDeployerInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.glassfish.resourcebase.resources.naming.ResourceNamingService;
import org.glassfish.resourcebase.resources.util.BindableResourcesHelper;
import org.glassfish.resourcebase.resources.util.ResourceUtil;
import org.glassfish.resources.api.ResourcePropertyImpl;
import org.glassfish.resources.beans.CustomResource;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.types.Property;

@Service
@ResourceDeployerInfo(value=org.glassfish.resources.config.CustomResource.class)
@Singleton
public class CustomResourceDeployer
implements ResourceDeployer<org.glassfish.resources.config.CustomResource> {
    @Inject
    private BindableResourcesHelper bindableResourcesHelper;
    @Inject
    private ResourceNamingService cns;
    private static final Logger LOG = LogDomains.getLogger(CustomResourceDeployer.class, "jakarta.enterprise.resource.resourceadapter");

    @Override
    public synchronized void deployResource(org.glassfish.resources.config.CustomResource resource, String applicationName, String moduleName) throws Exception {
        SimpleJndiName jndiName = SimpleJndiName.of(resource.getJndiName());
        ResourceInfo resourceInfo = new ResourceInfo(jndiName, applicationName, moduleName);
        this.deployResource(resource, resourceInfo);
    }

    @Override
    public synchronized void deployResource(org.glassfish.resources.config.CustomResource resource) throws Exception {
        ResourceInfo resourceInfo = ResourceUtil.getResourceInfo(resource);
        this.deployResource(resource, resourceInfo);
    }

    private void deployResource(org.glassfish.resources.config.CustomResource resource, ResourceInfo resourceInfo) {
        CustomResource j2eeResource = CustomResourceDeployer.toCustomJavaEEResource(resource, resourceInfo);
        this.installCustomResource(j2eeResource, resourceInfo);
    }

    @Override
    public void undeployResource(org.glassfish.resources.config.CustomResource resource, String applicationName, String moduleName) throws Exception {
        SimpleJndiName jndiName = SimpleJndiName.of(resource.getJndiName());
        ResourceInfo resourceInfo = new ResourceInfo(jndiName, applicationName, moduleName);
        this.deleteResource(resource, resourceInfo);
    }

    @Override
    public synchronized void undeployResource(org.glassfish.resources.config.CustomResource resource) throws Exception {
        org.glassfish.resources.config.CustomResource customResource = resource;
        ResourceInfo resourceInfo = ResourceUtil.getResourceInfo(customResource);
        this.deleteResource(customResource, resourceInfo);
    }

    private void deleteResource(org.glassfish.resources.config.CustomResource customResource, ResourceInfo resourceInfo) throws NamingException {
        this.cns.unpublishObject(resourceInfo, resourceInfo.getName());
    }

    @Override
    public boolean handles(Object resource) {
        return resource instanceof org.glassfish.resources.config.CustomResource;
    }

    @Override
    public synchronized void enableResource(org.glassfish.resources.config.CustomResource resource) throws Exception {
        this.deployResource(resource);
    }

    @Override
    public synchronized void disableResource(org.glassfish.resources.config.CustomResource resource) throws Exception {
        this.undeployResource(resource);
    }

    public void installCustomResource(CustomResource customRes, ResourceInfo resourceInfo) {
        try {
            LOG.log(Level.FINE, "installCustomResource by jndi-name : {0}", resourceInfo);
            Reference ref = new Reference(customRes.getResType(), customRes.getFactoryClass(), null);
            for (ResourceProperty prop : customRes.getProperties()) {
                ref.add(new StringRefAddr(prop.getName(), prop.getValue()));
            }
            this.cns.publishObject(resourceInfo, ref, true);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "customrsrc.create_ref_error", resourceInfo);
            LOG.log(Level.SEVERE, "customrsrc.create_ref_error_excp", ex);
        }
    }

    private static CustomResource toCustomJavaEEResource(org.glassfish.resources.config.CustomResource rbean, ResourceInfo resourceInfo) {
        CustomResource jr = new CustomResource(resourceInfo);
        jr.setEnabled(Boolean.valueOf(rbean.getEnabled()));
        jr.setResType(rbean.getResType());
        jr.setFactoryClass(rbean.getFactoryClass());
        List<Property> properties = rbean.getProperty();
        if (properties != null) {
            for (Property property : properties) {
                ResourcePropertyImpl rp = new ResourcePropertyImpl(property.getName(), property.getValue());
                jr.addProperty(rp);
            }
        }
        return jr;
    }

    @Override
    public void validatePreservedResource(Application oldApp, Application newApp, Resource resource, Resources allResources) throws ResourceConflictException {
    }
}

