/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.persistence.jpa;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.logging.LogDomains;
import jakarta.persistence.SharedCacheMode;
import jakarta.persistence.ValidationMode;
import jakarta.persistence.spi.ClassTransformer;
import jakarta.persistence.spi.PersistenceUnitInfo;
import jakarta.persistence.spi.PersistenceUnitTransactionType;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.common.ModuleDescriptor;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.glassfish.persistence.jpa.ProviderContainerContractInfo;

public class PersistenceUnitInfoImpl
implements PersistenceUnitInfo {
    private static Logger logger = LogDomains.getLogger(PersistenceUnitInfoImpl.class, "jakarta.org.glassfish.persistence");
    private static final String DEFAULT_PROVIDER_NAME = "org.eclipse.persistence.jpa.PersistenceProvider";
    private static String defaultProvider;
    private final PersistenceUnitDescriptor persistenceUnitDescriptor;
    private final ProviderContainerContractInfo providerContainerContractInfo;
    private File absolutePuRootFile;
    private DataSource jtaDataSource;
    private DataSource nonJtaDataSource;
    private final List<URL> jarFiles;

    public PersistenceUnitInfoImpl(PersistenceUnitDescriptor persistenceUnitDescriptor, ProviderContainerContractInfo providerContainerContractInfo) {
        this.persistenceUnitDescriptor = persistenceUnitDescriptor;
        this.providerContainerContractInfo = providerContainerContractInfo;
        this.jarFiles = this._getJarFiles();
        SimpleJndiName jtaDataSourceName = persistenceUnitDescriptor.getJtaDataSource();
        SimpleJndiName nonJtaDataSourceName = persistenceUnitDescriptor.getNonJtaDataSource();
        try {
            this.jtaDataSource = jtaDataSourceName == null ? null : providerContainerContractInfo.lookupDataSource(jtaDataSourceName);
            this.nonJtaDataSource = nonJtaDataSourceName == null ? null : providerContainerContractInfo.lookupNonTxDataSource(nonJtaDataSourceName);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        logger.log(Level.FINE, () -> "PersistenceUnitInfoImpl created for " + persistenceUnitDescriptor.getName());
    }

    @Override
    public String getPersistenceUnitName() {
        return this.persistenceUnitDescriptor.getName();
    }

    @Override
    public String getPersistenceProviderClassName() {
        return PersistenceUnitInfoImpl.getPersistenceProviderClassNameForPuDesc(this.persistenceUnitDescriptor);
    }

    @Override
    public PersistenceUnitTransactionType getTransactionType() {
        return PersistenceUnitTransactionType.valueOf(this.persistenceUnitDescriptor.getTransactionType());
    }

    @Override
    public DataSource getJtaDataSource() {
        return this.jtaDataSource;
    }

    @Override
    public DataSource getNonJtaDataSource() {
        return this.nonJtaDataSource;
    }

    @Override
    public URL getPersistenceUnitRootUrl() {
        try {
            return this.getAbsolutePuRootFile().toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<String> getMappingFileNames() {
        return this.persistenceUnitDescriptor.getMappingFiles();
    }

    @Override
    public List<URL> getJarFileUrls() {
        return this.jarFiles;
    }

    @Override
    public List<String> getManagedClassNames() {
        return this.persistenceUnitDescriptor.getClasses();
    }

    @Override
    public boolean excludeUnlistedClasses() {
        return this.persistenceUnitDescriptor.isExcludeUnlistedClasses();
    }

    @Override
    public SharedCacheMode getSharedCacheMode() {
        return this.persistenceUnitDescriptor.getSharedCacheMode();
    }

    @Override
    public ValidationMode getValidationMode() {
        return this.persistenceUnitDescriptor.getValidationMode();
    }

    @Override
    public Properties getProperties() {
        return this.persistenceUnitDescriptor.getProperties();
    }

    @Override
    public String getPersistenceXMLSchemaVersion() {
        return this.persistenceUnitDescriptor.getParent().getSpecVersion();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.providerContainerContractInfo.getClassLoader();
    }

    @Override
    public void addTransformer(ClassTransformer transformer) {
        this.providerContainerContractInfo.addTransformer(transformer);
    }

    @Override
    public ClassLoader getNewTempClassLoader() {
        return this.providerContainerContractInfo.getTempClassloader();
    }

    public String toString() {
        StringBuilder result = new StringBuilder("<persistence-unit>");
        result.append("\n\t<PURoot>").append(this.getPersistenceUnitRootUrl()).append("</PURoot>");
        result.append("\n\t<name>").append(this.getPersistenceUnitName()).append("</name>");
        result.append("\n\t<provider>").append(this.getPersistenceProviderClassName()).append("</provider>");
        result.append("\n\t<transaction-type>").append((Object)this.getTransactionType()).append("</transaction-type>");
        result.append("\n\t<jta-data-source>").append(this.getJtaDataSource()).append("</jta-data-source>");
        result.append("\n\t<non-jta-data-source>").append(this.getNonJtaDataSource()).append("</non-jta-data-source>");
        for (URL jar : this.getJarFileUrls()) {
            result.append("\n\t<jar-file>").append(jar).append("</jar-file>");
        }
        for (String mappingFile : this.getMappingFileNames()) {
            result.append("\n\t<mapping-file>").append(mappingFile).append("</mapping-file>");
        }
        for (String clsName : this.getManagedClassNames()) {
            result.append("\n\t<class-name>").append(clsName).append("</class-name>");
        }
        result.append("\n\t<exclude-unlisted-classes>").append(this.excludeUnlistedClasses()).append("</exclude-unlisted-classes>");
        result.append("\n\t<properties>").append(this.getProperties()).append("</properties>");
        result.append("\n\t<class-loader>").append(this.getClassLoader()).append("</class-loader>");
        result.append("\n</persistence-unit>\n");
        return result.toString();
    }

    private List<URL> _getJarFiles() {
        ArrayList<String> jarFileNames = new ArrayList<String>(this.persistenceUnitDescriptor.getJarFiles());
        ArrayList<URL> jarFiles = new ArrayList<URL>(jarFileNames.size() + 1);
        String absolutePuRoot = this.getAbsolutePuRootFile().getAbsolutePath();
        for (String jarFileName : jarFileNames) {
            String nativeJarFileName = jarFileName.replace('/', File.separatorChar);
            File parentFile = new File(absolutePuRoot).getParentFile();
            File jarFile = new File(parentFile, nativeJarFileName);
            if (!jarFile.exists()) {
                String pathComponent = "";
                String nameComponent = jarFileName;
                if (jarFileName.lastIndexOf("../") != -1) {
                    int separatorIndex = jarFileName.lastIndexOf("../") + 3;
                    pathComponent = jarFileName.substring(0, separatorIndex);
                    nameComponent = jarFileName.substring(separatorIndex);
                }
                logger.fine("For jar-file=" + jarFileName + ", pathComponent=" + pathComponent + ", nameComponent=" + nameComponent);
                File parentPath = new File(parentFile, pathComponent);
                jarFile = new File(parentPath, DeploymentUtils.getRelativeEmbeddedModulePath(parentPath.getAbsolutePath(), nameComponent));
            }
            if (jarFile.exists()) {
                try {
                    jarFiles.add(jarFile.toURI().toURL());
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!logger.isLoggable(Level.WARNING)) continue;
            logger.log(Level.WARNING, "puinfo.referenced_jar_not_found", new Object[]{absolutePuRoot, jarFileName, jarFile});
        }
        return jarFiles;
    }

    private File getAbsolutePuRootFile() {
        if (this.absolutePuRootFile == null) {
            this.absolutePuRootFile = new File(this.providerContainerContractInfo.getApplicationLocation(), this.getAbsolutePuRootWithinApplication().replace('/', File.separatorChar));
            if (!this.absolutePuRootFile.exists()) {
                throw new RuntimeException(this.absolutePuRootFile.getAbsolutePath() + " does not exist!");
            }
        }
        return this.absolutePuRootFile;
    }

    private String getAbsolutePuRootWithinApplication() {
        RootDeploymentDescriptor rootDD = this.persistenceUnitDescriptor.getParent().getParent();
        String persistenceUnitRoot = this.persistenceUnitDescriptor.getPuRoot();
        if (rootDD.isApplication()) {
            return persistenceUnitRoot;
        }
        ModuleDescriptor module = ((BundleDescriptor)BundleDescriptor.class.cast(rootDD)).getModuleDescriptor();
        if (module.isStandalone()) {
            return persistenceUnitRoot;
        }
        String moduleLocation = DeploymentUtils.getRelativeEmbeddedModulePath(this.providerContainerContractInfo.getApplicationLocation(), module.getArchiveUri());
        return moduleLocation + "/" + persistenceUnitRoot;
    }

    public static String getDefaultprovider() {
        if (defaultProvider == null) {
            defaultProvider = System.getProperty("com.sun.persistence.defaultProvider", DEFAULT_PROVIDER_NAME);
        }
        return defaultProvider;
    }

    public static String getPersistenceProviderClassNameForPuDesc(PersistenceUnitDescriptor persistenceUnitDescriptor) {
        String provider = persistenceUnitDescriptor.getProvider();
        if (provider == null || provider.isEmpty()) {
            provider = PersistenceUnitInfoImpl.getDefaultprovider();
        }
        return provider;
    }

    @Override
    public String getScopeAnnotationName() {
        return this.persistenceUnitDescriptor.getScope();
    }

    @Override
    public List<String> getQualifierAnnotationNames() {
        return this.persistenceUnitDescriptor.getQualifiers();
    }
}

