/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.web.jersey.server.mvc.jsp.integration;

import com.sun.enterprise.module.HK2Module;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.util.net.JarURIPattern;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.glassfish.api.web.TldProvider;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.jersey.server.mvc.jsp.Include;
import org.glassfish.web.loader.LogFacade;
import org.jvnet.hk2.annotations.Service;

@Service(name="jerseyMvcTld")
@Singleton
public class JerseyMvcTldProvider
implements TldProvider,
PostConstruct {
    private static final Logger logger = LogFacade.getLogger();
    private static final ResourceBundle rb = logger.getResourceBundle();
    @Inject
    private ModulesRegistry registry;
    private Map<URI, List<String>> tldMap = new HashMap<URI, List<String>>();

    @Override
    public String getName() {
        return "jerseyMvcTld";
    }

    @Override
    public Map<URI, List<String>> getTldMap() {
        return (Map)((HashMap)this.tldMap).clone();
    }

    @Override
    public Map<URI, List<String>> getTldListenerMap() {
        return null;
    }

    @Override
    public void postConstruct() {
        Class<Include> jerseyIncludeClass = Include.class;
        URI[] uris = null;
        HK2Module m = null;
        if (jerseyIncludeClass != null) {
            m = this.registry.find(jerseyIncludeClass);
        }
        if (m != null) {
            uris = m.getModuleDefinition().getLocations();
        } else {
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (classLoader instanceof URLClassLoader) {
                URL[] urls = ((URLClassLoader)classLoader).getURLs();
                if (urls != null && urls.length > 0) {
                    uris = new URI[urls.length];
                    for (int i = 0; i < urls.length; ++i) {
                        try {
                            uris[i] = urls[i].toURI();
                            continue;
                        }
                        catch (URISyntaxException e) {
                            String msg = rb.getString("AS-WEB-UTIL-00038");
                            msg = MessageFormat.format(msg, urls[i]);
                            logger.log(Level.WARNING, msg, e);
                        }
                    }
                }
            } else {
                logger.log(Level.WARNING, "AS-WEB-UTIL-00039", new Object[]{JerseyMvcTldProvider.class.getSimpleName(), classLoader, JerseyMvcTldProvider.class.getName()});
            }
        }
        if (uris != null && uris.length > 0) {
            Pattern pattern = Pattern.compile("META-INF/.*\\.tld");
            for (URI uri : uris) {
                List<String> entries = JarURIPattern.getJarEntries(uri, pattern);
                if (entries == null || entries.size() <= 0) continue;
                this.tldMap.put(uri, entries);
            }
        }
    }
}

