/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.loadbalancer.admin.cli;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterRef;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.glassfish.loadbalancer.admin.cli.CreateHTTPHealthCheckerCommand;
import org.glassfish.loadbalancer.admin.cli.EnableHTTPLBApplicationCommand;
import org.glassfish.loadbalancer.admin.cli.EnableHTTPLBServerCommand;
import org.glassfish.loadbalancer.admin.cli.LBCommandsBase;
import org.glassfish.loadbalancer.config.LbConfig;
import org.glassfish.loadbalancer.config.LbConfigs;
import org.glassfish.loadbalancer.config.LoadBalancer;
import org.glassfish.loadbalancer.config.LoadBalancers;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-http-lb-ref")
@PerLookup
@I18n(value="create.http.lb.ref")
@TargetType(value={CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=LbConfig.class, opType=RestEndpoint.OpType.POST, path="create-http-lb-ref", description="create-http-lb-ref", params={@RestParam(name="config", value="$parent")})})
public final class CreateHTTPLBRefCommand
extends LBCommandsBase
implements AdminCommand {
    @Param(optional=true)
    String config;
    @Param(optional=true)
    String lbname;
    @Param(optional=true)
    String lbpolicy;
    @Param(optional=true)
    String lbpolicymodule;
    @Param(optional=true, defaultValue="/")
    String healthcheckerurl;
    @Param(optional=true, defaultValue="30")
    String healthcheckerinterval;
    @Param(optional=true, defaultValue="10")
    String healthcheckertimeout;
    @Param(optional=true)
    String lbenableallapplications;
    @Param(optional=true)
    String lbenableallinstances;
    @Param(optional=true)
    String lbweight;
    @Param(primary=true)
    String target;
    @Inject
    Target tgt;
    @Inject
    Logger logger;
    @Inject
    CommandRunner runner;
    @Inject
    Applications applications;
    private ActionReport report;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateHTTPLBRefCommand.class);

    @Override
    public void execute(AdminCommandContext context) {
        List<ApplicationRef> appRefs;
        AdminCommand command;
        boolean isCluster;
        this.report = context.getActionReport();
        this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        boolean bl = isCluster = this.target != null ? this.tgt.isCluster(this.target) : false;
        if (this.config != null && this.lbname != null) {
            String msg = localStrings.getLocalString("EitherConfigOrLBName", "Either LB name or LB config name, not both");
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg);
            return;
        }
        if (this.config == null && this.lbname == null) {
            String msg = localStrings.getLocalString("SpecifyConfigOrLBName", "Please specify either LB name or LB config name.");
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg);
            return;
        }
        LbConfigs lbconfigs = this.domain.getExtensionByType(LbConfigs.class);
        if (lbconfigs == null) {
            String msg = localStrings.getLocalString("NoLbConfigsElement", "Empty lb-configs");
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg);
            return;
        }
        if (this.config != null) {
            if (lbconfigs.getLbConfig(this.config) == null) {
                String msg = localStrings.getLocalString("LbConfigDoesNotExist", "Specified LB config {0} does not exist", this.config);
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                this.report.setMessage(msg);
                return;
            }
        } else if (this.lbname != null) {
            LoadBalancers lbs = this.domain.getExtensionByType(LoadBalancers.class);
            if (lbs == null) {
                String msg = localStrings.getLocalString("NoLoadBalancersElement", "No Load balancers defined.");
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                this.report.setMessage(msg);
                return;
            }
            LoadBalancer lb = lbs.getLoadBalancer(this.lbname);
            if (lb == null) {
                String msg = localStrings.getLocalString("LoadBalancerNotDefined", "Load balancer [{0}] not found.", this.lbname);
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                this.report.setMessage(msg);
                return;
            }
            this.config = lb.getLbConfigName();
        }
        if (!(this.lbpolicy == null && this.lbpolicymodule == null || isCluster)) {
            String msg = localStrings.getLocalString("NotCluster", "{0} not a cluster", this.target);
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg);
            return;
        }
        Cluster c = null;
        Server s = null;
        if (isCluster) {
            c = this.domain.getClusterNamed(this.target);
            if (c == null) {
                String msg = localStrings.getLocalString("ClusterNotDefined", "Cluster {0} cannot be used as target", this.target);
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                this.report.setMessage(msg);
                return;
            }
        } else {
            s = this.domain.getServerNamed(this.target);
            if (s == null) {
                String msg = localStrings.getLocalString("ServerNotDefined", "Server {0} cannot be used as target", this.target);
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                this.report.setMessage(msg);
                return;
            }
        }
        this.createLBRef(lbconfigs, this.target, this.config);
        if (this.report.getActionExitCode() != ActionReport.ExitCode.SUCCESS) {
            return;
        }
        if (this.healthcheckerurl != null) {
            try {
                command = (CreateHTTPHealthCheckerCommand)this.runner.getCommand("create-http-health-checker", this.report, context.getLogger());
                ((CreateHTTPHealthCheckerCommand)command).url = this.healthcheckerurl;
                ((CreateHTTPHealthCheckerCommand)command).interval = this.healthcheckerinterval;
                ((CreateHTTPHealthCheckerCommand)command).timeout = this.healthcheckertimeout;
                ((CreateHTTPHealthCheckerCommand)command).config = this.config;
                ((CreateHTTPHealthCheckerCommand)command).target = this.target;
                ((CreateHTTPHealthCheckerCommand)command).execute(context);
                this.checkCommandStatus(context);
            }
            catch (CommandException e) {
                String msg = e.getLocalizedMessage();
                this.logger.warning(msg);
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                this.report.setMessage(msg);
                return;
            }
        }
        if (Boolean.parseBoolean(this.lbenableallinstances)) {
            try {
                command = (EnableHTTPLBServerCommand)this.runner.getCommand("enable-http-lb-server", this.report, context.getLogger());
                ((EnableHTTPLBServerCommand)command).target = this.target;
                ((EnableHTTPLBServerCommand)command).execute(context);
                this.checkCommandStatus(context);
            }
            catch (CommandException e) {
                String msg = e.getLocalizedMessage();
                this.logger.warning(msg);
            }
        }
        if (Boolean.parseBoolean(this.lbenableallapplications) && (appRefs = this.domain.getApplicationRefsInTarget(this.target)).size() > 0 && Boolean.parseBoolean(this.lbenableallapplications)) {
            for (ApplicationRef ref : appRefs) {
                if (!this.isUserApp(ref.getRef())) continue;
                this.enableApp(context, ref.getRef());
            }
        }
    }

    public void createLBRef(LbConfigs lbconfigs, String target, String configName) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("[LB-ADMIN] createLBRef called for target " + target);
        }
        if (this.tgt.isCluster(target)) {
            this.addClusterToLbConfig(lbconfigs, configName, target);
            this.logger.info(localStrings.getLocalString("http_lb_admin.AddClusterToConfig", "Added cluster {0} to load balancer {1}", target, configName));
        } else if (this.domain.isServer(target)) {
            this.addServerToLBConfig(lbconfigs, configName, target);
            this.logger.info(localStrings.getLocalString("http_lb_admin.AddServerToConfig", "Added server {0} to load balancer {1}", target, configName));
        } else {
            String msg = localStrings.getLocalString("InvalidTarget", "Invalid target", target);
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg);
            return;
        }
    }

    private void addServerToLBConfig(LbConfigs lbconfigs, String configName, final String serverName) {
        boolean isStandAlone;
        LbConfig lbConfig = lbconfigs.getLbConfig(configName);
        ServerRef sRef = lbConfig.getRefByRef(ServerRef.class, serverName);
        if (sRef != null) {
            String msg = localStrings.getLocalString("LBServerRefExists", "LB config already contains a server-ref for target {0}", this.target);
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg);
            return;
        }
        Server server = this.domain.getServerNamed(serverName);
        boolean bl = isStandAlone = server.getCluster() == null && server.isInstance();
        if (!isStandAlone) {
            String msg = localStrings.getLocalString("NotStandAloneInstance", "[{0}] is not a stand alone instance. Only stand alone instance can be added to a load balancer.", serverName);
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg);
            return;
        }
        try {
            ConfigSupport.apply(new SingleConfigCode<LbConfig>(){

                @Override
                public Object run(LbConfig param) throws PropertyVetoException, TransactionFailure {
                    ServerRef ref = param.createChild(ServerRef.class);
                    ref.setRef(serverName);
                    param.getClusterRefOrServerRef().add(ref);
                    return Boolean.TRUE;
                }
            }, lbConfig);
        }
        catch (TransactionFailure ex) {
            String msg = localStrings.getLocalString("FailedToAddServerRef", "Failed to add server-ref");
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg);
            this.report.setFailureCause(ex);
        }
    }

    private void addClusterToLbConfig(LbConfigs lbconfigs, String configName, final String clusterName) {
        LbConfig lbConfig = lbconfigs.getLbConfig(configName);
        ClusterRef cRef = lbConfig.getRefByRef(ClusterRef.class, clusterName);
        if (cRef != null) {
            String msg = localStrings.getLocalString("LBClusterRefExists", "LB config already contains a cluster-ref for target {0}", this.target);
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg);
            return;
        }
        try {
            ConfigSupport.apply(new SingleConfigCode<LbConfig>(){

                @Override
                public Object run(LbConfig param) throws PropertyVetoException, TransactionFailure {
                    ClusterRef ref = param.createChild(ClusterRef.class);
                    ref.setRef(clusterName);
                    if (CreateHTTPLBRefCommand.this.lbpolicy != null) {
                        ref.setLbPolicy(CreateHTTPLBRefCommand.this.lbpolicy);
                    }
                    if (CreateHTTPLBRefCommand.this.lbpolicymodule != null) {
                        ref.setLbPolicyModule(CreateHTTPLBRefCommand.this.lbpolicymodule);
                    }
                    param.getClusterRefOrServerRef().add(ref);
                    return Boolean.TRUE;
                }
            }, lbConfig);
        }
        catch (TransactionFailure ex) {
            String msg = localStrings.getLocalString("FailedToAddClusterRef", "Failed to add cluster-ref");
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg);
            this.report.setFailureCause(ex);
        }
    }

    private void enableApp(AdminCommandContext context, String appName) {
        try {
            EnableHTTPLBApplicationCommand command = (EnableHTTPLBApplicationCommand)this.runner.getCommand("enable-http-lb-application", this.report, context.getLogger());
            command.target = this.target;
            command.name = appName;
            command.execute(context);
            this.checkCommandStatus(context);
        }
        catch (CommandException e) {
            String msg = e.getLocalizedMessage();
            this.logger.warning(msg);
        }
    }

    private boolean isUserApp(String id) {
        return this.applications.getApplication(id).getObjectType().equals("user");
    }
}

