/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.mvc.jsp;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.message.internal.TracingLogger;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.mvc.Viewable;
import org.glassfish.jersey.server.mvc.jsp.RequestDispatcherWrapper;
import org.glassfish.jersey.server.mvc.jsp.internal.LocalizationMessages;
import org.glassfish.jersey.server.mvc.spi.AbstractTemplateProcessor;
import org.glassfish.jersey.server.mvc.spi.ResolvedViewable;

final class JspTemplateProcessor
extends AbstractTemplateProcessor<String> {
    @Inject
    private Provider<Ref<HttpServletRequest>> requestProviderRef;
    @Inject
    private Provider<Ref<HttpServletResponse>> responseProviderRef;
    @Inject
    private Provider<ContainerRequest> containerRequestProvider;

    @Inject
    public JspTemplateProcessor(Configuration config, ServletContext servletContext) {
        super(config, servletContext, "jsp", "jsp");
    }

    @Override
    protected String resolve(String templatePath, Reader reader) throws Exception {
        return templatePath;
    }

    @Override
    public void writeTo(String templateReference, Viewable viewable, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, final OutputStream out) throws IOException {
        RequestDispatcher dispatcher;
        if (!(viewable instanceof ResolvedViewable)) {
            throw new IllegalArgumentException(LocalizationMessages.ERROR_VIEWABLE_INCORRECT_INSTANCE());
        }
        ResolvedViewable resolvedViewable = (ResolvedViewable)viewable;
        TracingLogger tracingLogger = TracingLogger.getInstance(this.containerRequestProvider.get().getPropertiesDelegate());
        if (tracingLogger.isLogEnabled(MvcJspEvent.JSP_FORWARD)) {
            tracingLogger.log(MvcJspEvent.JSP_FORWARD, templateReference, resolvedViewable.getModel());
        }
        if ((dispatcher = this.getServletContext().getRequestDispatcher(templateReference)) == null) {
            throw new ContainerException(LocalizationMessages.NO_REQUEST_DISPATCHER_FOR_RESOLVED_PATH(templateReference));
        }
        RequestDispatcherWrapper wrapper = new RequestDispatcherWrapper(dispatcher, this.getBasePath(), resolvedViewable);
        final ServletOutputStream responseStream = new ServletOutputStream(){

            @Override
            public void write(int b) throws IOException {
                out.write(b);
            }

            @Override
            public boolean isReady() {
                return true;
            }

            @Override
            public void setWriteListener(WriteListener writeListener) {
            }
        };
        final PrintWriter responseWriter = new PrintWriter(new OutputStreamWriter((OutputStream)responseStream, this.getEncoding()));
        try {
            wrapper.forward((ServletRequest)this.requestProviderRef.get().get(), new HttpServletResponseWrapper((HttpServletResponse)this.responseProviderRef.get().get()){

                @Override
                public ServletOutputStream getOutputStream() throws IOException {
                    return responseStream;
                }

                @Override
                public PrintWriter getWriter() throws IOException {
                    return responseWriter;
                }

                @Override
                public void flushBuffer() throws IOException {
                    this.getOutputStream().flush();
                }
            });
        }
        catch (Exception e) {
            throw new ContainerException(e);
        }
        finally {
            responseWriter.flush();
        }
    }

    private static enum MvcJspEvent implements TracingLogger.Event
    {
        JSP_FORWARD(TracingLogger.Level.SUMMARY, "MVC", "Forwarding view to JSP page [%s], model %s");

        private final TracingLogger.Level level;
        private final String category;
        private final String messageFormat;

        private MvcJspEvent(TracingLogger.Level level, String category, String messageFormat) {
            this.level = level;
            this.category = category;
            this.messageFormat = messageFormat;
        }

        @Override
        public String category() {
            return this.category;
        }

        @Override
        public TracingLogger.Level level() {
            return this.level;
        }

        @Override
        public String messageFormat() {
            return this.messageFormat;
        }
    }
}

