/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jettison.internal.entity;

import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.Providers;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import org.glassfish.jersey.jaxb.internal.AbstractJaxbElementProvider;
import org.glassfish.jersey.jettison.JettisonJaxbContext;
import org.glassfish.jersey.jettison.JettisonMarshaller;
import org.glassfish.jersey.message.internal.ReaderWriter;

public class JettisonJaxbElementProvider
extends AbstractJaxbElementProvider {
    JettisonJaxbElementProvider(Providers ps, Configuration config) {
        super(ps, config);
    }

    JettisonJaxbElementProvider(Providers ps, MediaType mt, Configuration config) {
        super(ps, mt, config);
    }

    @Override
    public boolean isReadable(Class<?> type2, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return super.isReadable(type2, genericType, annotations, mediaType);
    }

    @Override
    public boolean isWriteable(Class<?> type2, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return super.isWriteable(type2, genericType, annotations, mediaType);
    }

    @Override
    protected final JAXBElement<?> readFrom(Class<?> type2, MediaType mediaType, Unmarshaller unmarshaller, InputStream entityStream) throws JAXBException {
        Charset c = ReaderWriter.getCharset(mediaType);
        return JettisonJaxbContext.getJSONUnmarshaller(unmarshaller).unmarshalJAXBElementFromJSON(new InputStreamReader(entityStream, c), type2);
    }

    @Override
    protected final void writeTo(JAXBElement<?> t, MediaType mediaType, Charset c, Marshaller m, OutputStream entityStream) throws JAXBException {
        JettisonMarshaller jsonMarshaller = JettisonJaxbContext.getJSONMarshaller(m);
        if (this.isFormattedOutput()) {
            jsonMarshaller.setProperty("org.glassfish.jersey.media.json.JsonMarshaller.formatted", true);
        }
        jsonMarshaller.marshallToJSON(t, new OutputStreamWriter(entityStream, c));
    }

    @Produces(value={"*/*"})
    @Consumes(value={"*/*"})
    public static final class General
    extends JettisonJaxbElementProvider {
        @Inject
        public General(@Context Providers ps, @Context Configuration config) {
            super(ps, config);
        }

        @Override
        protected boolean isSupported(MediaType m) {
            return m.getSubtype().endsWith("+json");
        }
    }

    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public static final class App
    extends JettisonJaxbElementProvider {
        @Inject
        public App(@Context Providers ps, @Context Configuration config) {
            super(ps, MediaType.APPLICATION_JSON_TYPE, config);
        }
    }
}

