/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jettison.internal;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.PropertyException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.xml.stream.XMLStreamWriter;
import org.glassfish.jersey.jettison.JettisonConfig;
import org.glassfish.jersey.jettison.JettisonConfigured;
import org.glassfish.jersey.jettison.JettisonMarshaller;
import org.glassfish.jersey.jettison.internal.Stax2JettisonFactory;

public class BaseJsonMarshaller
implements JettisonMarshaller,
JettisonConfigured {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    protected final Marshaller jaxbMarshaller;
    protected JettisonConfig jsonConfig;

    public BaseJsonMarshaller(JAXBContext jaxbContext, JettisonConfig jsonConfig) throws JAXBException {
        this(jaxbContext.createMarshaller(), jsonConfig);
    }

    public BaseJsonMarshaller(Marshaller jaxbMarshaller, JettisonConfig jsonConfig) {
        this.jsonConfig = jsonConfig;
        this.jaxbMarshaller = jaxbMarshaller;
    }

    @Override
    public JettisonConfig getJSONConfiguration() {
        return this.jsonConfig;
    }

    @Override
    public void marshallToJSON(Object o, OutputStream outputStream) throws JAXBException {
        if (outputStream == null) {
            throw new IllegalArgumentException("The output stream is null");
        }
        this.marshallToJSON(o, new OutputStreamWriter(outputStream, UTF8));
    }

    @Override
    public void marshallToJSON(Object o, Writer writer) throws JAXBException {
        if (o == null) {
            throw new IllegalArgumentException("The JAXB element is null");
        }
        if (writer == null) {
            throw new IllegalArgumentException("The writer is null");
        }
        this.jaxbMarshaller.marshal(o, this.getXMLStreamWriter(writer));
    }

    private XMLStreamWriter getXMLStreamWriter(Writer writer) throws JAXBException {
        try {
            return Stax2JettisonFactory.createWriter(writer, this.jsonConfig);
        }
        catch (IOException ex) {
            throw new JAXBException(ex);
        }
    }

    @Override
    public void setProperty(String key, Object value) throws PropertyException {
    }
}

