/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.extras.interception.internal;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.aopalliance.intercept.ConstructorInterceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DescriptorVisibility;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.IndexedFilter;
import org.glassfish.hk2.api.InterceptionService;
import org.glassfish.hk2.api.IterableProvider;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.Visibility;
import org.glassfish.hk2.extras.interception.Intercepted;
import org.glassfish.hk2.extras.interception.Interceptor;
import org.glassfish.hk2.extras.interception.InterceptorOrderingService;
import org.glassfish.hk2.extras.interception.internal.ReflectionUtilities;

@Singleton
@Visibility(value=DescriptorVisibility.LOCAL)
public class DefaultInterceptionService
implements InterceptionService {
    private static final IndexedFilter METHOD_FILTER = new IndexedFilter(){

        @Override
        public boolean matches(Descriptor d) {
            return d.getQualifiers().contains(Interceptor.class.getName());
        }

        @Override
        public String getAdvertisedContract() {
            return MethodInterceptor.class.getName();
        }

        @Override
        public String getName() {
            return null;
        }
    };
    private static final IndexedFilter CONSTRUCTOR_FILTER = new IndexedFilter(){

        @Override
        public boolean matches(Descriptor d) {
            return d.getQualifiers().contains(Interceptor.class.getName());
        }

        @Override
        public String getAdvertisedContract() {
            return ConstructorInterceptor.class.getName();
        }

        @Override
        public String getName() {
            return null;
        }
    };
    @Inject
    private ServiceLocator locator;
    @Inject
    private IterableProvider<InterceptorOrderingService> orderers;

    @Override
    public Filter getDescriptorFilter() {
        return new Filter(){

            @Override
            public boolean matches(Descriptor d) {
                return d.getQualifiers().contains(Intercepted.class.getName());
            }
        };
    }

    private List<ServiceHandle<MethodInterceptor>> orderMethods(Method method, List<ServiceHandle<MethodInterceptor>> current) {
        List<ServiceHandle<MethodInterceptor>> retVal = current;
        for (InterceptorOrderingService orderer : this.orderers) {
            List<ServiceHandle<MethodInterceptor>> returned;
            List<ServiceHandle<MethodInterceptor>> given = Collections.unmodifiableList(retVal);
            try {
                returned = orderer.modifyMethodInterceptors(method, given);
            }
            catch (Throwable th) {
                returned = null;
            }
            if (returned == null || returned == given) continue;
            retVal = new ArrayList<ServiceHandle<MethodInterceptor>>(returned);
        }
        return retVal;
    }

    private List<ServiceHandle<ConstructorInterceptor>> orderConstructors(Constructor<?> constructor, List<ServiceHandle<ConstructorInterceptor>> current) {
        List<ServiceHandle<ConstructorInterceptor>> retVal = current;
        for (InterceptorOrderingService orderer : this.orderers) {
            List<ServiceHandle<ConstructorInterceptor>> returned;
            List<ServiceHandle<ConstructorInterceptor>> given = Collections.unmodifiableList(retVal);
            try {
                returned = orderer.modifyConstructorInterceptors(constructor, given);
            }
            catch (Throwable th) {
                returned = null;
            }
            if (returned == null || returned == given) continue;
            retVal = new ArrayList<ServiceHandle<ConstructorInterceptor>>(returned);
        }
        return retVal;
    }

    @Override
    public List<MethodInterceptor> getMethodInterceptors(Method method) {
        HashSet<String> allBindings = ReflectionUtilities.getAllBindingsFromMethod(method);
        List<ServiceHandle<?>> allInterceptors = this.locator.getAllServiceHandles(METHOD_FILTER);
        List<ServiceHandle<MethodInterceptor>> handles = new ArrayList<ServiceHandle<MethodInterceptor>>(allInterceptors.size());
        for (ServiceHandle<?> handle : allInterceptors) {
            ServiceHandle<?> interceptor;
            ActiveDescriptor<?> ad = handle.getActiveDescriptor();
            if (!ad.isReified()) {
                ad = this.locator.reifyDescriptor(ad);
            }
            Class<?> interceptorClass = ad.getImplementationClass();
            HashSet<String> allInterceptorBindings = ReflectionUtilities.getAllBindingsFromClass(interceptorClass);
            boolean found = false;
            for (String interceptorBinding : allInterceptorBindings) {
                if (!allBindings.contains(interceptorBinding)) continue;
                found = true;
                break;
            }
            if (!found || (interceptor = handle) == null) continue;
            handles.add(interceptor);
        }
        if ((handles = this.orderMethods(method, handles)).isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MethodInterceptor> retVal = new ArrayList<MethodInterceptor>(handles.size());
        for (ServiceHandle<MethodInterceptor> handle : handles) {
            MethodInterceptor interceptor = handle.getService();
            if (interceptor == null) continue;
            retVal.add(interceptor);
        }
        return retVal;
    }

    @Override
    public List<ConstructorInterceptor> getConstructorInterceptors(Constructor<?> constructor) {
        HashSet<String> allBindings = ReflectionUtilities.getAllBindingsFromConstructor(constructor);
        List<ServiceHandle<?>> allInterceptors = this.locator.getAllServiceHandles(CONSTRUCTOR_FILTER);
        List<ServiceHandle<ConstructorInterceptor>> handles = new ArrayList<ServiceHandle<ConstructorInterceptor>>(allInterceptors.size());
        for (ServiceHandle<?> handle : allInterceptors) {
            ServiceHandle<?> interceptor;
            ActiveDescriptor<?> ad = handle.getActiveDescriptor();
            if (!ad.isReified()) {
                ad = this.locator.reifyDescriptor(ad);
            }
            Class<?> interceptorClass = ad.getImplementationClass();
            HashSet<String> allInterceptorBindings = ReflectionUtilities.getAllBindingsFromClass(interceptorClass);
            boolean found = false;
            for (String interceptorBinding : allInterceptorBindings) {
                if (!allBindings.contains(interceptorBinding)) continue;
                found = true;
                break;
            }
            if (!found || (interceptor = handle) == null) continue;
            handles.add(interceptor);
        }
        if ((handles = this.orderConstructors(constructor, handles)).isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ConstructorInterceptor> retVal = new ArrayList<ConstructorInterceptor>(handles.size());
        for (ServiceHandle<ConstructorInterceptor> handle : handles) {
            ConstructorInterceptor interceptor = handle.getService();
            if (interceptor == null) continue;
            retVal.add(interceptor);
        }
        return retVal;
    }
}

