/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.extras;

import java.lang.annotation.Annotation;
import org.glassfish.hk2.api.DuplicateServiceException;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.messaging.TopicDistributionService;
import org.glassfish.hk2.extras.events.internal.DefaultTopicDistributionService;
import org.glassfish.hk2.extras.hk2bridge.internal.Hk2BridgeImpl;
import org.glassfish.hk2.extras.interception.internal.DefaultInterceptionService;
import org.glassfish.hk2.extras.operation.internal.OperationManagerImpl;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.hk2.utilities.DescriptorImpl;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;

public class ExtrasUtilities {
    public static final String HK2BRIDGE_LOCATOR_ID = "org.jvnet.hk2.hk2bridge.locator.id";
    public static final String HK2BRIDGE_SERVICE_ID = "org.jvnet.hk2.hk2bridge.service.id";
    private static final String BRIDGE_NAME_PREFIX = "LocatorBridge(";
    private static final String COMMA = ",";
    private static final String BRIDGE_NAME_POSTFIX = ")";

    public static void enableDefaultInterceptorServiceImplementation(ServiceLocator locator) {
        block3: {
            if (locator.getBestDescriptor(BuilderHelper.createContractFilter(DefaultInterceptionService.class.getName())) == null) {
                try {
                    ServiceLocatorUtilities.addClasses(locator, true, DefaultInterceptionService.class);
                }
                catch (MultiException me) {
                    if (ExtrasUtilities.isDupException(me)) break block3;
                    throw me;
                }
            }
        }
    }

    public static void enableOperations(ServiceLocator locator) {
        block3: {
            if (locator.getBestDescriptor(BuilderHelper.createContractFilter(OperationManagerImpl.class.getName())) != null) {
                return;
            }
            try {
                ServiceLocatorUtilities.addClasses(locator, true, OperationManagerImpl.class);
            }
            catch (MultiException me) {
                if (ExtrasUtilities.isDupException(me)) break block3;
                throw me;
            }
        }
    }

    private static String getBridgeName(ServiceLocator into, ServiceLocator from) {
        return BRIDGE_NAME_PREFIX + from.getLocatorId() + COMMA + into.getLocatorId() + BRIDGE_NAME_POSTFIX;
    }

    private static void checkParentage(ServiceLocator a, ServiceLocator b) {
        ServiceLocator originalA = a;
        while (a != null) {
            if (a.getLocatorId() == b.getLocatorId()) {
                throw new IllegalStateException("Locator " + originalA + " is a child of or is the same as locator " + b);
            }
            a = a.getParent();
        }
    }

    public static void bridgeServiceLocator(ServiceLocator into, ServiceLocator from) {
        ExtrasUtilities.checkParentage(into, from);
        ExtrasUtilities.checkParentage(from, into);
        String bridgeName = ExtrasUtilities.getBridgeName(into, from);
        if (from.getService(Hk2BridgeImpl.class, bridgeName, new Annotation[0]) != null) {
            throw new IllegalStateException("There is already a bridge from locator " + from.getName() + " to " + into.getName());
        }
        DescriptorImpl di = BuilderHelper.createDescriptorFromClass(Hk2BridgeImpl.class);
        di.setName(bridgeName);
        ServiceLocatorUtilities.addOneDescriptor(from, di);
        Hk2BridgeImpl bridge = from.getService(Hk2BridgeImpl.class, bridgeName, new Annotation[0]);
        bridge.setRemote(into);
    }

    public static void unbridgeServiceLocator(ServiceLocator into, ServiceLocator from) {
        ExtrasUtilities.checkParentage(into, from);
        ExtrasUtilities.checkParentage(from, into);
        String bridgeName = ExtrasUtilities.getBridgeName(into, from);
        ServiceHandle<Hk2BridgeImpl> handle = from.getServiceHandle(Hk2BridgeImpl.class, bridgeName, new Annotation[0]);
        if (handle == null) {
            return;
        }
        handle.destroy();
        ServiceLocatorUtilities.removeFilter(from, BuilderHelper.createNameAndContractFilter(Hk2BridgeImpl.class.getName(), bridgeName));
    }

    public static void enableTopicDistribution(ServiceLocator locator) {
        block4: {
            if (locator == null) {
                throw new IllegalArgumentException();
            }
            if (locator.getService(TopicDistributionService.class, "HK2TopicDistributionService", new Annotation[0]) != null) {
                return;
            }
            try {
                ServiceLocatorUtilities.addClasses(locator, true, DefaultTopicDistributionService.class);
            }
            catch (MultiException me) {
                if (ExtrasUtilities.isDupException(me)) break block4;
                throw me;
            }
        }
    }

    private static boolean isDupException(MultiException me) {
        boolean atLeastOne = false;
        for (Throwable error : me.getErrors()) {
            atLeastOne = true;
            if (error instanceof DuplicateServiceException) continue;
            return false;
        }
        return atLeastOne;
    }
}

