/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.impl.client;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Collection;
import org.glassfish.flashlight.provider.FlashlightProbe;
import org.glassfish.flashlight.provider.ProbeRegistry;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public class BtraceClientGenerator {
    private BtraceClientGenerator() {
    }

    public static byte[] generateBtraceClientClassData(int clientID, Collection<FlashlightProbe> probes) {
        String generatedClassName = "com/sun/btrace/flashlight/BTrace_Flashlight_" + clientID;
        int cwFlags = 3;
        ClassWriter cw = new ClassWriter(cwFlags);
        int access = 17;
        cw.visit(61, access, generatedClassName, null, "java/lang/Object", null);
        cw.visitAnnotation("Lcom/sun/btrace/annotations/BTrace;", true);
        int methodCounter = 0;
        for (FlashlightProbe probe : probes) {
            StringBuilder typeDesc = new StringBuilder("void ");
            StringBuilder methodDesc = new StringBuilder("void __");
            methodDesc.append(probe.getProviderJavaMethodName()).append("__");
            methodDesc.append(clientID).append("_").append(methodCounter).append("_");
            methodDesc.append("(");
            typeDesc.append("(");
            String delim = "";
            String typeDelim = "";
            Class[] paramTypes = probe.getParamTypes();
            for (int index = 0; index < paramTypes.length; ++index) {
                Class paramType = paramTypes[index];
                methodDesc.append(delim).append(paramType.getName());
                if (!probe.hasSelf() || index != 0) {
                    typeDesc.append(typeDelim).append(paramType.getName());
                    typeDelim = ",";
                }
                delim = ", ";
            }
            methodDesc.append(")");
            typeDesc.append(")");
            Method m = Method.getMethod(methodDesc.toString());
            GeneratorAdapter gen = new GeneratorAdapter(9, m, null, null, cw);
            if (probe.hasSelf()) {
                String[] paramNames = probe.getProbeParamNames();
                for (int index = 0; index < paramNames.length; ++index) {
                    if (!paramNames[index].equalsIgnoreCase("@SELF")) continue;
                    AnnotationVisitor paramVisitor = gen.visitParameterAnnotation(index, "Lcom/sun/btrace/annotations/Self;", true);
                    paramVisitor.visitEnd();
                }
            }
            AnnotationVisitor av = gen.visitAnnotation("Lcom/sun/btrace/annotations/OnMethod;", true);
            av.visit("clazz", probe.getProviderClazz().getName());
            av.visit("method", probe.getProviderJavaMethodName());
            av.visit("type", typeDesc.toString());
            av.visitEnd();
            gen.push(probe.getId());
            gen.loadArgArray();
            gen.invokeStatic(Type.getType(ProbeRegistry.class), Method.getMethod("void invokeProbe(int, Object[])"));
            gen.returnValue();
            gen.endMethod();
            ++methodCounter;
        }
        BtraceClientGenerator.generateConstructor(cw);
        cw.visitEnd();
        byte[] classData = cw.toByteArray();
        BtraceClientGenerator.writeClass(classData, generatedClassName);
        return classData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeClass(byte[] classData, String generatedClassName) {
        System.out.println("**** Generated BTRACE Client " + generatedClassName);
        FileOutputStream fos = null;
        try {
            int index = generatedClassName.lastIndexOf(47);
            String rootPath = System.getProperty("com.sun.aas.installRoot") + File.separator + "lib" + File.separator;
            String fileName = rootPath + generatedClassName.substring(index + 1) + ".class";
            File file = new File(fileName);
            fos = new FileOutputStream(file);
            fos.write(classData);
            fos.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void generateConstructor(ClassWriter cw) {
        Method m = Method.getMethod("void <init> ()");
        GeneratorAdapter gen = new GeneratorAdapter(1, m, null, null, cw);
        gen.loadThis();
        gen.invokeConstructor(Type.getType(Object.class), m);
        gen.returnValue();
        gen.endMethod();
    }
}

