/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.exousia.modules.def;

import jakarta.security.jacc.Policy;
import jakarta.security.jacc.PolicyConfiguration;
import jakarta.security.jacc.PolicyConfigurationFactory;
import jakarta.security.jacc.PolicyContext;
import jakarta.security.jacc.PrincipalMapper;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;

public class DefaultPolicy
implements Policy {
    private PolicyConfigurationFactory policyConfigurationFactory;
    private PrincipalMapper principalMapper;

    @Override
    public boolean isExcluded(Permission permissionToBeChecked) {
        return this.isExcluded(this.getPolicyConfigurationFactory().getPolicyConfiguration().getExcludedPermissions(), permissionToBeChecked);
    }

    @Override
    public boolean isUnchecked(Permission permissionToBeChecked) {
        return this.isUnchecked(this.getPolicyConfigurationFactory().getPolicyConfiguration().getUncheckedPermissions(), permissionToBeChecked);
    }

    @Override
    public boolean impliesByRole(Permission permissionToBeChecked, Subject subject) {
        if (subject == null) {
            return false;
        }
        PolicyConfiguration policyConfiguration = this.getPolicyConfigurationFactory().getPolicyConfiguration();
        PrincipalMapper roleMapper = (PrincipalMapper)PolicyContext.get("jakarta.security.jacc.PrincipalMapper");
        if (!roleMapper.isAnyAuthenticatedUserRoleMapped() && !subject.getPrincipals().isEmpty() && this.hasAccessViaRole(policyConfiguration.getPerRolePermissions(), "**", permissionToBeChecked)) {
            return true;
        }
        return this.hasAccessViaRoles(policyConfiguration.getPerRolePermissions(), roleMapper.getMappedRoles(subject), permissionToBeChecked);
    }

    @Override
    public PermissionCollection getPermissionCollection(Subject subject) {
        Permissions permissions = new Permissions();
        PolicyConfiguration policyConfiguration = this.getPolicyConfigurationFactory().getPolicyConfiguration();
        PrincipalMapper roleMapper = (PrincipalMapper)PolicyContext.get("jakarta.security.jacc.PrincipalMapper");
        PermissionCollection excludedPermissions = policyConfiguration.getExcludedPermissions();
        this.collectPermissions(policyConfiguration.getUncheckedPermissions(), permissions, excludedPermissions);
        Map<String, PermissionCollection> perRolePermissions = policyConfiguration.getPerRolePermissions();
        for (String role : roleMapper.getMappedRoles(subject)) {
            if (!perRolePermissions.containsKey(role)) continue;
            this.collectPermissions(perRolePermissions.get(role), permissions, excludedPermissions);
        }
        return permissions;
    }

    private PolicyConfigurationFactory getPolicyConfigurationFactory() {
        if (this.policyConfigurationFactory == null) {
            this.policyConfigurationFactory = PolicyConfigurationFactory.get();
        }
        return this.policyConfigurationFactory;
    }

    private boolean isExcluded(PermissionCollection excludedPermissions, Permission permission) {
        if (excludedPermissions.implies(permission)) {
            return true;
        }
        for (Permission excludedPermission : Collections.list(excludedPermissions.elements())) {
            if (!permission.implies(excludedPermission)) continue;
            return true;
        }
        return false;
    }

    private boolean isUnchecked(PermissionCollection uncheckedPermissions, Permission permission) {
        return uncheckedPermissions.implies(permission);
    }

    private boolean hasAccessViaRoles(Map<String, PermissionCollection> perRolePermissions, Set<String> roles, Permission permission) {
        for (String role : roles) {
            if (!this.hasAccessViaRole(perRolePermissions, role, permission)) continue;
            return true;
        }
        return false;
    }

    private boolean hasAccessViaRole(Map<String, PermissionCollection> perRolePermissions, String role, Permission permission) {
        return perRolePermissions.containsKey(role) && perRolePermissions.get(role).implies(permission);
    }

    private void collectPermissions(PermissionCollection sourcePermissions, PermissionCollection targetPermissions, PermissionCollection excludedPermissions) {
        boolean hasExcludedPermissions = excludedPermissions.elements().hasMoreElements();
        for (Permission permission : Collections.list(sourcePermissions.elements())) {
            if (hasExcludedPermissions && this.isExcluded(excludedPermissions, permission)) continue;
            targetPermissions.add(permission);
        }
    }
}

