/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.epicyro.config.servlet.sam;

import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.MessagePolicy;
import jakarta.security.auth.message.callback.CallerPrincipalCallback;
import jakarta.security.auth.message.callback.PasswordValidationCallback;
import jakarta.security.auth.message.module.ServerAuthModule;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.Principal;
import java.util.Base64;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;

public class BasicServerAuthModule
implements ServerAuthModule {
    private CallbackHandler handler;
    private String realm;

    @Override
    public Class<?>[] getSupportedMessageTypes() {
        return new Class[]{HttpServletRequest.class, HttpServletResponse.class};
    }

    public void initialize(MessagePolicy requestPolicy, MessagePolicy responsePolicy, CallbackHandler handler, Map options) throws AuthException {
        this.handler = handler;
        this.realm = (String)options.get("realmName");
    }

    @Override
    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        try {
            HttpServletRequest request = (HttpServletRequest)messageInfo.getRequestMessage();
            HttpServletResponse response = (HttpServletResponse)messageInfo.getResponseMessage();
            String[] credentials = this.getCredentials(request);
            if (credentials != null) {
                PasswordValidationCallback passwordValidation = new PasswordValidationCallback(clientSubject, credentials[0], credentials[1].toCharArray());
                this.handler.handle(new Callback[]{passwordValidation});
                if (passwordValidation.getResult()) {
                    return AuthStatus.SUCCESS;
                }
            }
            if (BasicServerAuthModule.isProtectedResource(messageInfo)) {
                response.setHeader("WWW-Authenticate", String.format("Basic realm=\"%s\"", this.realm));
                response.sendError(401);
                return AuthStatus.SEND_FAILURE;
            }
            this.handler.handle(new Callback[]{new CallerPrincipalCallback(clientSubject, (Principal)null)});
            return AuthStatus.SUCCESS;
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw (AuthException)new AuthException().initCause(e);
        }
    }

    @Override
    public AuthStatus secureResponse(MessageInfo messageInfo, Subject serviceSubject) throws AuthException {
        return AuthStatus.SEND_SUCCESS;
    }

    @Override
    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
    }

    private String[] getCredentials(HttpServletRequest request) {
        String authorizationHeader = request.getHeader("Authorization");
        if (authorizationHeader != null && authorizationHeader.startsWith("Basic ")) {
            return new String(Base64.getDecoder().decode(authorizationHeader.substring(6))).split(":");
        }
        return null;
    }

    public static boolean isProtectedResource(MessageInfo messageInfo) {
        return Boolean.valueOf((String)messageInfo.getMap().get("jakarta.security.auth.message.MessagePolicy.isMandatory"));
    }
}

