/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.epicyro.config.module.context;

import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.MessagePolicy;
import jakarta.security.auth.message.config.ServerAuthContext;
import jakarta.security.auth.message.module.ServerAuthModule;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.glassfish.epicyro.config.delegate.MessagePolicyDelegate;
import org.glassfish.epicyro.config.helper.ModulesManager;

public class ServerAuthContextImpl
implements ServerAuthContext {
    private static final System.Logger LOG = System.getLogger(ServerAuthContextImpl.class.getName());
    private static final AuthStatus[] validateRequestSuccessValues = new AuthStatus[]{AuthStatus.SUCCESS, AuthStatus.SEND_SUCCESS};
    private static final AuthStatus[] secureResponseSuccessValues = new AuthStatus[]{AuthStatus.SEND_SUCCESS};
    private final ModulesManager modulesManager;
    private final MessagePolicyDelegate policyDelegate;
    private final String appContext;
    private final CallbackHandler callbackHandler;
    private final String authContextID;
    private final Map<String, ?> properties;
    private final ServerAuthModule[] serverAuthModules;

    public ServerAuthContextImpl(ModulesManager modulesManager, MessagePolicyDelegate policyDelegate, String appContext, CallbackHandler callbackHandler, String authContextID, Map<String, ?> properties) {
        this.modulesManager = modulesManager;
        this.policyDelegate = policyDelegate;
        this.appContext = appContext;
        this.callbackHandler = callbackHandler;
        this.authContextID = authContextID;
        this.properties = properties;
        this.serverAuthModules = this.getServerAuthModules();
    }

    @Override
    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        AuthStatus[] status = new AuthStatus[this.serverAuthModules.length];
        for (int moduleNumber = 0; moduleNumber < this.serverAuthModules.length; ++moduleNumber) {
            if (this.serverAuthModules[moduleNumber] == null) continue;
            LOG.log(System.Logger.Level.DEBUG, "ServerAuthContext: {0} of AppContext: {1} - calling vaidateRequest on module.", this.authContextID, this.appContext);
            status[moduleNumber] = this.serverAuthModules[moduleNumber].validateRequest(messageInfo, clientSubject, serviceSubject);
            if (!this.modulesManager.shouldStopProcessingModules(validateRequestSuccessValues, moduleNumber, status[moduleNumber])) continue;
            return this.modulesManager.getReturnStatus(validateRequestSuccessValues, AuthStatus.SEND_FAILURE, status, moduleNumber);
        }
        return this.modulesManager.getReturnStatus(validateRequestSuccessValues, AuthStatus.SEND_FAILURE, status, status.length - 1);
    }

    @Override
    public AuthStatus secureResponse(MessageInfo messageInfo, Subject serviceSubject) throws AuthException {
        AuthStatus[] status = new AuthStatus[this.serverAuthModules.length];
        for (int i = 0; i < this.serverAuthModules.length; ++i) {
            if (this.serverAuthModules[i] == null) continue;
            LOG.log(System.Logger.Level.DEBUG, "ServerAuthContext: {0} of AppContext: {1} - calling secureResponse on module.", this.authContextID, this.appContext);
            status[i] = this.serverAuthModules[i].secureResponse(messageInfo, serviceSubject);
            if (!this.modulesManager.shouldStopProcessingModules(secureResponseSuccessValues, i, status[i])) continue;
            return this.modulesManager.getReturnStatus(secureResponseSuccessValues, AuthStatus.SEND_FAILURE, status, i);
        }
        return this.modulesManager.getReturnStatus(secureResponseSuccessValues, AuthStatus.SEND_FAILURE, status, status.length - 1);
    }

    @Override
    public void cleanSubject(MessageInfo arg0, Subject arg1) throws AuthException {
        for (ServerAuthModule serverAuthModule : this.serverAuthModules) {
            if (serverAuthModule == null) continue;
            LOG.log(System.Logger.Level.DEBUG, "ServerAuthContext: {0} of AppContext: {1} - calling cleanSubject on module.", this.authContextID, this.appContext);
            serverAuthModule.cleanSubject(arg0, arg1);
        }
    }

    private ServerAuthModule[] getServerAuthModules() {
        try {
            ServerAuthModule[] serverAuthModules;
            try {
                serverAuthModules = this.modulesManager.getModules(new ServerAuthModule[0], this.authContextID);
            }
            catch (AuthException ae) {
                LOG.log(System.Logger.Level.ERROR, () -> "ServerAuthContext: " + this.authContextID + " of AppContext: " + this.appContext + " - unable to load server auth modules", (Throwable)ae);
                throw ae;
            }
            MessagePolicy requestPolicy = this.policyDelegate.getRequestPolicy(this.authContextID, this.properties);
            MessagePolicy responsePolicy = this.policyDelegate.getResponsePolicy(this.authContextID, this.properties);
            boolean noModules = true;
            for (int i = 0; i < serverAuthModules.length; ++i) {
                if (serverAuthModules[i] == null) continue;
                LOG.log(System.Logger.Level.DEBUG, "ServerAuthContext: {0} of AppContext: {1} - initializing module.", this.authContextID, this.appContext);
                noModules = false;
                this.checkMessageTypes(serverAuthModules[i].getSupportedMessageTypes());
                serverAuthModules[i].initialize(requestPolicy, responsePolicy, this.callbackHandler, this.modulesManager.getInitProperties(i, this.properties));
            }
            if (noModules) {
                LOG.log(System.Logger.Level.WARNING, "ServerAuthContext: {0} of AppContext: {1} - contains no Auth Modules!", this.authContextID, this.appContext);
            }
            return serverAuthModules;
        }
        catch (AuthException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void checkMessageTypes(Class<?>[] supportedMessageTypes) throws AuthException {
        Class<?>[] requiredMessageTypes;
        for (Class<?> requiredType : requiredMessageTypes = this.policyDelegate.getMessageTypes()) {
            boolean supported = false;
            for (Class<?> supportedType : supportedMessageTypes) {
                if (!requiredType.isAssignableFrom(supportedType)) continue;
                supported = true;
            }
            if (supported) continue;
            throw new AuthException("module does not support message type: " + requiredType.getName());
        }
    }
}

