/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.epicyro.config.module.configprovider;

import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.config.AuthConfigFactory;
import jakarta.security.auth.message.config.AuthConfigProvider;
import jakarta.security.auth.message.config.ClientAuthConfig;
import jakarta.security.auth.message.config.ServerAuthConfig;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.glassfish.epicyro.config.factory.ConfigParser;
import org.glassfish.epicyro.config.helper.ModuleConfigurationManager;
import org.glassfish.epicyro.config.helper.ObjectUtils;
import org.glassfish.epicyro.config.module.config.GFClientAuthConfig;
import org.glassfish.epicyro.config.module.config.GFServerAuthConfig;

public class GFServerConfigProvider
implements AuthConfigProvider {
    protected Map<String, Object> properties;
    protected ModuleConfigurationManager moduleConfigurationManager;
    protected AuthConfigFactory authConfigFactory;

    public GFServerConfigProvider(ConfigParser configParser, AuthConfigFactory authConfigFactory) {
        this(new HashMap<String, Object>(), configParser, authConfigFactory);
    }

    public GFServerConfigProvider(Map<String, Object> properties, AuthConfigFactory authConfigFactory) {
        this(properties, GFServerConfigProvider.newConfigParser(), authConfigFactory);
    }

    public GFServerConfigProvider(Map<String, Object> properties, ConfigParser configParser, AuthConfigFactory authConfigFactory) {
        this.properties = properties;
        this.authConfigFactory = authConfigFactory;
        this.moduleConfigurationManager = new ModuleConfigurationManager(configParser, authConfigFactory, this);
    }

    public GFServerConfigProvider(ModuleConfigurationManager moduleConfigurationManager, AuthConfigFactory authConfigFactory) {
        this.moduleConfigurationManager = moduleConfigurationManager;
        this.authConfigFactory = authConfigFactory;
    }

    @Override
    public ClientAuthConfig getClientAuthConfig(String messageLayer, String appContextId, CallbackHandler handler) throws AuthException {
        return new GFClientAuthConfig(this.properties, this.moduleConfigurationManager, this, messageLayer, appContextId, handler);
    }

    @Override
    public ServerAuthConfig getServerAuthConfig(String messageLayer, String appContextId, CallbackHandler handler) throws AuthException {
        return new GFServerAuthConfig(this.properties, this.moduleConfigurationManager, this, messageLayer, appContextId, handler);
    }

    @Override
    public void refresh() {
        this.moduleConfigurationManager.loadParser(this, this.authConfigFactory, null);
    }

    private static ConfigParser newConfigParser() {
        String configParser = System.getProperty("config.parser");
        if (configParser == null) {
            return null;
        }
        return (ConfigParser)ObjectUtils.createObject(configParser);
    }
}

