/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.autodeploy;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.util.io.FileUtils;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.deployment.autodeploy.AutoDeployedFilesManager;
import org.glassfish.deployment.autodeploy.AutoDeployer;
import org.glassfish.deployment.autodeploy.AutoOperation;
import org.glassfish.deployment.autodeploy.AutodeployRetryManager;
import org.glassfish.deployment.common.DeploymentProperties;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public class AutoUndeploymentOperation
extends AutoOperation {
    @Inject
    Applications apps;
    private static final String COMMAND_NAME = "undeploy";
    @Inject
    private AutodeployRetryManager retryManager;
    @Inject
    @Named(value="undeploy")
    private AdminCommand undeployCommand;
    @LogMessageInfo(message="Attempt to create file {0} failed; no further information.", level="WARNING")
    private static final String CREATE_FAILED = "NCLS-DEPLOYMENT-02039";

    static AutoUndeploymentOperation newInstance(ServiceLocator habitat, File appFile, String name, String target) {
        AutoUndeploymentOperation o = habitat.getService(AutoUndeploymentOperation.class, new Annotation[0]);
        o.init(appFile, name, target);
        return o;
    }

    protected AutoUndeploymentOperation init(File appFile, String name, String target) {
        super.init(appFile, this.prepareUndeployActionProperties(name, target), COMMAND_NAME, this.undeployCommand);
        return this;
    }

    private Properties prepareUndeployActionProperties(String archiveName, String target) {
        DeploymentProperties dProps = new DeploymentProperties();
        String appName = archiveName;
        List<Application> applications = this.apps.getApplications();
        for (Application app : applications) {
            String defaultAppName = app.getDeployProperties().getProperty("defaultAppName");
            if (defaultAppName == null || !defaultAppName.equals(archiveName)) continue;
            appName = app.getName();
        }
        dProps.setName(appName);
        return dProps;
    }

    @Override
    protected String getMessageString(AutoDeployer.AutodeploymentStatus ds, File file) {
        return localStrings.getLocalString(ds.undeploymentMessageKey, ds.undeploymentDefaultMessage, file);
    }

    @Override
    protected void markFiles(AutoDeployer.AutodeploymentStatus ds, File file) {
        if (this.undeployedByRequestFile(file)) {
            this.cleanupAppAndRequest(file);
        }
        if (ds.status) {
            this.markUndeployed(file);
            this.retryManager.recordSuccessfulUndeployment(file);
        } else {
            this.markUndeployFailed(file);
            this.retryManager.recordFailedUndeployment(file);
        }
    }

    private void markUndeployed(File f) {
        try {
            this.deleteAllMarks(f);
            File undeployedFile = this.getUndeployedFile(f);
            if (!undeployedFile.createNewFile()) {
                deplLogger.log(Level.WARNING, CREATE_FAILED, undeployedFile.getAbsolutePath());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void markUndeployFailed(File f) {
        try {
            this.deleteAllMarks(f);
            File undeployFailedFile = this.getUndeployFailedFile(f);
            if (!undeployFailedFile.createNewFile()) {
                deplLogger.log(Level.WARNING, CREATE_FAILED, undeployFailedFile.getAbsolutePath());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean undeployedByRequestFile(File f) {
        return f instanceof AutoDeployedFilesManager.UndeployRequestedFile;
    }

    private void cleanupAppAndRequest(File f) {
        boolean logFine = deplLogger.isLoggable(Level.FINE);
        if (f.isDirectory()) {
            if (logFine) {
                deplLogger.fine("Deleting autodeployed directory " + f.getAbsolutePath() + " by request");
            }
            FileUtils.liquidate(f);
        } else {
            if (logFine) {
                deplLogger.fine("Deleting autodeployed file " + f.getAbsolutePath() + " by request");
            }
            FileUtils.deleteFile(f);
        }
        File requestFile = AutoDeployedFilesManager.appToUndeployRequestFile(f);
        if (logFine) {
            deplLogger.fine("Deleting autodeploy request file " + requestFile.getAbsolutePath());
        }
        FileUtils.deleteFile(requestFile);
    }
}

