/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.util.StringUtils;
import jakarta.inject.Inject;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.PropertyResolver;
import org.glassfish.deployment.admin.DeploymentCommandUtils;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="_get-application-launch-urls")
@ExecuteOn(value={RuntimeType.DAS})
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@RestEndpoints(value={@RestEndpoint(configBean=Applications.class, opType=RestEndpoint.OpType.GET, path="_get-application-launch-urls", description="Get Urls for launch the application")})
public class GetApplicationLaunchURLsCommand
implements AdminCommand,
AdminCommandSecurity.AccessCheckProvider {
    @Param(primary=true)
    private String appname = null;
    @Inject
    Domain domain;
    @Inject
    CommandRunner commandRunner;
    private List<Server> servers;

    @Override
    public Collection<? extends AccessRequired.AccessCheck> getAccessChecks() {
        ArrayList accessChecks = new ArrayList();
        List<String> targets = this.domain.getAllReferencedTargetsForApplication(this.appname);
        for (String target : targets) {
            Server server;
            if (!this.domain.isAppEnabledInTarget(this.appname, target)) continue;
            this.servers = new ArrayList<Server>();
            Cluster cluster = this.domain.getClusterNamed(target);
            if (cluster != null) {
                this.servers = cluster.getInstances();
            }
            if ((server = this.domain.getServerNamed(target)) != null) {
                this.servers.add(server);
            }
            for (Server svr : this.servers) {
                accessChecks.add(new AccessRequired.AccessCheck(DeploymentCommandUtils.getTargetResourceNameForExistingAppRef(this.domain, svr.getName(), this.appname), "read"));
            }
        }
        return accessChecks;
    }

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger2 = context.getLogger();
        this.getLBLaunchURLInformation(this.appname, report, context.getSubject());
        List<URL> launchURLs = this.getLaunchURLInformation(this.appname, logger2);
        if (launchURLs == null || launchURLs.isEmpty()) {
            return;
        }
        ActionReport.MessagePart part = report.getTopMessagePart();
        part = part.addChild();
        part.setMessage("Instances");
        int j = 0;
        for (URL url : launchURLs) {
            ActionReport.MessagePart childPart = part.addChild();
            childPart.setMessage(Integer.toString(j++));
            childPart.addProperty("protocol", url.getProtocol());
            childPart.addProperty("host", url.getHost());
            childPart.addProperty("port", String.valueOf(url.getPort()));
            childPart.addProperty("contextpath", url.getPath());
        }
    }

    private void getLBLaunchURLInformation(String appName, ActionReport report, Subject subject) {
        CommandRunner.CommandInvocation invocation = this.commandRunner.getCommandInvocation("_get-lb-launch-urls", report, subject);
        if (invocation != null) {
            ParameterMap map = new ParameterMap();
            map.add("appname", appName);
            invocation.parameters(map).execute();
        }
    }

    private List<URL> getLaunchURLInformation(String appName, Logger logger2) {
        ArrayList<URL> launchURLs = new ArrayList<URL>();
        String contextRoot = this.getContextRoot(appName);
        for (Server svr : this.servers) {
            launchURLs.addAll(this.getURLsForServer(svr, appName, contextRoot, logger2));
        }
        return launchURLs;
    }

    private String getContextRoot(String appName) {
        Application application = this.domain.getApplications().getApplication(appName);
        if (application == null) {
            return "";
        }
        String contextRoot = application.getContextRoot();
        if (contextRoot == null) {
            contextRoot = "";
        }
        return contextRoot;
    }

    private List<URL> getURLsForServer(Server server, String appName, String contextRoot, Logger logger2) {
        ArrayList<URL> serverURLs = new ArrayList<URL>();
        String virtualServers = server.getApplicationRef(appName).getVirtualServers();
        if (virtualServers == null || virtualServers.trim().equals("")) {
            return serverURLs;
        }
        String nodeName = server.getNodeRef();
        String host = null;
        if (nodeName != null) {
            Node node = this.domain.getNodeNamed(nodeName);
            host = node.getNodeHost();
        }
        if (host == null || host.trim().equals("") || host.trim().equalsIgnoreCase("localhost")) {
            host = DeploymentCommandUtils.getLocalHostName();
        }
        List<String> vsList = StringUtils.parseStringList(virtualServers, " ,");
        Config config = this.domain.getConfigNamed(server.getConfigRef());
        HttpService httpService = config.getHttpService();
        for (String vsName : vsList) {
            VirtualServer vs = httpService.getVirtualServerByName(vsName);
            String vsHttpListeners = vs.getNetworkListeners();
            if (vsHttpListeners == null || vsHttpListeners.trim().equals("")) continue;
            List<String> vsHttpListenerList = StringUtils.parseStringList(vsHttpListeners, " ,");
            List<NetworkListener> httpListenerList = config.getNetworkConfig().getNetworkListeners().getNetworkListener();
            for (String vsHttpListener : vsHttpListenerList) {
                for (NetworkListener httpListener : httpListenerList) {
                    Protocol protocol;
                    if (!httpListener.getName().equals(vsHttpListener) || !Boolean.valueOf(httpListener.getEnabled()).booleanValue() || Boolean.valueOf((protocol = httpListener.findHttpProtocol()).getHttp().getJkEnabled()).booleanValue()) continue;
                    boolean securityEnabled = Boolean.valueOf(protocol.getSecurityEnabled());
                    String proto = securityEnabled ? "https" : "http";
                    String portStr = httpListener.getPort();
                    String redirPort = protocol.getHttp().getRedirectPort();
                    if (redirPort != null && !redirPort.trim().equals("")) {
                        portStr = redirPort;
                    }
                    if (!DeploymentUtils.isDASTarget(server.getName())) {
                        PropertyResolver resolver = new PropertyResolver(this.domain, server.getName());
                        portStr = resolver.getPropertyValue(portStr);
                    }
                    try {
                        int port = Integer.parseInt(portStr);
                        URL url = new URL(proto, host, port, contextRoot);
                        serverURLs.add(url);
                    }
                    catch (Exception ee) {
                        logger2.log(Level.WARNING, ee.getMessage(), ee);
                    }
                }
            }
        }
        return serverURLs;
    }
}

