/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.admin.util.ClusterOperationUtil;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.event.Events;
import org.glassfish.common.util.admin.ParameterMapExtractor;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.deployment.admin.DeployCommandSupplementalInfo;
import org.glassfish.deployment.admin.DeploymentCommandUtils;
import org.glassfish.deployment.admin.InterceptorNotifier;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.versioning.VersioningException;
import org.glassfish.deployment.versioning.VersioningService;
import org.glassfish.deployment.versioning.VersioningUtils;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.DeploymentTargetResolver;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="disable")
@I18n(value="disable.command")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@PerLookup
@TargetType(value={CommandTarget.DOMAIN, CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE})
@RestEndpoints(value={@RestEndpoint(configBean=Application.class, opType=RestEndpoint.OpType.POST, path="disable", description="Disable", params={@RestParam(name="id", value="$parent")})})
public class DisableCommand
extends UndeployCommandParameters
implements AdminCommand,
DeploymentTargetResolver,
AdminCommandSecurity.Preauthorization,
AdminCommandSecurity.AccessCheckProvider {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DisableCommand.class);
    static final String DISABLE_ACTION = "disable";
    @Param(optional=true, defaultValue="false")
    public Boolean isundeploy = false;
    @Inject
    ServerEnvironment env;
    @Inject
    Deployment deployment;
    @Inject
    Domain domain;
    @Inject
    Events events;
    @Inject
    Applications applications;
    @Inject
    @Named(value="default-instance-name")
    protected Server server;
    @Inject
    VersioningService versioningService;
    @Inject
    ServiceLocator habitat;
    private ActionReport report;
    private Logger logger;
    private String appName;
    private Map<String, Set<String>> enabledVersionsInTargets;
    private boolean isVersionExpressionWithWildcard;
    private Set<String> enabledVersionsToDisable = Collections.EMPTY_SET;
    private List<String> matchedVersions;
    private final List<AccessRequired.AccessCheck> accessChecks = new ArrayList<AccessRequired.AccessCheck>();

    public DisableCommand() {
        this.origin = OpsParams.Origin.unload;
        this.command = OpsParams.Command.disable;
    }

    @Override
    public boolean preAuthorization(AdminCommandContext context) {
        this.report = context.getActionReport();
        this.logger = context.getLogger();
        this.appName = this.name();
        if (this.isundeploy.booleanValue()) {
            this.origin = OpsParams.Origin.undeploy;
        }
        if (this.origin == OpsParams.Origin.unload && this.command == OpsParams.Command.disable && this.target == null) {
            this.target = this.deployment.getDefaultTarget(this._classicstyle);
        }
        this.isVersionExpressionWithWildcard = VersioningUtils.isVersionExpressionWithWildCard(this.appName);
        if (this.env.isDas() && DeploymentUtils.isDomainTarget(this.target)) {
            this.enabledVersionsInTargets = Collections.EMPTY_MAP;
            if (this.isVersionExpressionWithWildcard) {
                this.enabledVersionsInTargets = this.versioningService.getEnabledVersionInReferencedTargetsForExpression(this.appName);
            } else {
                this.enabledVersionsInTargets = new HashMap<String, Set<String>>();
                this.enabledVersionsInTargets.put(this.appName, new HashSet<String>(this.domain.getAllReferencedTargetsForApplication(this.appName)));
            }
            this.enabledVersionsToDisable = this.enabledVersionsInTargets.keySet();
            return true;
        }
        if (this.isVersionExpressionWithWildcard) {
            try {
                this.matchedVersions = this.versioningService.getMatchedVersions(this.appName, this.target);
                if (this.matchedVersions == Collections.EMPTY_LIST) {
                    return true;
                }
                String enabledVersion = this.versioningService.getEnabledVersion(this.appName, this.target);
                if (this.matchedVersions.contains(enabledVersion)) {
                    this.appName = enabledVersion;
                    return true;
                }
                return true;
            }
            catch (VersioningException e) {
                this.report.failure(this.logger, e.getMessage());
                return false;
            }
        }
        return true;
    }

    @Override
    public Collection<? extends AccessRequired.AccessCheck> getAccessChecks() {
        String resourceForApp;
        if (this.env.isDas() && DeploymentUtils.isDomainTarget(this.target)) {
            for (Map.Entry entry : this.enabledVersionsInTargets.entrySet()) {
                for (String t : (Set)entry.getValue()) {
                    String resourceForApp2 = DeploymentCommandUtils.getTargetResourceNameForExistingApp(this.domain, t, (String)entry.getKey());
                    if (resourceForApp2 == null) continue;
                    this.accessChecks.add(new AccessRequired.AccessCheck(resourceForApp2, DISABLE_ACTION));
                }
            }
        } else if (this.isVersionExpressionWithWildcard) {
            for (String string : this.matchedVersions) {
                String resourceForApp3 = DeploymentCommandUtils.getTargetResourceNameForExistingAppRef(this.domain, this.target, string);
                this.accessChecks.add(new AccessRequired.AccessCheck(resourceForApp3, DISABLE_ACTION));
            }
        } else if (this.target == null) {
            resourceForApp = DeploymentCommandUtils.getTargetResourceNameForExistingAppRef(this.domain, this.deployment.getDefaultTarget(this.appName, this.origin, this._classicstyle), this.appName);
            if (resourceForApp != null) {
                this.accessChecks.add(new AccessRequired.AccessCheck(resourceForApp, DISABLE_ACTION));
            }
        } else {
            resourceForApp = DeploymentCommandUtils.getTargetResourceNameForExistingAppRef(this.domain, this.target, this.appName);
            if (resourceForApp != null) {
                this.accessChecks.add(new AccessRequired.AccessCheck(resourceForApp, DISABLE_ACTION));
            }
        }
        resourceForApp = DeploymentCommandUtils.getResourceNameForExistingApp(this.domain, this.appName);
        if (resourceForApp != null) {
            this.accessChecks.add(new AccessRequired.AccessCheck(resourceForApp, DISABLE_ACTION));
        }
        return this.accessChecks;
    }

    @Override
    public void execute(AdminCommandContext context) {
        block26: {
            if (this.origin == OpsParams.Origin.unload && this.command == OpsParams.Command.disable) {
                this.deployment.validateSpecifiedTarget(this.target);
            }
            InterceptorNotifier notifier = new InterceptorNotifier(this.habitat, null);
            DeployCommandSupplementalInfo suppInfo = new DeployCommandSupplementalInfo();
            suppInfo.setAccessChecks(this.accessChecks);
            this.report.setResultType(DeployCommandSupplementalInfo.class, suppInfo);
            if (this.env.isDas() && DeploymentUtils.isDomainTarget(this.target)) {
                for (Map.Entry<String, Set<String>> entry : this.enabledVersionsInTargets.entrySet()) {
                    this.appName = entry.getKey();
                    ArrayList<String> targets = new ArrayList<String>(entry.getValue());
                    try {
                        ParameterMapExtractor extractor = new ParameterMapExtractor(this);
                        ParameterMap paramMap = extractor.extract(Collections.EMPTY_LIST);
                        paramMap.set("DEFAULT", this.appName);
                        notifier.ensureBeforeReported(ExtendedDeploymentContext.Phase.REPLICATION);
                        ClusterOperationUtil.replicateCommand(DISABLE_ACTION, FailurePolicy.Error, FailurePolicy.Warn, FailurePolicy.Ignore, targets, context, paramMap, this.habitat);
                    }
                    catch (Exception e) {
                        this.report.failure(this.logger, e.getMessage());
                        return;
                    }
                }
            } else if (this.isVersionExpressionWithWildcard) {
                try {
                    if (this.matchedVersions == Collections.EMPTY_LIST) {
                        this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                        return;
                    }
                    String enabledVersion = this.versioningService.getEnabledVersion(this.appName, this.target);
                    if (!this.matchedVersions.contains(enabledVersion)) {
                        this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                        return;
                    }
                    this.appName = enabledVersion;
                }
                catch (VersioningException e) {
                    this.report.failure(this.logger, e.getMessage());
                    return;
                }
            }
            if (this.target == null) {
                this.target = this.deployment.getDefaultTarget(this.appName, this.origin, this._classicstyle);
            }
            if (this.env.isDas() || !this.isundeploy.booleanValue()) {
                ApplicationRef ref;
                if (!this.deployment.isRegistered(this.appName)) {
                    if (this.env.isDas()) {
                        this.report.setMessage(localStrings.getLocalString("application.notreg", "Application {0} not registered", this.appName));
                        this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    }
                    return;
                }
                if (!DeploymentUtils.isDomainTarget(this.target) && (ref = this.domain.getApplicationRefInTarget(this.appName, this.target)) == null) {
                    if (this.env.isDas()) {
                        this.report.setMessage(localStrings.getLocalString("ref.not.referenced.target", "Application {0} is not referenced by target {1}", this.appName, this.target));
                        this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    }
                    return;
                }
            }
            if (this.env.isDas()) {
                try {
                    notifier.ensureBeforeReported(ExtendedDeploymentContext.Phase.REPLICATION);
                    DeploymentCommandUtils.replicateEnableDisableToContainingCluster(DISABLE_ACTION, this.domain, this.target, this.appName, this.habitat, context, this);
                }
                catch (Exception e) {
                    this.report.failure(this.logger, e.getMessage());
                    return;
                }
            }
            ApplicationInfo appInfo = this.deployment.get(this.appName);
            try {
                Application app = this.applications.getApplication(this.appName);
                this.name = this.appName;
                DeploymentContext basicDC = this.deployment.disable(this, app, appInfo, this.report, this.logger);
                suppInfo.setDeploymentContext((ExtendedDeploymentContext)basicDC);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Error during disabling: ", e);
                if (!this.env.isDas() && this.isundeploy.booleanValue()) break block26;
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                this.report.setMessage(e.getMessage());
            }
        }
        if (this.enabledVersionsToDisable == Collections.EMPTY_SET) {
            this.enabledVersionsToDisable = new HashSet<String>();
            this.enabledVersionsToDisable.add(this.appName);
        }
        for (String this.appName : this.enabledVersionsToDisable) {
            if (this.isundeploy.booleanValue() || this.report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) continue;
            try {
                this.deployment.updateAppEnabledAttributeInDomainXML(this.appName, this.target, false);
            }
            catch (TransactionFailure e) {
                this.logger.warning("failed to set enable attribute for " + this.appName);
            }
        }
    }

    @Override
    public String getTarget(ParameterMap parameters) {
        return DeploymentCommandUtils.getTarget(parameters, this.origin, this.deployment);
    }
}

