/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli.internal;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.config.serverbeans.Resources;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="_get-connector-config-java-beans")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@RestEndpoints(value={@RestEndpoint(configBean=Resources.class, opType=RestEndpoint.OpType.GET, path="get-connector-config-java-beans", description="Get Connection Config Java Beans")})
public class GetConnectorConfigJavaBeans
implements AdminCommand {
    @Inject
    private ConnectorRuntime connectorRuntime;
    @Param
    private String rarName;
    @Param
    private String connectionDefnName;
    @Param(acceptableValues="ManagedConnectionFactory,AdminObject,ResourceAdapter,MessageListener")
    private String javaBeanType;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            Properties extraProperties = new Properties();
            Map<String, String> configProps = this.connectorRuntime.getConnectorConfigJavaBeans(this.rarName, this.connectionDefnName, this.javaBeanType);
            extraProperties.put("configProps", configProps);
            report.setExtraProperties(extraProperties);
        }
        catch (Exception e) {
            report.setMessage("_get-connector-config-java-beans failed : " + e.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
            return;
        }
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        report.setActionExitCode(ec);
    }
}

