/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.config.support.CrudResolver;
import org.glassfish.config.support.GenericCrudCommand;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="type")
public class TypeResolver
implements CrudResolver {
    @Inject
    private ServiceLocator habitat;
    @Inject
    Domain domain;
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(TypeResolver.class);

    @Override
    public <T extends ConfigBeanProxy> T resolve(AdminCommandContext context, final Class<T> type2) {
        ConfigBeanProxy proxy = (ConfigBeanProxy)this.habitat.getService(type2, new Annotation[0]);
        if (proxy == null) {
            try {
                proxy = (ConfigBeanProxy)type2.cast(ConfigSupport.apply(new SingleConfigCode<Domain>(){

                    @Override
                    public Object run(Domain writeableDomain) throws PropertyVetoException, TransactionFailure {
                        String elementName;
                        Object child = writeableDomain.createChild(type2);
                        Dom domDomain = Dom.unwrap(writeableDomain);
                        try {
                            elementName = GenericCrudCommand.elementName(domDomain.document, Domain.class, type2);
                        }
                        catch (ClassNotFoundException e) {
                            throw new TransactionFailure(e.toString());
                        }
                        if (elementName == null) {
                            String msg = localStrings.getLocalString(TypeResolver.class, "TypeResolver.no_element_of_that_type", "The Domain configuration does not have a sub-element of the type {0}", type2.getSimpleName());
                            throw new TransactionFailure(msg);
                        }
                        domDomain.setNodeElements(elementName, Dom.unwrap(child));
                        ServiceLocatorUtilities.addOneConstant(TypeResolver.this.habitat, child, null, type2);
                        return child;
                    }
                }, this.domain));
            }
            catch (TransactionFailure e) {
                throw new RuntimeException(e);
            }
            if (proxy == null) {
                String msg = localStrings.getLocalString(TypeResolver.class, "TypeResolver.target_object_not_found", "Cannot find a single component instance of type {0}", type2.getSimpleName());
                throw new RuntimeException(msg);
            }
        }
        return (T)proxy;
    }
}

