/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cluster.ssh.launcher;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.SshAuth;
import com.sun.enterprise.config.serverbeans.SshConnector;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import org.glassfish.cluster.ssh.launcher.GlassFishSshUserInfo;
import org.glassfish.cluster.ssh.launcher.JavaSystemJschLogger;
import org.glassfish.cluster.ssh.launcher.OperatingSystem;
import org.glassfish.cluster.ssh.launcher.RemoteSystemCapabilities;
import org.glassfish.cluster.ssh.launcher.SSHException;
import org.glassfish.cluster.ssh.launcher.SSHSession;
import org.glassfish.cluster.ssh.sftp.SFTPClient;
import org.glassfish.cluster.ssh.sftp.SFTPPath;
import org.glassfish.cluster.ssh.util.SSHUtil;
import org.glassfish.internal.api.RelativePathResolver;

public class SSHLauncher {
    static final String SSH_DIR_NAME = ".ssh";
    private static final int SSH_PORT_DEFAULT = 22;
    private static final System.Logger LOG = System.getLogger(SSHLauncher.class.getName());
    private final String host;
    private final int port;
    private final String userName;
    private final File keyFile;
    private final String keyPassPhraseParameter;
    private final String keyPassPhrase;
    private final String passwordParameter;
    private final String password;
    private final RemoteSystemCapabilities capabilities;

    public SSHLauncher(Node node) {
        SshConnector connector = node.getSshConnector();
        this.host = SSHLauncher.getHost(node);
        LOG.log(System.Logger.Level.DEBUG, "Connecting to host {0}", this.host);
        this.port = SSHLauncher.getPort(connector);
        SshAuth sshAuth = connector.getSshAuth();
        this.userName = SSHLauncher.getUserName(sshAuth == null ? null : sshAuth.getUserName());
        this.keyFile = sshAuth == null || sshAuth.getKeyfile() == null ? SSHUtil.getExistingKeyFile() : new File(sshAuth.getKeyfile());
        this.passwordParameter = sshAuth == null ? null : sshAuth.getPassword();
        this.password = this.passwordParameter == null || this.passwordParameter.isEmpty() ? null : SSHLauncher.expandPasswordAlias(this.passwordParameter);
        this.keyPassPhraseParameter = sshAuth == null ? null : sshAuth.getKeyPassphrase();
        this.keyPassPhrase = this.keyPassPhraseParameter == null || this.keyPassPhraseParameter.isEmpty() ? null : SSHLauncher.expandPasswordAlias(this.keyPassPhraseParameter);
        this.capabilities = SSHLauncher.analyzeRemote(this.host, this.port, this.userName, this.password, this.keyFile, this.keyPassPhrase);
        LOG.log(System.Logger.Level.DEBUG, "SSH client configuration: {0}", this);
    }

    public SSHLauncher(String userName, String host, int port, String password, File keyFile, String keyPassPhrase) {
        this.host = host;
        this.port = port == 0 ? 22 : port;
        this.keyFile = keyFile == null ? SSHUtil.getExistingKeyFile() : keyFile;
        this.userName = SSHLauncher.getUserName(userName);
        this.passwordParameter = password;
        this.password = password == null || password.isEmpty() ? null : SSHLauncher.expandPasswordAlias(password);
        this.keyPassPhraseParameter = keyPassPhrase;
        this.keyPassPhrase = keyPassPhrase == null || keyPassPhrase.isEmpty() ? null : SSHLauncher.expandPasswordAlias(keyPassPhrase);
        this.capabilities = SSHLauncher.analyzeRemote(this.host, this.port, this.userName, this.password, this.keyFile, this.keyPassPhrase);
        LOG.log(System.Logger.Level.DEBUG, "SSH client configuration: {0}", this);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUserName() {
        return this.userName;
    }

    File getKeyFile() {
        return this.keyFile;
    }

    String getKeyFilePassphrase() {
        return this.keyPassPhrase;
    }

    public RemoteSystemCapabilities getCapabilities() {
        return this.capabilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkConnection() {
        LOG.log(System.Logger.Level.DEBUG, "Checking connection...");
        JSch jsch = new JSch();
        Session sess = null;
        try {
            jsch.addIdentity(this.keyFile.getAbsolutePath(), this.keyPassPhrase);
            sess = jsch.getSession(this.userName, this.host, this.port);
            sess.setConfig("StrictHostKeyChecking", "accept-new");
            sess.connect();
            if (sess.isConnected()) {
                LOG.log(System.Logger.Level.INFO, () -> "Successfully connected to " + this.userName + "@" + this.host + " using keyfile " + String.valueOf(this.keyFile));
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (JSchException ex) {
            Throwable t = ex.getCause();
            if (t != null) {
                String msg = t.getMessage();
                LOG.log(System.Logger.Level.WARNING, "Failed to connect or authenticate: " + msg);
            }
            LOG.log(System.Logger.Level.DEBUG, "Failed to connect or autheticate: ", (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            if (sess != null) {
                sess.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkPasswordAuth() {
        LOG.log(System.Logger.Level.DEBUG, "Checking connection...");
        JSch jsch = new JSch();
        Session sess = null;
        try {
            sess = jsch.getSession(this.userName, this.host, this.port);
            sess.setConfig("StrictHostKeyChecking", "accept-new");
            sess.setPassword(this.password);
            sess.connect();
            if (sess.isConnected()) {
                LOG.log(System.Logger.Level.DEBUG, () -> "Successfully connected to " + this.userName + "@" + this.host + " using password authentication");
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (JSchException ex) {
            LOG.log(System.Logger.Level.ERROR, "Failed to connect or autheticate: ", (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            if (sess != null) {
                sess.disconnect();
            }
        }
    }

    public SSHSession openSession() throws SSHException {
        return SSHLauncher.openSession(this.getCapabilities(), this.host, this.port, this.userName, this.password, this.keyFile, this.keyPassPhrase);
    }

    private static SSHSession openSession(RemoteSystemCapabilities capabilities, String host, int port, String userName, String password, File keyFile, String keyPassPhrase) throws SSHException {
        JSch jsch = new JSch();
        Object message = "";
        boolean triedAuthentication = false;
        if (keyFile != null) {
            LOG.log(System.Logger.Level.DEBUG, () -> "Specified key file is " + String.valueOf(keyFile));
            if (keyFile.exists()) {
                triedAuthentication = true;
                LOG.log(System.Logger.Level.DEBUG, () -> "Adding identity for private key at " + String.valueOf(keyFile));
                SSHLauncher.addIdentity(jsch, keyFile, keyPassPhrase);
            } else {
                message = "Specified key file does not exist \n";
            }
        } else if (password == null || password.isEmpty()) {
            message = (String)message + "No key or password specified - trying default keys \n";
            LOG.log(System.Logger.Level.DEBUG, "keyfile and password are null. Will try to authenticate with default key file if available");
            Path home = FileUtils.USER_HOME.toPath();
            for (String keyName : SSHUtil.SSH_KEY_FILE_NAMES) {
                message = (String)message + "Tried to authenticate using " + keyName + "\n";
                File key = home.resolve(Path.of(SSH_DIR_NAME, keyName)).toFile();
                if (!key.exists()) continue;
                triedAuthentication = true;
                SSHLauncher.addIdentity(jsch, key, keyPassPhrase);
            }
        }
        Session session = SSHLauncher.openSession(jsch, host, port, userName);
        try {
            session.setConfig("StrictHostKeyChecking", "accept-new");
            session.setUserInfo(new GlassFishSshUserInfo());
            if (password != null && !password.isEmpty()) {
                LOG.log(System.Logger.Level.DEBUG, () -> "Authenticating with password " + JavaSystemJschLogger.maskForLogging(password));
                triedAuthentication = true;
                session.setPassword(password);
            }
            if (!triedAuthentication) {
                throw new SSHException("Could not authenticate: " + (String)message + ".");
            }
            session.connect();
            return new SSHSession(session, capabilities);
        }
        catch (SSHException e) {
            session.disconnect();
            throw e;
        }
        catch (JSchException e) {
            session.disconnect();
            throw new SSHException("Could not authenticate: " + (String)message + ".", e);
        }
    }

    public SSHSession openSession(String passwordParam) throws SSHException {
        JSch jsch = new JSch();
        Session session = SSHLauncher.openSession(jsch, this.host, this.port, this.userName);
        try {
            session.setConfig("StrictHostKeyChecking", "accept-new");
            session.setPassword(passwordParam);
            session.connect();
            return new SSHSession(session, this.getCapabilities());
        }
        catch (JSchException e) {
            throw new SSHException("Failed to connect.", e);
        }
    }

    public void pingConnection() throws SSHException {
        LOG.log(System.Logger.Level.DEBUG, () -> "Trying to establish connection to host: " + this.host);
        try (SSHSession session = this.openSession();){
            LOG.log(System.Logger.Level.INFO, () -> "Establishing SSH connection to host " + this.host + " succeeded!");
        }
    }

    public boolean exists(SFTPPath path) throws SSHException {
        try (SSHSession session = this.openSession();){
            SFTPClient sftpClient = session.createSFTPClient();
            try {
                boolean bl = sftpClient.exists(path);
                if (sftpClient != null) {
                    sftpClient.close();
                }
                return bl;
            }
            catch (Throwable throwable) {
                if (sftpClient != null) {
                    try {
                        sftpClient.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    public String toString() {
        String displayPassword = JavaSystemJschLogger.maskForLogging(this.passwordParameter);
        String displayKeyPassPhrase = JavaSystemJschLogger.maskForLogging(this.keyPassPhraseParameter);
        return String.format("host=%s port=%d user=%s password=%s keyFile=%s keyPassPhrase=%s, capabilities=%s", this.host, this.port, this.userName, displayPassword, this.keyFile, displayKeyPassPhrase, this.capabilities);
    }

    private static RemoteSystemCapabilities analyzeRemote(String host, int port, String userName, String password, File keyFile, String keyPassPhrase) {
        String[] sysPropOutputLines;
        RemoteSystemCapabilities capabilities = new RemoteSystemCapabilities(null, null, OperatingSystem.GENERIC, StandardCharsets.UTF_8);
        try (SSHSession session = SSHLauncher.openSession(capabilities, host, port, userName, password, keyFile, keyPassPhrase);){
            if (LOG.isLoggable(System.Logger.Level.DEBUG)) {
                Map<String, String> env = session.detectShellEnv();
                LOG.log(System.Logger.Level.DEBUG, "Environment of the operating system obtained for the SSH client: {0}", env);
            }
            sysPropOutputLines = SSHLauncher.loadRemoteJavaSystemProperties(session);
        }
        catch (SSHException e) {
            String msg = "Failed to analyze the remote system. Some commands probably are not supported.";
            LOG.log(System.Logger.Level.WARNING, msg, (Throwable)e);
            return new RemoteSystemCapabilities(null, null, OperatingSystem.GENERIC, StandardCharsets.UTF_8);
        }
        String javaHome = SSHLauncher.getValue("java.home", sysPropOutputLines);
        Runtime.Version javaVersion = SSHLauncher.getProperty("java.version", sysPropOutputLines, Runtime.Version::parse);
        OperatingSystem os = SSHLauncher.getProperty("os.name", sysPropOutputLines, OperatingSystem::parse);
        Charset charset = SSHLauncher.getProperty("file.encoding", sysPropOutputLines, Charset::forName);
        return new RemoteSystemCapabilities(javaHome, javaVersion, os, charset);
    }

    private static String[] loadRemoteJavaSystemProperties(SSHSession session) throws SSHException {
        StringBuilder outputBuilder = new StringBuilder();
        int code = session.exec(Arrays.asList("java", "-XshowSettings:properties", "-version"), null, outputBuilder);
        if (code != 0) {
            throw new SSHException("Java command on the remote host failed. Output: " + String.valueOf(outputBuilder) + ".");
        }
        return outputBuilder.toString().split("\\R");
    }

    public static String expandPasswordAlias(String alias) {
        String expandedPassword = null;
        if (alias == null) {
            return null;
        }
        try {
            expandedPassword = RelativePathResolver.getRealPasswordFromAlias(alias);
        }
        catch (Exception e) {
            LOG.log(System.Logger.Level.WARNING, "Expansion failed for {0}: {1}", alias, e.getMessage());
            return null;
        }
        return expandedPassword;
    }

    private static void addIdentity(JSch jsch, File identityFile, String keyPassPhrase) throws SSHException {
        try {
            jsch.addIdentity(identityFile.getAbsolutePath(), keyPassPhrase);
        }
        catch (JSchException e) {
            throw new SSHException("Invalid key passphrase for key: " + identityFile.getAbsolutePath() + ".", e);
        }
    }

    private static String getHost(Node node) {
        SshConnector sshConnector = node.getSshConnector();
        String sshHost = sshConnector.getSshHost();
        return sshHost == null || sshHost.isEmpty() ? node.getNodeHost() : sshConnector.getSshHost();
    }

    private static int getPort(SshConnector connector) {
        try {
            int sshPort = Integer.parseInt(connector.getSshPort());
            return sshPort > 0 ? sshPort : 22;
        }
        catch (NumberFormatException nfe) {
            return 22;
        }
    }

    private static String getUserName(String userName) {
        return userName == null || userName.isEmpty() ? System.getProperty("user.name") : userName;
    }

    private static <T> T getProperty(String key, String[] lines, Function<String, T> converter) {
        String value = SSHLauncher.getValue(key, lines);
        if (value == null) {
            return null;
        }
        return converter.apply(value);
    }

    private static String getValue(String keyName, String[] propertiesOutputLines) {
        for (String line : propertiesOutputLines) {
            String key;
            int equalSignPosition = line.indexOf(61);
            if (equalSignPosition <= 0 || !keyName.equals(key = line.substring(0, equalSignPosition).strip())) continue;
            return equalSignPosition == line.length() - 1 ? "" : line.substring(equalSignPosition + 1).strip();
        }
        return null;
    }

    private static Session openSession(JSch jsch, String host, int port, String userName) throws SSHException {
        try {
            return jsch.getSession(userName, host, port);
        }
        catch (JSchException e) {
            throw new SSHException("Could not authenticate user " + userName + " to " + host + ":" + port + ".", e);
        }
    }

    static {
        JSch.setLogger(new JavaSystemJschLogger());
    }
}

