/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cdi.transaction;

import jakarta.annotation.Priority;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import jakarta.transaction.TransactionRequiredException;
import jakarta.transaction.Transactional;
import jakarta.transaction.TransactionalException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.cdi.transaction.TransactionalInterceptorBase;

@Priority(value=200)
@Interceptor
@Transactional(value=Transactional.TxType.MANDATORY)
public class TransactionalInterceptorMandatory
extends TransactionalInterceptorBase {
    private static final long serialVersionUID = 884559632546224653L;
    private static final Logger _logger = Logger.getLogger("jakarta.enterprise.resource.jta", "org.glassfish.cdi.LogMessages");

    @AroundInvoke
    public Object transactional(InvocationContext ctx) throws Exception {
        _logger.log(Level.INFO, "AS-JTA-00004");
        if (this.isLifeCycleMethod(ctx)) {
            return this.proceed(ctx);
        }
        this.setTransactionalTransactionOperationsManger(false);
        try {
            if (this.getTransactionManager().getTransaction() == null) {
                throw new TransactionalException("TransactionRequiredException thrown from TxType.MANDATORY transactional interceptor.", new TransactionRequiredException("Managed bean with Transactional annotation and TxType of MANDATORY called outside of a transaction context"));
            }
            Object object = this.proceed(ctx);
            return object;
        }
        finally {
            this.resetTransactionOperationsManager();
        }
    }
}

