/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources;

import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.validation.ValidationException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.glassfish.admin.rest.resources.AbstractResource;
import org.glassfish.admin.rest.resources.TemplateRestResource;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.results.GetResultList;
import org.glassfish.admin.rest.results.OptionsResult;
import org.glassfish.admin.rest.utils.ResourceUtil;
import org.glassfish.admin.rest.utils.Util;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.api.ActionReport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

public class PropertiesBagResource
extends AbstractResource {
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(PropertiesBagResource.class);
    protected List<Dom> entity;
    protected Dom parent;
    protected String tagName;

    @Path(value="{Name}/")
    public PropertyResource getProperty(@PathParam(value="Name") String id) {
        PropertyResource resource = this.serviceLocator.createAndInitialize(PropertyResource.class);
        resource.setBeanByKey(this.getEntity(), id, this.tagName);
        return resource;
    }

    @GET
    @Produces(value={"text/html", "application/json;qs=0.5", "application/xml;qs=0.5"})
    public Object get() {
        List<Dom> entities = this.getEntity();
        if (entities == null) {
            return new GetResultList(new ArrayList<Dom>(), new String[0][], new OptionsResult(Util.getResourceName(this.uriInfo)));
        }
        RestActionReporter ar = new RestActionReporter();
        ar.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        ar.setActionDescription("property");
        ArrayList properties = new ArrayList();
        for (Dom child : entities) {
            HashMap<String, String> entry = new HashMap<String, String>();
            entry.put("name", child.attribute("name"));
            entry.put("value", child.attribute("value"));
            String description = child.attribute("description");
            if (description != null) {
                entry.put("description", description);
            }
            properties.add(entry);
        }
        Properties extraProperties = new Properties();
        extraProperties.put("properties", properties);
        ar.setExtraProperties(extraProperties);
        return new ActionReportResult("properties", ar, new OptionsResult(Util.getResourceName(this.uriInfo)));
    }

    @POST
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    @Produces(value={"text/html", "application/json;qs=0.5", "application/xml;qs=0.5"})
    public ActionReportResult createProperties(List<Map<String, String>> data) {
        return this.clearThenSaveProperties(data);
    }

    @PUT
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    @Produces(value={"text/html", "application/json;qs=0.5", "application/xml;qs=0.5"})
    public ActionReportResult replaceProperties(List<Map<String, String>> data) {
        return this.clearThenSaveProperties(data);
    }

    @DELETE
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded", "application/octet-stream"})
    @Produces(value={"text/html", "application/json;qs=0.5", "application/xml;qs=0.5"})
    public Response delete() {
        try {
            Map<String, Property> existing = this.getExistingProperties();
            this.deleteMissingProperties(existing, null);
            String successMessage = localStrings.getLocalString("rest.resource.delete.message", "\"{0}\" deleted successfully.", this.uriInfo.getAbsolutePath());
            return ResourceUtil.getResponse(200, successMessage, this.requestHeaders, this.uriInfo);
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof ValidationException) {
                return ResourceUtil.getResponse(400, ex.getMessage(), this.requestHeaders, this.uriInfo);
            }
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private String getEscapedPropertyName(String propName) {
        return propName.replaceAll("\\.", "\\\\.");
    }

    protected ActionReportResult clearThenSaveProperties(List<Map<String, String>> properties) {
        RestActionReporter ar = new RestActionReporter();
        ar.setActionDescription("property");
        try {
            Map<String, Property> existing = this.getExistingProperties();
            this.deleteMissingProperties(existing, properties);
            LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
            for (Map<String, String> property : properties) {
                boolean canSaveDesc;
                Property existingProp = existing.get(property.get("name"));
                String escapedName = this.getEscapedPropertyName(property.get("name"));
                String value = property.get("value");
                String description = property.get("description");
                String unescapedValue = value.replaceAll("\\\\", "");
                boolean bl = canSaveDesc = property.get("name").indexOf(".") == -1;
                if (existingProp == null || !unescapedValue.equals(existingProp.getValue())) {
                    data.put(escapedName, property.get("value"));
                    if (canSaveDesc && description != null) {
                        data.put(escapedName + ".description", description);
                    }
                }
                if (description == null || existingProp == null || "".equals(description) || description.equals(existingProp.getDescription()) || !canSaveDesc) continue;
                data.put(escapedName + ".description", description);
            }
            if (!data.isEmpty()) {
                Util.applyChanges(data, this.uriInfo, this.getSubject());
            }
            String successMessage = localStrings.getLocalString("rest.resource.update.message", "\"{0}\" updated successfully.", this.uriInfo.getAbsolutePath());
            ar.setSuccess();
            ar.setMessage(successMessage);
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof ValidationException) {
                ar.setFailure();
                ar.setFailureCause(ex);
                ar.setMessage(ex.getLocalizedMessage());
            }
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
        return new ActionReportResult("properties", ar, new OptionsResult(Util.getResourceName(this.uriInfo)));
    }

    protected Map<String, Property> getExistingProperties() {
        HashMap<String, Property> properties = new HashMap<String, Property>();
        if (this.parent != null) {
            for (Dom child : this.parent.nodeElements(this.tagName)) {
                Property property = (Property)child.createProxy();
                properties.put(property.getName(), property);
            }
        }
        return properties;
    }

    protected void deleteMissingProperties(Map<String, Property> existing, List<Map<String, String>> properties) throws TransactionFailure {
        HashSet<String> propNames = new HashSet<String>();
        if (properties != null) {
            for (Map<String, String> property : properties) {
                propNames.add(property.get("name"));
            }
        }
        HashMap<String, String> data = new HashMap<String, String>();
        for (Property existingProp : existing.values()) {
            if (propNames.contains(existingProp.getName())) continue;
            String escapedName = this.getEscapedPropertyName(existingProp.getName());
            data.put(escapedName, "");
        }
        if (!data.isEmpty()) {
            Util.applyChanges(data, this.uriInfo, this.getSubject());
        }
    }

    public void setEntity(List<Dom> p) {
        this.entity = p;
    }

    public List<Dom> getEntity() {
        return this.entity;
    }

    public void setParentAndTagName(Dom parent, String tagName) {
        this.parent = parent;
        this.tagName = tagName;
        if (parent != null) {
            this.entity = parent.nodeElements(tagName);
        }
    }

    public static class PropertyResource
    extends TemplateRestResource {
        @Override
        public String getDeleteCommand() {
            return "GENERIC-DELETE";
        }
    }
}

