/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools.model.query;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.Assert;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar;
import org.eclipse.persistence.jpa.jpql.parser.VirtualJPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.tools.TypeHelper;
import org.eclipse.persistence.jpa.jpql.tools.model.DefaultProblem;
import org.eclipse.persistence.jpa.jpql.tools.model.IJPQLQueryBuilder;
import org.eclipse.persistence.jpa.jpql.tools.model.IPropertyChangeListener;
import org.eclipse.persistence.jpa.jpql.tools.model.Problem;
import org.eclipse.persistence.jpa.jpql.tools.model.query.AnonymousStateObjectVisitor;
import org.eclipse.persistence.jpa.jpql.tools.model.query.ChangeSupport;
import org.eclipse.persistence.jpa.jpql.tools.model.query.CollectionExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.DeclarationStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.IdentificationVariableStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.JPQLQueryStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateObjectVisitor;
import org.eclipse.persistence.jpa.jpql.tools.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.tools.spi.IType;
import org.eclipse.persistence.jpa.jpql.tools.spi.ITypeRepository;
import org.eclipse.persistence.jpa.jpql.tools.utility.iterable.SnapshotCloneIterable;
import org.eclipse.persistence.jpa.jpql.utility.CollectionTools;

public abstract class AbstractStateObject
implements StateObject {
    private ChangeSupport changeSupport;
    private StateObject decorator;
    private Expression expression;
    private StateObject parent;

    protected AbstractStateObject(StateObject parent) {
        this.parent = this.checkParent(parent);
        this.initialize();
    }

    protected boolean acceptUnknownVisitor(StateObjectVisitor visitor) {
        try {
            try {
                this.acceptUnknownVisitor(visitor, visitor.getClass(), this.getClass());
            }
            catch (NoSuchMethodException e) {
                this.acceptUnknownVisitor(visitor, visitor.getClass(), StateObject.class);
            }
            return true;
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            RuntimeException actual = cause instanceof RuntimeException ? (RuntimeException)cause : new RuntimeException(cause);
            throw actual;
        }
    }

    protected void acceptUnknownVisitor(StateObjectVisitor visitor, Class<?> type2, Class<?> parameterType) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        try {
            Method visitMethod = type2.getDeclaredMethod("visit", parameterType);
            if (!visitMethod.canAccess(visitor)) {
                AccessController.doPrivileged(() -> {
                    visitMethod.setAccessible(true);
                    return null;
                });
            }
            visitMethod.invoke((Object)visitor, this);
        }
        catch (NoSuchMethodException e) {
            type2 = type2.getSuperclass();
            if (type2 == Object.class) {
                throw e;
            }
            this.acceptUnknownVisitor(visitor, type2, parameterType);
        }
    }

    protected void addChildren(List<StateObject> children) {
    }

    protected void addProblems(List<Problem> problems) {
    }

    @Override
    public final void addPropertyChangeListener(String propertyName, IPropertyChangeListener<?> listener) {
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    protected final boolean areEquivalent(StateObject stateObject1, StateObject stateObject2) {
        if (stateObject1 == stateObject2 || stateObject1 == null && stateObject2 == null) {
            return true;
        }
        if (stateObject1 == null || stateObject2 == null) {
            return false;
        }
        return stateObject1.isEquivalent(stateObject2);
    }

    protected final Problem buildProblem(String messageKey) {
        return this.buildProblem(messageKey, ExpressionTools.EMPTY_STRING_ARRAY);
    }

    protected final Problem buildProblem(String messageKey, String ... arguments) {
        return new DefaultProblem(this, messageKey, arguments);
    }

    protected <T extends StateObject> T buildStateObject(CharSequence jpqlFragment, String queryBNFId) {
        return (T)this.getQueryBuilder().buildStateObject(this, jpqlFragment, queryBNFId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends StateObject> List<T> buildStateObjects(CharSequence jpqlFragment, String queryBNFId) {
        VirtualJPQLQueryBNF queryBNF = new VirtualJPQLQueryBNF(this.getGrammar());
        queryBNF.setHandleCollection(true);
        queryBNF.setFallbackBNFId(queryBNFId);
        queryBNF.registerQueryBNF(queryBNFId);
        final ArrayList items = new ArrayList();
        try {
            T stateObject = this.buildStateObject(jpqlFragment, queryBNF.getId());
            AnonymousStateObjectVisitor visitor = new AnonymousStateObjectVisitor(){

                public void visit(CollectionExpressionStateObject stateObject) {
                    CollectionTools.addAll(items, stateObject.children());
                }

                @Override
                protected void visit(StateObject stateObject) {
                    items.add(stateObject);
                }
            };
            stateObject.accept(visitor);
        }
        finally {
            queryBNF.dispose();
        }
        return items;
    }

    protected StateObject checkParent(StateObject parent) {
        Assert.isNotNull(parent, "The parent cannot be null");
        return parent;
    }

    @Override
    public final Iterable<StateObject> children() {
        ArrayList<StateObject> children = new ArrayList<StateObject>();
        this.addChildren(children);
        return new SnapshotCloneIterable<StateObject>(children);
    }

    @Override
    public void decorate(StateObject decorator) {
        this.decorator = this.parent(decorator);
    }

    public final boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public IdentificationVariableStateObject findIdentificationVariable(String identificationVariable) {
        return this.parent.findIdentificationVariable(identificationVariable);
    }

    protected final void firePropertyChanged(String propertyName, Object oldValue, Object newValue) {
        this.changeSupport.firePropertyChanged(propertyName, oldValue, newValue);
    }

    protected final ChangeSupport getChangeSupport() {
        return this.changeSupport;
    }

    @Override
    public DeclarationStateObject getDeclaration() {
        return this.parent.getDeclaration();
    }

    @Override
    public StateObject getDecorator() {
        return this.decorator;
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public JPQLGrammar getGrammar() {
        return this.getRoot().getGrammar();
    }

    @Override
    public IManagedTypeProvider getManagedTypeProvider() {
        return this.getRoot().getManagedTypeProvider();
    }

    @Override
    public StateObject getParent() {
        return this.parent;
    }

    @Override
    public IJPQLQueryBuilder getQueryBuilder() {
        return this.getRoot().getQueryBuilder();
    }

    @Override
    public JPQLQueryStateObject getRoot() {
        return this.parent.getRoot();
    }

    public IType getType(Class<?> type2) {
        return this.getTypeRepository().getType(type2);
    }

    public IType getType(String typeName) {
        return this.getTypeRepository().getType(typeName);
    }

    public TypeHelper getTypeHelper() {
        return this.getTypeRepository().getTypeHelper();
    }

    public ITypeRepository getTypeRepository() {
        return this.getManagedTypeProvider().getTypeRepository();
    }

    public final int hashCode() {
        return super.hashCode();
    }

    protected void initialize() {
        this.changeSupport = new ChangeSupport(this);
    }

    @Override
    public boolean isDecorated() {
        return this.decorator != null;
    }

    @Override
    public boolean isEquivalent(StateObject stateObject) {
        return this == stateObject || stateObject != null && stateObject.getClass() == this.getClass();
    }

    protected <T extends StateObject> List<T> parent(List<T> stateObjects) {
        for (StateObject stateObject : stateObjects) {
            this.parent(stateObject);
        }
        return stateObjects;
    }

    @SafeVarargs
    protected final <T extends StateObject> T[] parent(T ... stateObjects) {
        for (T stateObject : stateObjects) {
            this.parent(stateObject);
        }
        return stateObjects;
    }

    protected <T extends StateObject> T parent(T stateObject) {
        if (stateObject != null) {
            stateObject.setParent(this);
        }
        return stateObject;
    }

    @Override
    public final void removePropertyChangeListener(String propertyName, IPropertyChangeListener<?> listener) {
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    @Override
    public final void setParent(StateObject parent) {
        Assert.isNotNull(parent, "The parent cannot be null");
        this.parent = parent;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    @Override
    public final void toString(Appendable writer) {
        try {
            this.toStringInternal(writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected final void toStringInternal(Appendable writer) throws IOException {
        if (this.isDecorated()) {
            this.getDecorator().toString(writer);
        } else {
            this.toTextInternal(writer);
        }
    }

    protected void toStringItems(Appendable writer, List<? extends StateObject> items, boolean useComma) throws IOException {
        int count = items.size();
        int index = -1;
        for (StateObject stateObject : items) {
            stateObject.toString(writer);
            if (++index + 1 >= count) continue;
            if (useComma) {
                writer.append(',');
            }
            writer.append(' ');
        }
    }

    @Override
    public final void toText(Appendable writer) {
        try {
            this.toTextInternal(writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected abstract void toTextInternal(Appendable var1) throws IOException;
}

