/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.eclipse.persistence.jpa.jpql.tools.spi.IType;
import org.eclipse.persistence.jpa.jpql.tools.spi.ITypeDeclaration;
import org.eclipse.persistence.jpa.jpql.tools.spi.ITypeRepository;

public final class TypeHelper {
    private IType objectType;
    private IType stringType;
    private final ITypeRepository typeRepository;
    private IType unknownType;

    public TypeHelper(ITypeRepository typeRepository) {
        this.typeRepository = typeRepository;
    }

    public IType bigDecimal() {
        return this.getType(BigDecimal.class);
    }

    public IType bigInteger() {
        return this.getType(BigInteger.class);
    }

    public IType booleanType() {
        return this.getType(Boolean.class);
    }

    public IType byteType() {
        return this.getType(Byte.class);
    }

    public IType characterType() {
        return this.getType(Character.class);
    }

    public IType collectionType() {
        return this.getType(Collection.class);
    }

    public IType convertPrimitive(IType type2) {
        IType newType = this.toByteType(type2);
        if (newType != type2) {
            return newType;
        }
        newType = this.toShortType(type2);
        if (newType != type2) {
            return newType;
        }
        newType = this.toIntegerType(type2);
        if (newType != type2) {
            return newType;
        }
        newType = this.longType(type2);
        if (newType != type2) {
            return newType;
        }
        newType = this.toFloatType(type2);
        if (newType != type2) {
            return newType;
        }
        newType = this.toDoubleType(type2);
        if (newType != type2) {
            return newType;
        }
        newType = this.toBooleanType(type2);
        if (newType != type2) {
            return newType;
        }
        return type2;
    }

    public IType dateType() {
        return this.getType(Date.class);
    }

    public IType doubleType() {
        return this.getType(Double.class);
    }

    public IType enumType() {
        return this.getType(Enum.class);
    }

    public IType floatType() {
        return this.getType(Float.class);
    }

    public IType getType(Class<?> type2) {
        return this.typeRepository.getType(type2);
    }

    public IType getType(String typeName) {
        return this.typeRepository.getType(typeName);
    }

    public ITypeRepository getTypeRepository() {
        return this.typeRepository;
    }

    public IType integerType() {
        return this.getType(Integer.class);
    }

    public boolean isBooleanType(IType type2) {
        return type2.equals(this.booleanType());
    }

    public boolean isCollectionType(IType type2) {
        return type2.isAssignableTo(this.collectionType());
    }

    public boolean isDateType(IType type2) {
        return type2.equals(this.dateType()) || type2.equals(this.timestampType()) || type2.equals(this.getType(Calendar.class));
    }

    public boolean isEnumType(IType type2) {
        return type2.isAssignableTo(this.enumType());
    }

    public boolean isFloatingType(IType type2) {
        return type2.equals(this.floatType()) || type2.equals(this.doubleType()) || type2.equals(this.primitiveFloat()) || type2.equals(this.primitiveDouble());
    }

    public boolean isIntegralType(IType type2) {
        return type2.equals(this.integerType()) || type2.equals(this.longType()) || type2.equals(this.shortType()) || type2.equals(this.characterType()) || type2.equals(this.primitiveInteger()) || type2.equals(this.primitiveLong()) || type2.equals(this.primitiveShort()) || type2.equals(this.primitiveChar());
    }

    public boolean isMapType(IType type2) {
        return type2.isAssignableTo(this.mapType());
    }

    public boolean isNumericType(IType type2) {
        return type2.isAssignableTo(this.numberType());
    }

    public boolean isObjectType(IType type2) {
        return type2.equals(this.objectType());
    }

    public boolean isPrimitiveType(IType type2) {
        return type2 == this.primitiveBoolean() || type2 == this.primitiveByte() || type2 == this.primitiveDouble() || type2 == this.primitiveFloat() || type2 == this.primitiveInteger() || type2 == this.primitiveLong() || type2 == this.primitiveShort();
    }

    public boolean isStringType(IType type2) {
        return type2.equals(this.stringType());
    }

    public IType longType() {
        return this.getType(Long.class);
    }

    public IType longType(IType type2) {
        if (type2.equals(this.primitiveLong())) {
            return this.longType();
        }
        return type2;
    }

    public IType mapType() {
        return this.getType(Map.class);
    }

    public IType numberType() {
        return this.getType(Number.class);
    }

    public IType objectType() {
        if (this.objectType == null) {
            this.objectType = this.getType(Object.class);
        }
        return this.objectType;
    }

    public ITypeDeclaration objectTypeDeclaration() {
        return this.objectType().getTypeDeclaration();
    }

    public IType primitiveBoolean() {
        return this.getType(Boolean.TYPE);
    }

    public IType primitiveByte() {
        return this.getType(Byte.TYPE);
    }

    public IType primitiveChar() {
        return this.getType(Character.TYPE);
    }

    public IType primitiveDouble() {
        return this.getType(Double.TYPE);
    }

    public IType primitiveFloat() {
        return this.getType(Float.TYPE);
    }

    public IType primitiveInteger() {
        return this.getType(Integer.TYPE);
    }

    public IType primitiveLong() {
        return this.getType(Long.TYPE);
    }

    public IType primitiveShort() {
        return this.getType(Short.TYPE);
    }

    public IType shortType() {
        return this.getType(Short.class);
    }

    public IType stringType() {
        if (this.stringType == null) {
            this.stringType = this.getType(String.class);
        }
        return this.stringType;
    }

    public IType timestampType() {
        return this.getType(Timestamp.class);
    }

    public IType toBooleanType(IType type2) {
        if (type2.equals(this.primitiveBoolean())) {
            return this.booleanType();
        }
        return type2;
    }

    public IType toByteType(IType type2) {
        if (type2.equals(this.primitiveByte())) {
            return this.byteType();
        }
        return type2;
    }

    public IType toDoubleType(IType type2) {
        if (type2.equals(this.primitiveDouble())) {
            return this.doubleType();
        }
        return type2;
    }

    public IType toFloatType(IType type2) {
        if (type2.equals(this.primitiveFloat())) {
            return this.floatType();
        }
        return type2;
    }

    public IType toIntegerType(IType type2) {
        if (type2.equals(this.primitiveInteger())) {
            return this.integerType();
        }
        return type2;
    }

    public IType toShortType(IType type2) {
        if (type2.equals(this.primitiveShort())) {
            return this.shortType();
        }
        return type2;
    }

    public IType unknownType() {
        if (this.unknownType == null) {
            this.unknownType = this.getType("UNRESOLVABLE_TYPE");
        }
        return this.unknownType;
    }

    public ITypeDeclaration unknownTypeDeclaration() {
        return this.unknownType().getTypeDeclaration();
    }
}

