/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.dynamic.metadata;

import jakarta.xml.bind.JAXBException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.jaxb.dynamic.metadata.Metadata;
import org.eclipse.persistence.jaxb.javamodel.Helper;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaModelInput;
import org.eclipse.persistence.jaxb.javamodel.oxm.OXMJavaClassImpl;
import org.eclipse.persistence.jaxb.javamodel.oxm.OXMJavaModelImpl;
import org.eclipse.persistence.jaxb.javamodel.oxm.OXMJavaModelInputImpl;
import org.eclipse.persistence.jaxb.javamodel.oxm.OXMObjectFactoryImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaClassImpl;
import org.eclipse.persistence.jaxb.xmlmodel.JavaType;
import org.eclipse.persistence.jaxb.xmlmodel.XmlBindings;
import org.eclipse.persistence.jaxb.xmlmodel.XmlEnum;
import org.eclipse.persistence.jaxb.xmlmodel.XmlEnumValue;
import org.eclipse.persistence.jaxb.xmlmodel.XmlRegistry;

public class OXMMetadata
extends Metadata {
    public OXMMetadata(DynamicClassLoader classLoader, Map<String, ?> properties) {
        super(classLoader, properties);
    }

    @Override
    public JavaModelInput getJavaModelInput() throws JAXBException {
        JavaClass[] elinkClasses = this.createClassModelFromOXM(this.dynamicClassLoader);
        OXMJavaModelImpl javaModel = new OXMJavaModelImpl((ClassLoader)this.dynamicClassLoader, elinkClasses);
        for (JavaClass javaClass : elinkClasses) {
            try {
                ((OXMJavaClassImpl)javaClass).setJavaModel(javaModel);
            }
            catch (ClassCastException cce) {
                try {
                    ((OXMObjectFactoryImpl)javaClass).setJavaModel(javaModel);
                    ((OXMObjectFactoryImpl)javaClass).init();
                }
                catch (ClassCastException cce2) {
                    ((JavaClassImpl)javaClass).setJavaModelImpl(javaModel);
                }
            }
        }
        return new OXMJavaModelInputImpl(elinkClasses, javaModel);
    }

    private JavaClass[] createClassModelFromOXM(DynamicClassLoader dynamicClassLoader) throws JAXBException {
        ArrayList<JavaClass> oxmJavaClasses = new ArrayList<JavaClass>();
        for (String pkgName : this.bindings.keySet()) {
            XmlBindings b = (XmlBindings)this.bindings.get(pkgName);
            if (b.getJavaTypes() != null) {
                List<JavaType> javaTypes = b.getJavaTypes().getJavaType();
                for (JavaType type2 : javaTypes) {
                    try {
                        Class<?> staticClass = dynamicClassLoader.getParent().loadClass(Helper.getQualifiedJavaTypeName(type2.getName(), pkgName));
                        oxmJavaClasses.add(new JavaClassImpl(staticClass, null));
                    }
                    catch (Exception ex) {
                        type2.setName(Helper.getQualifiedJavaTypeName(type2.getName(), pkgName));
                        oxmJavaClasses.add(new OXMJavaClassImpl(type2));
                    }
                }
            }
            if (b.getXmlRegistries() != null) {
                List<XmlRegistry> registries = b.getXmlRegistries().getXmlRegistry();
                for (XmlRegistry reg : registries) {
                    oxmJavaClasses.add(new OXMObjectFactoryImpl(reg));
                }
            }
            if (b.getXmlEnums() == null) continue;
            List<XmlEnum> enums = b.getXmlEnums().getXmlEnum();
            for (XmlEnum xmlEnum : enums) {
                List<XmlEnumValue> enumValues = xmlEnum.getXmlEnumValue();
                ArrayList<String> enumValueStrings = new ArrayList<String>();
                for (XmlEnumValue xmlEnumValue : enumValues) {
                    enumValueStrings.add(xmlEnumValue.getJavaEnumValue());
                }
                oxmJavaClasses.add(new OXMJavaClassImpl(xmlEnum.getJavaEnum(), enumValueStrings));
                dynamicClassLoader.addEnum(xmlEnum.getJavaEnum(), enumValueStrings.toArray());
            }
        }
        JavaClass[] javaClasses = new JavaClass[oxmJavaClasses.size()];
        for (int i = 0; i < javaClasses.length; ++i) {
            javaClasses[i] = (JavaClass)oxmJavaClasses.get(i);
        }
        return javaClasses;
    }
}

