/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.InterfaceAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.ObjectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotatedElement;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.columns.DiscriminatorClassMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.DiscriminatorColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.mappings.VariableOneToOneMapping;

public class VariableOneToOneAccessor
extends ObjectAccessor {
    public static final String DEFAULT_QUERY_KEY = "id";
    private Integer m_lastDiscriminatorIndex;
    private DiscriminatorColumnMetadata m_discriminatorColumn;
    private List<DiscriminatorClassMetadata> m_discriminatorClasses;

    public VariableOneToOneAccessor() {
        super("<variable-one-to-one>");
    }

    public VariableOneToOneAccessor(MetadataAnnotation variableOneToOne, MetadataAnnotatedElement annotatedElement, ClassAccessor classAccessor) {
        super(variableOneToOne, annotatedElement, classAccessor);
        this.m_discriminatorClasses = new ArrayList<DiscriminatorClassMetadata>();
        if (variableOneToOne != null) {
            this.setTargetEntity(this.getMetadataClass(variableOneToOne.getAttributeString("targetInterface")));
            this.setOrphanRemoval(variableOneToOne.getAttributeBooleanDefaultFalse("orphanRemoval"));
            this.m_discriminatorColumn = new DiscriminatorColumnMetadata(variableOneToOne.getAttributeAnnotation("discriminatorColumn"), this);
            for (Object discriminatorClass : variableOneToOne.getAttributeArray("discriminatorClasses")) {
                this.m_discriminatorClasses.add(new DiscriminatorClassMetadata((MetadataAnnotation)discriminatorClass, this));
            }
        }
    }

    public void addDiscriminatorClassFor(EntityAccessor accessor) {
        VariableOneToOneMapping mapping = (VariableOneToOneMapping)this.getDescriptor().getMappingForAttributeName(this.getAttributeName());
        accessor.getDescriptor().getClassDescriptor().getInterfacePolicy().addParentInterfaceName(mapping.getReferenceClassName());
        for (DiscriminatorClassMetadata discriminatorClass : this.m_discriminatorClasses) {
            if (!discriminatorClass.getValueClass().equals(accessor.getJavaClass())) continue;
            return;
        }
        Class<?> type2 = mapping.getTypeField().getType();
        if (type2.equals(String.class)) {
            mapping.addClassNameIndicator(accessor.getJavaClassName(), accessor.getDescriptor().getAlias());
        } else if (type2.equals(Character.class)) {
            mapping.addClassNameIndicator(accessor.getJavaClassName(), accessor.getJavaClassName().substring(0, 1));
        } else {
            if (this.m_lastDiscriminatorIndex == null) {
                for (String stringIndex : (List)mapping.getTypeIndicatorNameTranslation().values()) {
                    Integer index = Integer.valueOf(stringIndex);
                    if (this.m_lastDiscriminatorIndex != null && this.m_lastDiscriminatorIndex >= index) continue;
                    this.m_lastDiscriminatorIndex = index;
                }
            }
            this.m_lastDiscriminatorIndex = this.m_lastDiscriminatorIndex + 1;
            mapping.addClassNameIndicator(accessor.getJavaClassName(), this.m_lastDiscriminatorIndex);
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof VariableOneToOneAccessor) {
            VariableOneToOneAccessor variableOneToOneAccessor = (VariableOneToOneAccessor)objectToCompare;
            if (!this.valuesMatch(this.m_discriminatorColumn, variableOneToOneAccessor.getDiscriminatorColumn())) {
                return false;
            }
            return this.valuesMatch(this.m_discriminatorClasses, variableOneToOneAccessor.getDiscriminatorClasses());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.m_discriminatorColumn != null ? this.m_discriminatorColumn.hashCode() : 0);
        result = 31 * result + (this.m_discriminatorClasses != null ? this.m_discriminatorClasses.hashCode() : 0);
        return result;
    }

    public List<DiscriminatorClassMetadata> getDiscriminatorClasses() {
        return this.m_discriminatorClasses;
    }

    public DiscriminatorColumnMetadata getDiscriminatorColumn() {
        return this.m_discriminatorColumn;
    }

    @Override
    protected String getLoggingContext() {
        return "metadata_default_variable_one_to_one_reference_class";
    }

    @Override
    public MetadataDescriptor getReferenceDescriptor() {
        return this.getDescriptor();
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObject(this.m_discriminatorColumn, accessibleObject);
        this.initXMLObjects(this.m_discriminatorClasses, accessibleObject);
    }

    @Override
    public boolean isVariableOneToOne() {
        return true;
    }

    @Override
    public void process() {
        super.process();
        InterfaceAccessor interfaceAccessor = this.getProject().getInterfaceAccessor(this.getReferenceClassName());
        if (interfaceAccessor == null) {
            interfaceAccessor = new InterfaceAccessor(null, this.getReferenceClass(), this.getProject());
            interfaceAccessor.process();
            this.getProject().addInterfaceAccessor(interfaceAccessor);
        }
        interfaceAccessor.addVariableOneToOneAccessor(this);
        VariableOneToOneMapping mapping = new VariableOneToOneMapping();
        this.processRelationshipMapping(mapping);
        mapping.setIsOptional(this.isOptional());
        this.processIndirection(mapping);
        this.processReturnInsertAndUpdate();
        if (this.m_discriminatorColumn == null) {
            mapping.setTypeField(new DiscriminatorColumnMetadata(this).process(this.getDescriptor(), "metadata_default_variable_one_to_one_discriminator_column"));
        } else {
            mapping.setTypeField(this.m_discriminatorColumn.process(this.getDescriptor(), "metadata_default_variable_one_to_one_discriminator_column"));
        }
        for (DiscriminatorClassMetadata discriminatorClass : this.m_discriminatorClasses) {
            discriminatorClass.process(mapping);
        }
        this.processForeignQueryKeyNames(mapping);
    }

    protected void processForeignQueryKeyNames(VariableOneToOneMapping mapping) {
        for (JoinColumnMetadata joinColumn : this.getJoinColumns(this.getJoinColumns(), this.getReferenceDescriptor())) {
            String queryKeyName = this.getName(joinColumn.getReferencedColumnName(), DEFAULT_QUERY_KEY, "metadata_default_qk_column");
            DatabaseField fkField = joinColumn.getForeignKeyField(null);
            this.setFieldName(fkField, this.getDefaultAttributeName() + "_ID", "metadata_default_fk_column");
            if (fkField.getTableName().isEmpty()) {
                fkField.setTable(this.getDescriptor().getPrimaryTable());
            }
            mapping.addForeignQueryKeyName(fkField, queryKeyName);
            if (!fkField.isReadOnly()) continue;
            mapping.setIsReadOnly(true);
        }
    }

    public void setDiscriminatorClasses(List<DiscriminatorClassMetadata> discriminatorClasses) {
        this.m_discriminatorClasses = discriminatorClasses;
    }

    public void setDiscriminatorColumn(DiscriminatorColumnMetadata discriminatorColumn) {
        this.m_discriminatorColumn = discriminatorColumn;
    }
}

