/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import jakarta.persistence.AttributeNode;
import jakarta.persistence.EntityGraph;
import jakarta.persistence.Subgraph;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.MapAttribute;
import jakarta.persistence.metamodel.PluralAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.jpa.AttributeNodeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.AttributeImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.queries.AttributeItem;
import org.eclipse.persistence.internal.queries.MappedKeyMapContainerPolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.AttributeGroup;

public class EntityGraphImpl<X>
extends AttributeNodeImpl<X>
implements EntityGraph<X>,
Subgraph<X> {
    protected AttributeGroup attributeGroup;
    protected transient boolean isMutable = false;
    protected transient ClassDescriptor descriptor;
    protected Class<X> classType;
    protected Map<String, AttributeNodeImpl<?>> attributeNodes;

    protected EntityGraphImpl(AttributeGroup group, ClassDescriptor descriptor) {
        this.attributeGroup = group;
        this.classType = descriptor.getJavaClass();
        this.isMutable = true;
        this.descriptor = descriptor;
    }

    public EntityGraphImpl(AttributeGroup group) {
        this.attributeGroup = group;
        this.classType = group.getType();
        if (this.classType == null) {
            this.classType = CoreClassConstants.OBJECT;
        }
    }

    protected EntityGraphImpl(AttributeGroup group, ClassDescriptor descriptor, String attribute) {
        this(group, descriptor);
        this.currentAttribute = attribute;
    }

    @Override
    public String getName() {
        return this.attributeGroup.getName();
    }

    @Override
    public <Y> AttributeNode<Y> addAttributeNode(String attributeName) {
        if (!this.isMutable) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage("immutable_entitygraph"));
        }
        return this.addAttributeNodeImpl(attributeName);
    }

    @Override
    public <Y> AttributeNode<Y> addAttributeNode(Attribute<? super X, Y> attribute) {
        if (!this.isMutable) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage("immutable_entitygraph"));
        }
        return this.addAttributeNodeImpl(attribute.getName());
    }

    @Override
    public void addAttributeNodes(String ... attributeNames) {
        if (!this.isMutable) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage("immutable_entitygraph"));
        }
        for (String attrName : attributeNames) {
            this.addAttributeNodeImpl(attrName);
        }
    }

    @Override
    @SafeVarargs
    public final void addAttributeNodes(Attribute<? super X, ?> ... attributes) {
        if (!this.isMutable) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage("immutable_entitygraph"));
        }
        for (Attribute<X, ?> attribute : attributes) {
            this.addAttributeNodeImpl(attribute.getName());
        }
    }

    @Override
    public boolean hasAttributeNode(String attributeName) {
        return this.attributeNodes.containsKey(attributeName);
    }

    @Override
    public boolean hasAttributeNode(Attribute<? super X, ?> attribute) {
        return this.hasAttributeNode(attribute.getName());
    }

    @Override
    public <Y> AttributeNode<Y> getAttributeNode(String attributeName) {
        return this.attributeNodes.get(attributeName);
    }

    @Override
    public <Y> AttributeNode<Y> getAttributeNode(Attribute<? super X, Y> attribute) {
        return this.attributeNodes.get(attribute.getName());
    }

    @Override
    public void removeAttributeNode(String attributeName) {
        this.removeAttributeNodeImpl(attributeName);
    }

    @Override
    public void removeAttributeNode(Attribute<? super X, ?> attribute) {
        this.removeAttributeNodeImpl(attribute.getName());
    }

    @Override
    public void removeAttributeNodes(Attribute.PersistentAttributeType nodeTypes) {
        for (DatabaseMapping mapping : this.descriptor.getMappings()) {
            if (AttributeImpl.getPersistentAttributeType(mapping) != nodeTypes) continue;
            this.removeAttributeNodeImpl(mapping.getAttributeName());
        }
    }

    private <Y> AttributeNode<Y> addAttributeNodeImpl(String attributeName) {
        if (!this.isMutable) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage("immutable_entitygraph"));
        }
        if (this.descriptor.getMappingForAttributeName(attributeName) == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_not_present", new Object[]{attributeName, this.getClassType()}));
        }
        AttributeNodeImpl attributeNode = new AttributeNodeImpl(attributeName);
        this.addAttributeNodeImpl(attributeNode);
        this.attributeGroup.addAttribute(attributeName, (AttributeGroup)null);
        return attributeNode;
    }

    protected void addAttributeNodeImpl(AttributeNodeImpl<?> attributeNode) {
        if (this.attributeNodes == null) {
            this.buildAttributeNodes();
        }
        this.attributeNodes.put(attributeNode.getAttributeName(), attributeNode);
    }

    private void removeAttributeNodeImpl(String attributeName) {
        this.attributeGroup.removeAttribute(attributeName);
        this.attributeNodes.remove(attributeName);
    }

    @Override
    public <T> Subgraph<T> addSubgraph(Attribute<? super X, T> attribute) {
        Class<T> type2 = attribute.getJavaType();
        if (attribute.isCollection()) {
            type2 = ((PluralAttribute)attribute).getBindableJavaType();
        }
        return this.addSubgraph(attribute.getName(), type2);
    }

    @Override
    public <S extends X> Subgraph<S> addTreatedSubgraph(Class<S> type2) {
        if (!this.isMutable) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage("immutable_entitygraph"));
        }
        ClassDescriptor targetDesc = this.descriptor;
        if (targetDesc.hasInheritance() && (targetDesc = targetDesc.getInheritancePolicy().getDescriptor(type2)) == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("type_unkown_for_this_entity", new Object[]{type2.getName(), this.descriptor.getJavaClassName()}));
        }
        AttributeGroup subGroup = new AttributeGroup(this.attributeGroup.getName(), type2, true);
        this.attributeGroup.getSubClassGroups().put(type2, subGroup);
        subGroup.setAllSubclasses(this.attributeGroup.getSubClassGroups());
        this.attributeGroup.insertSubClass(subGroup);
        return new EntityGraphImpl<X>(subGroup, targetDesc);
    }

    @Override
    public <T> Subgraph<? extends T> addSubclassSubgraph(Class<? extends T> type2) {
        return this.addTreatedSubgraph(type2);
    }

    @Override
    public <Y> Subgraph<Y> addTreatedSubgraph(Attribute<? super X, ? super Y> attribute, Class<Y> type2) {
        return this.addSubgraph(attribute.getName(), type2);
    }

    @Override
    public <T> Subgraph<? extends T> addSubgraph(Attribute<? super X, T> attribute, Class<? extends T> type2) {
        return this.addSubgraph(attribute.getName(), (Class<T>)type2);
    }

    @Override
    public <T> Subgraph<T> addSubgraph(String attributeName) {
        return this.addSubgraph(attributeName, (Class<T>)null);
    }

    @Override
    public <T> Subgraph<T> addSubgraph(String attributeName, Class<T> type2) {
        if (!this.isMutable) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage("immutable_entitygraph"));
        }
        AttributeNodeImpl<Object> node = null;
        if (this.attributeNodes != null) {
            node = this.attributeNodes.get(attributeName);
        }
        if (node == null) {
            node = new AttributeNodeImpl(attributeName);
            this.addAttributeNodeImpl(node);
        }
        AttributeGroup localGroup = null;
        DatabaseMapping mapping = this.descriptor.getMappingForAttributeName(attributeName);
        if (mapping == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_not_present", new Object[]{attributeName, this.descriptor.getJavaClassName()}));
        }
        localGroup = new AttributeGroup(attributeName, type2, true);
        ClassDescriptor targetDesc = mapping.getReferenceDescriptor();
        if (type2 != null && targetDesc.hasInheritance() && (targetDesc = targetDesc.getInheritancePolicy().getDescriptor(type2)) == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("type_unkown_for_this_attribute", new Object[]{type2.getName(), attributeName}));
        }
        EntityGraphImpl<X> entityGraph = new EntityGraphImpl<X>(localGroup, targetDesc, attributeName);
        node.addSubgraph(entityGraph);
        this.attributeGroup.addAttribute(attributeName, localGroup);
        return entityGraph;
    }

    @Override
    public <X1> Subgraph<X1> addElementSubgraph(String attributeName) {
        return this.addKeySubgraph(attributeName, (Class<T>)null);
    }

    @Override
    public <X1> Subgraph<X1> addElementSubgraph(String attributeName, Class<X1> type2) {
        return this.addKeySubgraph(attributeName, type2);
    }

    @Override
    public <E> Subgraph<E> addElementSubgraph(PluralAttribute<? super X, ?, E> attribute) {
        return this.addKeySubgraph(attribute.getName(), (Class<T>)attribute.getBindableJavaType());
    }

    @Override
    public <E> Subgraph<E> addTreatedElementSubgraph(PluralAttribute<? super X, ?, ? super E> attribute, Class<E> type2) {
        return this.addKeySubgraph(attribute.getName(), type2);
    }

    @Override
    public <K> Subgraph<K> addMapKeySubgraph(MapAttribute<? super X, K, ?> attribute) {
        return this.addKeySubgraph(attribute.getName(), attribute.getKeyJavaType());
    }

    @Override
    public <K> Subgraph<K> addTreatedMapKeySubgraph(MapAttribute<? super X, ? super K, ?> attribute, Class<K> type2) {
        return this.addKeySubgraph(attribute.getName(), type2);
    }

    @Override
    public <T> Subgraph<T> addKeySubgraph(Attribute<? super X, T> attribute) {
        if (!this.isMutable) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage("immutable_entitygraph"));
        }
        Class<T> type2 = attribute.getJavaType();
        if (attribute.isCollection()) {
            type2 = ((PluralAttribute)attribute).getBindableJavaType();
        }
        return this.addKeySubgraph(attribute.getName(), type2);
    }

    @Override
    public <T> Subgraph<? extends T> addKeySubgraph(Attribute<? super X, T> attribute, Class<? extends T> type2) {
        return this.addKeySubgraph(attribute.getName(), (Class<T>)type2);
    }

    @Override
    public <T> Subgraph<T> addKeySubgraph(String attributeName) {
        return this.addKeySubgraph(attributeName, (Class<T>)null);
    }

    @Override
    public <T> Subgraph<T> addKeySubgraph(String attributeName, Class<T> type2) {
        if (!this.isMutable) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage("immutable_entitygraph"));
        }
        AttributeNodeImpl<Object> node = null;
        if (this.attributeNodes != null) {
            node = this.attributeNodes.get(attributeName);
        }
        if (node == null) {
            node = new AttributeNodeImpl(attributeName);
            this.addAttributeNodeImpl(node);
        }
        AttributeGroup localGroup = null;
        DatabaseMapping mapping = this.descriptor.getMappingForAttributeName(attributeName);
        if (mapping == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_not_present", new Object[]{this.descriptor.getJavaClassName(), attributeName}));
        }
        if (!mapping.getContainerPolicy().isMappedKeyMapPolicy() && !((MappedKeyMapContainerPolicy)mapping.getContainerPolicy()).isMapKeyAttribute()) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("attribute_is_not_map_with_managed_key", new Object[]{attributeName, this.descriptor.getJavaClassName()}));
        }
        localGroup = new AttributeGroup(attributeName, type2, true);
        ClassDescriptor targetDesc = mapping.getContainerPolicy().getDescriptorForMapKey();
        if (type2 != null && targetDesc.hasInheritance() && (targetDesc = targetDesc.getInheritancePolicy().getDescriptor(type2)) == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("type_unkown_for_this_attribute", new Object[]{type2.getName(), attributeName}));
        }
        EntityGraphImpl<X> entityGraph = new EntityGraphImpl<X>(localGroup, targetDesc, attributeName);
        node.addKeySubgraph(entityGraph);
        this.attributeGroup.addAttributeKey(attributeName, localGroup);
        return entityGraph;
    }

    @Override
    public List<AttributeNode<?>> getAttributeNodes() {
        if (this.attributeNodes == null) {
            this.buildAttributeNodes();
        }
        return new ArrayList(this.attributeNodes.values());
    }

    @Override
    public Class<X> getClassType() {
        return this.classType;
    }

    public AttributeGroup getAttributeGroup() {
        return this.attributeGroup;
    }

    @Override
    public String getAttributeName() {
        return this.currentAttribute;
    }

    protected void buildAttributeNodes() {
        this.attributeNodes = new HashMap();
        for (AttributeItem item : this.attributeGroup.getItems().values()) {
            Class<Object> type2;
            AttributeNodeImpl node = new AttributeNodeImpl(item.getAttributeName());
            ClassDescriptor localDescriptor = null;
            if (this.descriptor != null) {
                localDescriptor = this.descriptor.getMappingForAttributeName(item.getAttributeName()).getReferenceDescriptor();
            }
            if (item.getGroups() != null && !item.getGroups().isEmpty()) {
                for (AttributeGroup subGroup : item.getGroups().values()) {
                    type2 = subGroup.getType();
                    if (type2 == null) {
                        type2 = CoreClassConstants.OBJECT;
                    }
                    if (localDescriptor != null) {
                        if (!type2.equals(CoreClassConstants.OBJECT) && localDescriptor.hasInheritance()) {
                            localDescriptor = localDescriptor.getInheritancePolicy().getDescriptor(type2);
                        }
                        node.addSubgraph(new EntityGraphImpl<X>(subGroup, localDescriptor));
                        continue;
                    }
                    node.addSubgraph(new EntityGraphImpl<X>(subGroup));
                }
            }
            if (item.getKeyGroups() != null && !item.getKeyGroups().isEmpty()) {
                for (AttributeGroup subGroup : item.getKeyGroups().values()) {
                    type2 = subGroup.getType();
                    if (type2 == null) {
                        type2 = CoreClassConstants.OBJECT;
                    }
                    if (localDescriptor != null) {
                        if (!type2.equals(CoreClassConstants.OBJECT) && localDescriptor.hasInheritance()) {
                            localDescriptor = localDescriptor.getInheritancePolicy().getDescriptor(type2);
                        }
                        node.addKeySubgraph(new EntityGraphImpl<X>(subGroup, localDescriptor));
                        continue;
                    }
                    node.addKeySubgraph(new EntityGraphImpl<X>(subGroup));
                }
            }
            this.attributeNodes.put(item.getAttributeName(), node);
        }
    }
}

