/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.codegen;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.persistence.internal.codegen.AttributeDefinition;
import org.eclipse.persistence.internal.codegen.CodeDefinition;
import org.eclipse.persistence.internal.codegen.CodeGenerator;
import org.eclipse.persistence.internal.codegen.MethodDefinition;

public class ClassDefinition
extends CodeDefinition {
    protected String packageName = "";
    protected Set<String> imports = new TreeSet<String>();
    protected int type = 1;
    public static final int CLASS_TYPE = 1;
    public static final int INTERFACE_TYPE = 2;
    protected String superClass;
    protected List<String> interfaces = new ArrayList<String>(3);
    protected List<AttributeDefinition> attributes = new ArrayList<AttributeDefinition>();
    protected List<MethodDefinition> methods = new ArrayList<MethodDefinition>();
    protected Set<ClassDefinition> innerClasses = new TreeSet<ClassDefinition>(Comparator.comparing(CodeDefinition::getName));

    public void addAttribute(AttributeDefinition attribute) {
        this.getAttributes().add(attribute);
    }

    public void addImport(String importStatement) {
        this.getImports().add(importStatement);
    }

    private void addImports(Map<String, Set<String>> typeNameMap) {
        for (Map.Entry<String, Set<String>> entry : typeNameMap.entrySet()) {
            String shortName = entry.getKey();
            Set<String> packageNames = entry.getValue();
            if (packageNames.size() > 1) continue;
            for (String packageName : packageNames) {
                if (packageName.equals("java.lang") || packageName.equals(this.getPackageName()) || packageName.isEmpty()) continue;
                this.addImport(packageName + "." + shortName);
            }
        }
    }

    public void addInnerClass(ClassDefinition classDefinition) {
        this.imports.addAll(classDefinition.imports);
        classDefinition.imports.clear();
        this.getInnerClasses().add(classDefinition);
    }

    public void addInterface(String interfaceClassName) {
        this.getInterfaces().add(interfaceClassName);
    }

    public void addMethod(MethodDefinition method) {
        this.getMethods().add(method);
    }

    private void addTypeNamesToMap(HashMap<String, Set<String>> typeNameMap) {
        ClassDefinition.putTypeNameInMap(this.getSuperClass(), typeNameMap);
        for (String s : this.getInterfaces()) {
            ClassDefinition.putTypeNameInMap(s, typeNameMap);
        }
        for (AttributeDefinition attributeDefinition : this.getAttributes()) {
            attributeDefinition.putTypeNamesInMap(typeNameMap);
        }
        for (MethodDefinition methodDefinition : this.getMethods()) {
            methodDefinition.putTypeNamesInMap(typeNameMap);
        }
    }

    private void adjustTypeNames(HashMap<String, Set<String>> typeNameMap) {
        this.setSuperClass(ClassDefinition.adjustTypeName(this.getSuperClass(), typeNameMap));
        for (String interfaceName : new ArrayList<String>(this.getInterfaces())) {
            this.replaceInterface(interfaceName, ClassDefinition.adjustTypeName(interfaceName, typeNameMap));
        }
        for (AttributeDefinition attributeDefinition : this.getAttributes()) {
            attributeDefinition.adjustTypeNames(typeNameMap);
        }
        for (MethodDefinition methodDefinition : this.getMethods()) {
            methodDefinition.adjustTypeNames(typeNameMap);
        }
    }

    public void calculateImports() {
        HashMap<String, Set<String>> typeNameMap = new HashMap<String, Set<String>>();
        this.addTypeNamesToMap(typeNameMap);
        this.adjustTypeNames(typeNameMap);
        this.addImports(typeNameMap);
    }

    public boolean containsMethod(MethodDefinition method) {
        return this.getMethods().contains(method);
    }

    protected List<AttributeDefinition> getAttributes() {
        return this.attributes;
    }

    protected Set<String> getImports() {
        return this.imports;
    }

    protected Set<ClassDefinition> getInnerClasses() {
        return this.innerClasses;
    }

    protected List<String> getInterfaces() {
        return this.interfaces;
    }

    protected List<MethodDefinition> getMethods() {
        return this.methods;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getSuperClass() {
        return this.superClass;
    }

    public int getType() {
        return this.type;
    }

    public boolean isInterface() {
        return this.getType() == 2;
    }

    protected void replaceInterface(String oldInterfaceName, String newInterfaceName) {
        if (!oldInterfaceName.equals(newInterfaceName)) {
            this.interfaces.remove(oldInterfaceName);
            this.interfaces.add(newInterfaceName);
        }
    }

    private void setImports(Set<String> imports) {
        this.imports = imports;
    }

    private void setMethods(List<MethodDefinition> methods) {
        this.methods = methods;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setSuperClass(String superClass) {
        this.superClass = superClass;
    }

    public void setType(int type2) {
        this.type = type2;
    }

    protected void sortMethods() {
        Comparator comparison = (first, second) -> {
            if (first.isConstructor()) {
                return -1;
            }
            if (second.isConstructor()) {
                return 1;
            }
            return first.getName().compareTo(second.getName());
        };
        this.getMethods().sort(comparison);
    }

    @Override
    public void write(CodeGenerator generator) {
        if (!this.getPackageName().isEmpty()) {
            generator.write("package ");
            generator.write(this.getPackageName());
            generator.writeln(";");
            generator.cr();
        }
        for (String importLine : this.getImports()) {
            generator.write("import ");
            generator.write(importLine);
            generator.writeln(";");
        }
        if (!this.getImports().isEmpty()) {
            generator.cr();
        }
        super.write(generator);
    }

    @Override
    public void writeBody(CodeGenerator generator) {
        this.sortMethods();
        if (this.isInterface()) {
            generator.write("interface ");
        } else {
            generator.write("class ");
        }
        generator.write(this.getName());
        if (!this.isInterface() && this.getSuperClass() != null) {
            generator.write(" extends ");
            generator.writeType(this.getSuperClass());
        }
        boolean isFirst = true;
        for (String interfaceName : this.getInterfaces()) {
            if (isFirst) {
                if (this.isInterface()) {
                    generator.write(" extends");
                } else {
                    generator.write(" implements");
                }
                isFirst = false;
            } else {
                generator.write(",");
            }
            generator.write(" ");
            generator.write(interfaceName);
        }
        generator.writeln(" {");
        generator.cr();
        for (AttributeDefinition attributeDefinition : this.getAttributes()) {
            generator.tab();
            attributeDefinition.write(generator);
            generator.cr();
        }
        if (!this.getAttributes().isEmpty()) {
            generator.cr();
        }
        for (MethodDefinition methodDefinition : this.getMethods()) {
            methodDefinition.write(generator);
            generator.cr();
            generator.cr();
        }
        for (ClassDefinition classDefinition : this.getInnerClasses()) {
            classDefinition.write(generator);
            generator.cr();
            generator.cr();
        }
        generator.writeln("}");
    }
}

